/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.configuration;

import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.AzureException;
import com.azure.core.util.UrlBuilder;
import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import oracle.jdbc.provider.azure.authentication.TokenCredentialFactory;
import oracle.jdbc.provider.azure.configuration.AzureAppConfigurationURLParser;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.spi.OracleConfigurationCachableProvider;
import oracle.jdbc.util.OracleConfigurationCache;
import oracle.jdbc.util.OracleConfigurationProviderNetworkError;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public class AzureAppConfigurationProvider
implements OracleConfigurationCachableProvider {
    private static final OracleJsonFactory JSON_FACTORY = new OracleJsonFactory();
    private static final String CONNECT_DESCRIPTOR_PROPERTIES_NAME = "connect_descriptor";
    private static final String WALLET_LOCATION_PROPERTIES_NAME = "wallet_location";
    private static final String JDBC_PROPERTIES_PREFIX = "jdbc/";
    private static final String CONFIG_TTL_JSON_OBJECT_NAME = "config_time_to_live";
    private static final long MS_REFRESH_TIMEOUT = 60000L;
    private static final long MS_RETRY_INTERVAL = 60000L;
    private final OracleConfigurationCache cache = OracleConfigurationCache.create((int)100);

    public Properties getConnectionProperties(String location) {
        Properties cachedProp = this.cache.get(location);
        if (Objects.nonNull(cachedProp)) {
            return cachedProp;
        }
        Properties properties = this.getRemoteProperties(location);
        if (properties.containsKey(CONFIG_TTL_JSON_OBJECT_NAME)) {
            long configTimeToLive = Long.parseLong(properties.getProperty(CONFIG_TTL_JSON_OBJECT_NAME));
            properties.remove(CONFIG_TTL_JSON_OBJECT_NAME);
            this.cache.put(location, properties, configTimeToLive, () -> this.refreshProperties(location), 60000L, 60000L);
        } else {
            this.cache.put(location, properties, () -> this.refreshProperties(location), 60000L, 60000L);
        }
        return properties;
    }

    public String getType() {
        return "azure";
    }

    private Properties getRemoteProperties(String location) {
        AzureAppConfigurationURLParser appConfig = new AzureAppConfigurationURLParser(location);
        ParameterSet parameters = appConfig.getParameters();
        TokenCredential credential = (TokenCredential)TokenCredentialFactory.getInstance().request(parameters).getContent();
        String prefix = appConfig.getPrefix();
        SettingSelector selector = new SettingSelector();
        if (prefix != null) {
            selector.setKeyFilter(prefix + "*");
        }
        if (parameters.contains(AzureAppConfigurationURLParser.LABEL)) {
            selector.setLabelFilter((String)parameters.getOptional(AzureAppConfigurationURLParser.LABEL));
        }
        ConfigurationClient configurationClient = new ConfigurationClientBuilder().credential(credential).endpoint("https://" + appConfig.getName() + ".azconfig.io").buildClient();
        Properties properties = new Properties();
        for (ConfigurationSetting config : configurationClient.listConfigurationSettings(selector)) {
            String value;
            String key = config.getKey();
            if (prefix != null && key.startsWith(prefix)) {
                key = key.substring(prefix.length());
            }
            if (key.startsWith(JDBC_PROPERTIES_PREFIX)) {
                key = key.substring(JDBC_PROPERTIES_PREFIX.length());
            }
            String string = value = config.getContentType() == null || config.getContentType().isEmpty() ? config.getValue() : this.getSecretValue(credential, config.getValue());
            if (key.startsWith(CONNECT_DESCRIPTOR_PROPERTIES_NAME)) {
                key = "URL";
                value = "jdbc:oracle:thin:@" + value;
            }
            if (key.startsWith(WALLET_LOCATION_PROPERTIES_NAME)) {
                key = "oracle.net.wallet_location";
                value = "data:;base64," + value;
            }
            properties.put(key, value);
        }
        if (!properties.containsKey("URL")) {
            throw new IllegalArgumentException("Missing mandatory attributes: connect_descriptor");
        }
        return properties;
    }

    private String getSecretValue(TokenCredential credential, String secretReference) {
        ByteArrayInputStream secretRefStream = new ByteArrayInputStream(secretReference.getBytes());
        OracleJsonObject json = JSON_FACTORY.createJsonTextValue((InputStream)secretRefStream).asJsonObject();
        String vaultUrlAndName = ((OracleJsonValue)json.get((Object)"uri")).asJsonString().getString();
        UrlBuilder urlBuilder = UrlBuilder.parse((String)vaultUrlAndName);
        String vaultUrl = "https://" + urlBuilder.getHost();
        String name = urlBuilder.getPath().replace("/secrets", "");
        SecretClient secretClient = new SecretClientBuilder().vaultUrl(vaultUrl).credential(credential).buildClient();
        return secretClient.getSecret(name).getValue();
    }

    private Properties refreshProperties(String location) throws OracleConfigurationProviderNetworkError {
        try {
            return this.getRemoteProperties(location);
        }
        catch (AzureException e) {
            throw new OracleConfigurationProviderNetworkError((Exception)((Object)e));
        }
    }

    public Properties removeProperties(String location) {
        Properties deletedProp = this.cache.remove(location);
        return deletedProp;
    }
}

