/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.configuration;

import com.azure.core.util.UrlBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import java.util.Base64;
import oracle.jdbc.provider.azure.configuration.AzureConfigurationParameters;
import oracle.jdbc.provider.azure.keyvault.KeyVaultSecretFactory;
import oracle.jdbc.provider.configuration.JsonSecretUtil;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.parameter.ParameterSetBuilder;
import oracle.jdbc.provider.parameter.ParameterSetParser;
import oracle.jdbc.spi.OracleConfigurationJsonSecretProvider;
import oracle.sql.json.OracleJsonObject;

public final class AzureVaultSecretProvider
implements OracleConfigurationJsonSecretProvider {
    private static final ParameterSetParser PARAMETER_SET_PARSER = AzureConfigurationParameters.configureBuilder(ParameterSetParser.builder().addParameter("value", AzureVaultSecretProvider::parseVaultSecretUri)).build();

    public char[] getSecret(OracleJsonObject secretJsonObject) {
        ParameterSet parameterSet = PARAMETER_SET_PARSER.parseNamedValues(JsonSecretUtil.toNamedValues((OracleJsonObject)secretJsonObject));
        String secretString = ((KeyVaultSecret)KeyVaultSecretFactory.getInstance().request(parameterSet).getContent()).getValue();
        return Base64.getEncoder().encodeToString(secretString.getBytes()).toCharArray();
    }

    public String getSecretType() {
        return "vault-azure";
    }

    private static void parseVaultSecretUri(String vaultSecretUri, ParameterSetBuilder builder) {
        UrlBuilder urlBuilder = UrlBuilder.parse((String)vaultSecretUri);
        String vaultUrl = "https://" + urlBuilder.getHost();
        builder.add("value", KeyVaultSecretFactory.VAULT_URL, (Object)vaultUrl);
        String path = urlBuilder.getPath();
        if (!path.contains("/secrets")) {
            throw new IllegalArgumentException("The Vault Secret URI should contain \"/secrets\" following by the name of the Secret: " + vaultSecretUri);
        }
        String secretName = path.replace("/secrets", "");
        builder.add("value", KeyVaultSecretFactory.SECRET_NAME, (Object)secretName);
    }
}

