/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.authentication;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Configuration;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.ChainedTokenCredentialBuilder;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.identity.DeviceCodeCredentialBuilder;
import com.azure.identity.InteractiveBrowserCredential;
import com.azure.identity.InteractiveBrowserCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.identity.UsernamePasswordCredentialBuilder;
import java.util.Locale;
import oracle.jdbc.provider.azure.authentication.AzureAuthenticationMethod;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;

public final class TokenCredentialFactory
implements ResourceFactory<TokenCredential> {
    public static final Parameter<AzureAuthenticationMethod> AUTHENTICATION_METHOD = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    public static final Parameter<String> TENANT_ID = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<String> CLIENT_ID = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<String> CLIENT_SECRET = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.SENSITIVE});
    public static final Parameter<String> CLIENT_CERTIFICATE_PATH = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<String> CLIENT_CERTIFICATE_PASSWORD = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.SENSITIVE});
    public static final Parameter<String> USERNAME = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<String> PASSWORD = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.SENSITIVE});
    public static final Parameter<String> REDIRECT_URL = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    private static final TokenCredentialFactory INSTANCE = new TokenCredentialFactory();

    private TokenCredentialFactory() {
    }

    public static TokenCredentialFactory getInstance() {
        return INSTANCE;
    }

    public Resource<TokenCredential> request(ParameterSet parameterSet) {
        TokenCredential tokenCredential = TokenCredentialFactory.getCredential(parameterSet);
        return Resource.createPermanentResource((Object)tokenCredential, (boolean)true);
    }

    private static TokenCredential getCredential(ParameterSet parameterSet) {
        AzureAuthenticationMethod authenticationMethod = (AzureAuthenticationMethod)((Object)parameterSet.getRequired(AUTHENTICATION_METHOD));
        switch (authenticationMethod) {
            case DEFAULT: {
                return TokenCredentialFactory.defaultCredentials(parameterSet);
            }
            case AUTO_DETECT: {
                return TokenCredentialFactory.autoDetectCredentials(parameterSet);
            }
            case SERVICE_PRINCIPLE: {
                return TokenCredentialFactory.servicePrincipalCredentials(parameterSet);
            }
            case MANAGED_IDENTITY: {
                return TokenCredentialFactory.managedIdentityCredentials(parameterSet);
            }
            case PASSWORD: {
                return TokenCredentialFactory.passwordCredentials(parameterSet);
            }
            case DEVICE_CODE: {
                return TokenCredentialFactory.deviceCodeCredentials(parameterSet);
            }
            case INTERACTIVE: {
                return TokenCredentialFactory.interactiveCredentials(parameterSet);
            }
        }
        throw new IllegalArgumentException("Unrecognized authentication method: " + (Object)((Object)authenticationMethod));
    }

    private static TokenCredential defaultCredentials(ParameterSet parameterSet) {
        return new DefaultAzureCredentialBuilder().tenantId(TokenCredentialFactory.optionalParameter(parameterSet, TENANT_ID, "AZURE_TENANT_ID")).managedIdentityClientId(TokenCredentialFactory.optionalParameter(parameterSet, CLIENT_ID, "AZURE_CLIENT_ID")).build();
    }

    private static InteractiveBrowserCredential interactiveCredentials(ParameterSet parameterSet) {
        return ((InteractiveBrowserCredentialBuilder)new InteractiveBrowserCredentialBuilder().clientId((String)parameterSet.getOptional(CLIENT_ID))).redirectUrl((String)parameterSet.getRequired(REDIRECT_URL)).build();
    }

    private static TokenCredential servicePrincipalCredentials(ParameterSet parameters) {
        String secret = (String)parameters.getOptional(CLIENT_SECRET);
        if (secret != null) {
            return TokenCredentialFactory.clientSecretCredentials(parameters, secret);
        }
        String certificate = (String)parameters.getOptional(CLIENT_CERTIFICATE_PATH);
        if (certificate != null) {
            return TokenCredentialFactory.clientCertificateCredentials(parameters, certificate);
        }
        String sdkSecret = Configuration.getGlobalConfiguration().get("AZURE_CLIENT_SECRET");
        if (sdkSecret != null) {
            return TokenCredentialFactory.clientSecretCredentials(parameters, sdkSecret);
        }
        String sdkCertificate = Configuration.getGlobalConfiguration().get("AZURE_CLIENT_CERTIFICATE_PATH");
        if (sdkCertificate != null) {
            return TokenCredentialFactory.clientCertificateCredentials(parameters, sdkCertificate);
        }
        throw new IllegalStateException("Unable to authenticate as a service principal: Neither a secret nor a certificate is configured");
    }

    private static TokenCredential clientSecretCredentials(ParameterSet parameters, String secret) {
        return TokenCredentialFactory.configureBuilder(parameters, new ClientSecretCredentialBuilder()).clientSecret(secret).build();
    }

    private static TokenCredential clientCertificateCredentials(ParameterSet parameters, String certificatePath) {
        ClientCertificateCredentialBuilder builder = TokenCredentialFactory.configureBuilder(parameters, new ClientCertificateCredentialBuilder());
        if (certificatePath.toLowerCase(Locale.getDefault()).endsWith(".pfx")) {
            builder.pfxCertificate(certificatePath, (String)parameters.getOptional(CLIENT_CERTIFICATE_PASSWORD));
        } else {
            builder.pemCertificate(certificatePath);
        }
        return builder.build();
    }

    private static <T extends AadCredentialBuilderBase<T>> T configureBuilder(ParameterSet parameters, T builder) {
        return (T)builder.clientId(TokenCredentialFactory.requireParameter(parameters, CLIENT_ID, "AZURE_CLIENT_ID")).tenantId(TokenCredentialFactory.requireParameter(parameters, TENANT_ID, "AZURE_TENANT_ID"));
    }

    private static TokenCredential managedIdentityCredentials(ParameterSet parameters) {
        return new ManagedIdentityCredentialBuilder().clientId((String)parameters.getOptional(CLIENT_ID)).build();
    }

    private static TokenCredential passwordCredentials(ParameterSet parameters) {
        return ((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)new UsernamePasswordCredentialBuilder().tenantId(TokenCredentialFactory.optionalParameter(parameters, TENANT_ID, "AZURE_TENANT_ID"))).clientId(TokenCredentialFactory.requireParameter(parameters, CLIENT_ID, "AZURE_CLIENT_ID"))).username(TokenCredentialFactory.requireParameter(parameters, USERNAME, "AZURE_USERNAME")).password(TokenCredentialFactory.requireParameter(parameters, PASSWORD, "AZURE_PASSWORD")).build();
    }

    private static TokenCredential deviceCodeCredentials(ParameterSet parameters) {
        return ((DeviceCodeCredentialBuilder)((DeviceCodeCredentialBuilder)new DeviceCodeCredentialBuilder().tenantId(TokenCredentialFactory.optionalParameter(parameters, TENANT_ID, "AZURE_TENANT_ID"))).clientId(TokenCredentialFactory.optionalParameter(parameters, CLIENT_ID, "AZURE_CLIENT_ID"))).challengeConsumer(challenge -> System.out.println(challenge.getMessage())).build();
    }

    private static TokenCredential autoDetectCredentials(ParameterSet parameters) {
        ChainedTokenCredentialBuilder builder = new ChainedTokenCredentialBuilder();
        if (parameters.contains(CLIENT_ID) || parameters.contains(CLIENT_SECRET) || parameters.contains(CLIENT_CERTIFICATE_PATH) || parameters.contains(CLIENT_CERTIFICATE_PASSWORD)) {
            builder.addLast(TokenCredentialFactory.servicePrincipalCredentials(parameters));
        }
        if (parameters.contains(USERNAME) || parameters.contains(PASSWORD)) {
            builder.addLast(TokenCredentialFactory.passwordCredentials(parameters));
        }
        builder.addLast(TokenCredentialFactory.defaultCredentials(parameters));
        return builder.build();
    }

    private static String requireParameter(ParameterSet parameters, Parameter<String> parameter, String sdkName) {
        try {
            return (String)parameters.getRequired(parameter);
        }
        catch (IllegalStateException parameterNotConfigured) {
            String sdkValue = Configuration.getGlobalConfiguration().get(sdkName);
            if (sdkValue != null) {
                return sdkValue;
            }
            throw new IllegalArgumentException(String.format("No value is configured for parameter \"%s\", or SDK variable \"%s\"", parameters.getName(parameter), sdkName), parameterNotConfigured);
        }
    }

    private static String optionalParameter(ParameterSet parameters, Parameter<String> parameter, String sdkName) {
        String value = (String)parameters.getOptional(parameter);
        if (value != null) {
            return value;
        }
        if (sdkName != null) {
            return Configuration.getGlobalConfiguration().get(sdkName);
        }
        return null;
    }
}

