/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.aws.secrets;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public class AwsSecretExtractor {
    private static final OracleJsonFactory JSON_FACTORY = new OracleJsonFactory();

    public static String extractSecret(String secretString, String fieldName) {
        String normalizedFieldName = fieldName != null && fieldName.trim().isEmpty() ? null : fieldName;
        try {
            OracleJsonObject jsonObject = JSON_FACTORY.createJsonTextValue((InputStream)new ByteArrayInputStream(secretString.getBytes(StandardCharsets.UTF_8))).asJsonObject();
            if (normalizedFieldName != null) {
                if (!jsonObject.containsKey((Object)fieldName)) {
                    throw new IllegalStateException("Field '" + normalizedFieldName + "' not found in secret JSON.");
                }
                return ((OracleJsonValue)jsonObject.get((Object)normalizedFieldName)).asJsonString().getString();
            }
            if (jsonObject.size() == 1) {
                return ((OracleJsonValue)jsonObject.values().iterator().next()).asJsonString().getString();
            }
            throw new IllegalStateException("FIELD_NAME is required when multiple keys exist in the secret JSON");
        }
        catch (OracleJsonException e) {
            if (normalizedFieldName != null) {
                throw new IllegalStateException("FIELD_NAME provided, but secret is not valid JSON.");
            }
            return secretString;
        }
    }
}

