/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.aws.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import oracle.jdbc.provider.aws.resource.SecretsManagerSecretProvider;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.provider.util.CommonParameters;
import oracle.jdbc.provider.util.FileUtils;
import oracle.jdbc.provider.util.TNSNames;
import oracle.jdbc.spi.ConnectionStringProvider;
import oracle.jdbc.spi.OracleResourceProvider;

public class SecretsManagerConnectionStringProvider
extends SecretsManagerSecretProvider
implements ConnectionStringProvider {
    private static final ResourceParameter[] PARAMETERS = new ResourceParameter[]{new ResourceParameter("tnsAlias", CommonParameters.TNS_ALIAS)};

    public SecretsManagerConnectionStringProvider() {
        super("secrets-manager-tnsnames", PARAMETERS);
    }

    public String getConnectionString(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        String string;
        String alias = (String)this.parseParameterValues(parameterValues).getRequired(CommonParameters.TNS_ALIAS);
        byte[] fileBytes = FileUtils.decodeIfBase64((byte[])this.getSecret(parameterValues).getBytes());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBytes);
        try {
            TNSNames tnsNames = TNSNames.read((InputStream)inputStream);
            String connectionString = tnsNames.getConnectionStringByAlias(alias);
            if (connectionString == null) {
                throw new IllegalArgumentException("Alias specified does not exist in tnsnames.ora: " + alias);
            }
            string = connectionString;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read tnsnames.ora content", e);
            }
        }
        ((InputStream)inputStream).close();
        return string;
    }
}

