/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.ons.CallBack;
import oracle.ons.Notification;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Cli {
    private final Map<String, Object> objects = new HashMap<String, Object>();
    private ONSConfiguration defaultONSConfig = null;
    private String defaultComponent = "";
    static final Pattern valuePairPrefix = Pattern.compile("^[a-zA-Z0-9\\-_]+=.*");
    static final Pattern propertyPrefix = Pattern.compile("^[a-zA-Z0-9\\-_]+:.*");
    private final Map<String, String> paramCache = new HashMap<String, String>();
    AtomicInteger processedEvents = new AtomicInteger(0);
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private int generateId = 1;
    final Logger logger = Logger.getLogger(ONS.class.getCanonicalName());
    private final Map<String, Object> commandMap = new HashMap<String, Object>();

    public String[] unquoteParams(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = '\u0000';
        block11: for (int i = 0; i < cArray.length; ++i) {
            char c2 = cArray[i];
            switch (n) {
                case 0: {
                    if (Character.isLetterOrDigit(c2)) continue block11;
                    if (Character.isSpaceChar(c2)) {
                        if (i - n2 > 0) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(cArray, n2, i - n2);
                            } else {
                                arrayList.add(new String(cArray, n2, i - n2));
                            }
                        }
                        if (stringBuilder.length() > 0) {
                            arrayList.add(stringBuilder.toString());
                            stringBuilder = new StringBuilder();
                        }
                        n2 = i + 1;
                        continue block11;
                    }
                }
                case 1: {
                    if (c2 == '\"' || c2 == '\'') {
                        if (c == c2) {
                            stringBuilder.append(cArray, n2, i - n2);
                            n = 0;
                            c = '\u0000';
                        } else {
                            c = c2;
                            n = 1;
                        }
                        n2 = i + 1;
                        continue block11;
                    }
                    if (c2 != '\\') continue block11;
                    stringBuilder.append(cArray, n2, i - n2);
                    n3 = n;
                    n = 2;
                    continue block11;
                }
                case 2: {
                    n = n3;
                    switch (c2) {
                        case '\n': {
                            break;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            break;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            break;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            break;
                        }
                        default: {
                            stringBuilder.append(c2);
                        }
                    }
                    n2 = i + 1;
                }
            }
        }
        if (cArray.length - n2 > 0) {
            stringBuilder.append(cArray, n2, cArray.length - n2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getParam(String[] stringArray, int n, String string, String string2) throws CommandException {
        if (string != null) {
            Object object;
            if (this.paramCache.isEmpty()) {
                object = stringArray;
                int n2 = ((String[])object).length;
                for (int i = 0; i < n2; ++i) {
                    String string3 = object[i];
                    if (!valuePairPrefix.matcher(string3).matches()) continue;
                    String[] stringArray2 = string3.split("=", 2);
                    this.paramCache.put(stringArray2[0].toLowerCase(), stringArray2[1]);
                }
            }
            if ((object = this.paramCache.get(string.toLowerCase())) != null) {
                return object;
            }
        }
        if (n == -1) {
            if (string2 == null) {
                throw new CommandException(String.format("Parameter %s not found", string));
            }
            return string2;
        }
        if (stringArray.length <= n && string2 == null) {
            throw new CommandException(String.format("Parameter %d (%s) not found", n, string));
        }
        return stringArray.length > n ? stringArray[n] : string2;
    }

    public Cli(String[] stringArray) {
        this.commandMap.put("server", new CommandConnect());
        this.commandMap.put("connect", new CommandConnect());
        this.commandMap.put("delete", new CommandDeleteObject());
        this.commandMap.put("subscribe", new CommandCreateSubscriber());
        this.commandMap.put("publish", new CommandPublish());
        this.commandMap.put("test", new CommandTest());
        this.commandMap.put("help", new CommandHelp());
        HashMap<String, ICommand> hashMap = new HashMap<String, ICommand>();
        this.commandMap.put("set", hashMap);
        hashMap.put("logger", new CommandSetLogger());
        hashMap = new HashMap();
        this.commandMap.put("show", hashMap);
        hashMap.put("loggers", new CommandShowLoggers());
    }

    private ICommand getCommand(String[] stringArray) throws CommandException {
        Object object = this.commandMap;
        int n = 0;
        while (object != null && object instanceof Map && stringArray.length > n) {
            Map<String, Object> map = object;
            object = map.get(stringArray[n++]);
        }
        if (object == null || !(object instanceof ICommand)) {
            throw new CommandException("Command not found");
        }
        return (ICommand)object;
    }

    private void execute(String[] stringArray) throws CommandException {
        if (stringArray.length == 0) {
            return;
        }
        this.getCommand(stringArray).exec(stringArray);
    }

    private void run() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        StringBuilder stringBuilder = null;
        new Timer("Statistic counter", true).scheduleAtFixedRate((TimerTask)new StatTask(), 1000L, 1000L);
        while (true) {
            String string;
            System.out.print("onscli>");
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                System.out.println();
                break;
            }
            if (string2.equalsIgnoreCase("exit") || string2.equalsIgnoreCase("logout")) break;
            if (stringBuilder != null) {
                stringBuilder.append(string2);
            }
            if (string2.endsWith("\\")) {
                if (stringBuilder != null) continue;
                stringBuilder = new StringBuilder(string2);
                continue;
            }
            if (stringBuilder != null) {
                string = stringBuilder.toString();
                stringBuilder = null;
            } else {
                string = string2;
            }
            this.paramCache.clear();
            try {
                this.execute(this.unquoteParams(string));
            }
            catch (CommandException commandException) {
                System.err.println(ONS.exceptionMsg(commandException));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            new Cli(stringArray).run();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public class StatTask
    extends TimerTask {
        int oldcount = 0;

        @Override
        public void run() {
            int n = Cli.this.processedEvents.get();
            if (n != this.oldcount) {
                System.out.println(String.format("Processed %d events", n - this.oldcount));
                this.oldcount = n;
            }
        }
    }

    private class CommandShowLoggers
    implements ICommand {
        private CommandShowLoggers() {
        }

        @Override
        public void info(CommandHelp commandHelp) {
        }

        @Override
        public void exec(String[] stringArray) throws CommandException {
            Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
            while (enumeration.hasMoreElements()) {
                Logger logger;
                String string = enumeration.nextElement();
                if (string == null || (logger = Logger.getLogger(string)) == null) continue;
                Level level = logger.getLevel();
                if (level == null) {
                    level = Level.ALL;
                }
                System.out.println(String.format("%s.level = %s", string, level.toString()));
            }
        }
    }

    private class CommandSetLogger
    implements ICommand {
        private CommandSetLogger() {
        }

        @Override
        public void info(CommandHelp commandHelp) {
        }

        @Override
        public void exec(String[] stringArray) throws CommandException {
            String string = Cli.this.getParam(stringArray, -1, "Level", "");
            if (!string.isEmpty()) {
                Level level = Level.parse(string.toUpperCase());
                Cli.this.logger.setLevel(level);
                if (Cli.this.logger.getHandlers().length == 0) {
                    Cli.this.logger.addHandler(new ConsoleHandler());
                }
                for (Handler handler : Cli.this.logger.getHandlers()) {
                    handler.setLevel(level);
                    System.out.println(handler.getClass());
                }
            }
        }
    }

    private class CommandTest
    implements ICommand {
        private CommandTest() {
        }

        @Override
        public void info(CommandHelp commandHelp) {
        }

        @Override
        public void exec(String[] stringArray) throws CommandException {
            for (String string : stringArray) {
                System.out.println(string);
            }
        }
    }

    private class CommandMute
    implements ICommand {
        private CommandMute() {
        }

        @Override
        public void info(CommandHelp commandHelp) {
        }

        @Override
        public void exec(String[] stringArray) throws CommandException {
        }
    }

    private class CommandConnect
    implements ICommand {
        private CommandConnect() {
        }

        @Override
        public void info(CommandHelp commandHelp) {
            commandHelp.root().item("name").text("connect");
            commandHelp.root().item("syntax").text("connect ConnectionString");
            commandHelp.root().item("info").text("Create an ONS configuration connection");
            commandHelp.root().item("parameter").push(commandHelp.item("name").text("ConnectionString")).push(commandHelp.item("desc").text("ONS configuration string, by default local ORACLE_HOME configuration is used"));
            commandHelp.root().item("example").push(commandHelp.item("text").text("connect \"nodes=127.0.0.1:4243\"")).push(commandHelp.item("desc").text("Connect to the given node"));
        }

        @Override
        public void exec(String[] stringArray) throws CommandException {
            Object object;
            ONSConfiguration oNSConfiguration;
            String string = Cli.this.getParam(stringArray, 1, "ConnectionString", "local");
            if (string.toLowerCase().equals("local")) {
                oNSConfiguration = ONSConfiguration.initDefaultConfig();
            } else if (string.toLowerCase().equals("home")) {
                object = Cli.this.getParam(stringArray, 2, "Home", System.getenv("ORACLE_HOME"));
                oNSConfiguration = ONSConfiguration.getRemoteConfigFromHome((String)object);
            } else {
                oNSConfiguration = ONSConfiguration.getRemoteConfigFromString(string);
            }
            object = oNSConfiguration.getNetwork();
            ((NotificationNetwork)object).lazyDemand();
            try {
                ((NotificationNetwork)object).waitUntilOnline();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            String string2 = Integer.toString(Cli.this.generateId++);
            Cli.this.objects.put(string2, oNSConfiguration);
            Cli.this.defaultONSConfig = oNSConfiguration;
            System.err.println(String.format("ONS configuration %s added", string2));
        }
    }

    private class CommandPublish
    implements ICommand {
        private CommandPublish() {
        }

        @Override
        public void info(CommandHelp commandHelp) {
            commandHelp.root().item("name").text("publish");
            commandHelp.root().item("syntax").text("publish *Verb {Parameters}");
            commandHelp.root().item("info").text("Create an ONS Notification and publishes it with the given configuration");
            commandHelp.root().item("parameter").push(commandHelp.item("name").text("Verb")).push(commandHelp.item("desc").text("(required) ONS message type (Should be 'event' for notifications)"));
            commandHelp.root().item("parameter").push(commandHelp.item("name").text("Component")).push(commandHelp.item("desc").text("Component name to use. Empty by default"));
            commandHelp.root().item("parameter").push(commandHelp.item("name").text("Body")).push(commandHelp.item("desc").text("Message payload, ASCII only currently supported"));
            commandHelp.root().item("parameter").push(commandHelp.item("name").text("ONS")).push(commandHelp.item("desc").text("ONS configuration to use, by default local ORACLE_HOME configuration is used"));
            commandHelp.root().item("example").push(commandHelp.item("text").text("publish event p1:34 Body=HELLOWORLD ons=2 component=onsTestComponent")).push(commandHelp.item("desc").text("publish an event with parameter p1=34 and given body from ons config 2"));
        }

        @Override
        public void exec(String[] stringArray) throws CommandException {
            Publisher publisher;
            ONSConfiguration oNSConfiguration;
            String string = Cli.this.getParam(stringArray, -1, "ONS", "default");
            String string2 = Cli.this.getParam(stringArray, -1, "Component", Cli.this.defaultComponent);
            String string3 = Cli.this.getParam(stringArray, -1, "Body", "");
            String string4 = Cli.this.getParam(stringArray, 1, null, null);
            Object v = Cli.this.objects.get(string);
            ONSConfiguration oNSConfiguration2 = string.equals("default") ? Cli.this.defaultONSConfig : (oNSConfiguration = v instanceof ONSConfiguration ? (ONSConfiguration)v : null);
            if (oNSConfiguration == null) {
                System.err.println("WARNING: using local home configuration");
                publisher = new Publisher(string2);
            } else {
                publisher = new Publisher(oNSConfiguration.getNetwork(), string2);
            }
            Notification notification = string3.isEmpty() ? new Notification(string4) : new Notification(string4, null, null, string3.getBytes());
            for (String string5 : stringArray) {
                if (!propertyPrefix.matcher(string5).matches()) continue;
                String[] stringArray2 = string5.split(":", 2);
                notification.put(stringArray2[0].toLowerCase(), stringArray2[1]);
            }
            publisher.publish(notification);
            publisher.close();
        }
    }

    private class CommandDeleteObject
    implements ICommand {
        private CommandDeleteObject() {
        }

        @Override
        public void info(CommandHelp commandHelp) {
        }

        @Override
        public void exec(String[] stringArray) throws CommandException {
            String string = Cli.this.getParam(stringArray, 1, null, null);
            Object v = Cli.this.objects.get(string);
            if (v == null) {
                throw new CommandException("Object not found");
            }
            Cli.this.objects.remove(string);
            if (v instanceof SubscriberHolder) {
                ((SubscriberHolder)v).s.close();
            }
        }
    }

    private class CommandCreateSubscriber
    implements ICommand {
        private CommandCreateSubscriber() {
        }

        @Override
        public void info(CommandHelp commandHelp) {
            commandHelp.root().item("name").text("subscribe");
            commandHelp.root().item("syntax").text("subscribe {Subscription}");
            commandHelp.root().item("info").text("Create an ONS Subscriber with the given subscription string");
            commandHelp.root().item("parameter").push(commandHelp.item("name").text("Subscription")).push(commandHelp.item("desc").text("Subscription string (transitive)"));
            commandHelp.root().item("parameter").push(commandHelp.item("name").text("Output")).push(commandHelp.item("desc").text("URL of the container to output notifications. '-' (default) stands for standard output. Note, that stdout will affect command input."));
            commandHelp.root().item("parameter").push(commandHelp.item("name").text("ONS")).push(commandHelp.item("desc").text("ONS configuration to use, by default local ORACLE_HOME configuration is used"));
            commandHelp.root().item("parameter").push(commandHelp.item("name").text("Connect")).push(commandHelp.item("desc").text("ONS Connection string"));
            commandHelp.root().item("example").push(commandHelp.item("text").text("subscribe \\'xevent\\' ons=2 component=onsTestComponent")).push(commandHelp.item("desc").text("subscribe to notifications with eventType=xevent to "));
            commandHelp.root().item("example").push(commandHelp.item("text").text("subscribe ons=2 component=onsTestComponent subscribe=\\'xevent\\'")).push(commandHelp.item("desc").text("alternative syntax for the latter"));
            commandHelp.root().item("example").push(commandHelp.item("text").text("subscribe subscribe=\\'event-1\\' output=file:out.txt")).push(commandHelp.item("desc").text("Subscribe to event-1 and send all the output to out.txt"));
        }

        @Override
        public void exec(String[] stringArray) throws CommandException {
            Object object;
            Object object2;
            String string = Cli.this.getParam(stringArray, 1, "Subscription", null);
            String string2 = Cli.this.getParam(stringArray, -1, "ONS", "default");
            String string3 = Cli.this.getParam(stringArray, -1, "Connect", "");
            String string4 = Cli.this.getParam(stringArray, -1, "Output", "-");
            Boolean bl = Boolean.parseBoolean(Cli.this.getParam(stringArray, -1, "Async", "false"));
            Boolean bl2 = Boolean.parseBoolean(Cli.this.getParam(stringArray, -1, "System", "false"));
            Boolean bl3 = Boolean.parseBoolean(Cli.this.getParam(stringArray, -1, "ShowBody", "false"));
            ONSConfiguration oNSConfiguration = null;
            if (string3.isEmpty()) {
                object2 = Cli.this.objects.get(string2);
                oNSConfiguration = string2.equals("default") ? Cli.this.defaultONSConfig : (object2 instanceof ONSConfiguration ? (ONSConfiguration)object2 : null);
            }
            object2 = new SubscriberHolder();
            ((SubscriberHolder)object2).showBody = bl3;
            if (string4.equals("-")) {
                ((SubscriberHolder)object2).output = new OutputStreamWriter(System.out);
            } else {
                try {
                    object = new URL(string4);
                    ((SubscriberHolder)object2).output = ((URL)object).getProtocol().toLowerCase().equals("file") ? new OutputStreamWriter(new FileOutputStream(((URL)object).getFile())) : new OutputStreamWriter(((URL)object).openConnection().getOutputStream());
                }
                catch (IOException iOException) {
                    throw new CommandException("Could not open output stream : " + ONS.exceptionMsg(iOException));
                }
            }
            if (oNSConfiguration == null && string3.isEmpty()) {
                System.err.println("WARNING: using local home configuration");
                oNSConfiguration = ONSConfiguration.getDefaultConfig();
            }
            if (bl.booleanValue()) {
                ((SubscriberHolder)object2).s = string3.isEmpty() ? Subscriber.backgroundSubscriber(oNSConfiguration, string, object2) : Subscriber.backgroundSubscriber(string3, string, object2);
                ((SubscriberHolder)object2).s.setWantSystemNotifications(bl2);
            } else {
                if (!string3.isEmpty()) {
                    oNSConfiguration = new ONSConfiguration(string3);
                }
                ((SubscriberHolder)object2).s = new Subscriber(oNSConfiguration, string, (CallBack)object2);
                ((SubscriberHolder)object2).s.setWantSystemNotifications(bl2);
                try {
                    ((SubscriberHolder)object2).s.waitUntilRegistered();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            object = Integer.toString(Cli.this.generateId++);
            Cli.this.objects.put(object, object2);
            System.err.println(String.format("Subscriber %s added", object));
        }
    }

    private class CommandHelp
    implements ICommand {
        Document doc;
        Element root;
        DocumentBuilder docBuilder;

        void newContext() {
            try {
                this.docBuilder = factory.newDocumentBuilder();
                this.doc = this.docBuilder.newDocument();
                this.root = this.doc.createElement("help");
                this.doc.appendChild(this.root);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        private CommandHelp() {
            this.newContext();
        }

        public NodeBuilder root() {
            return new NodeBuilder(this.root);
        }

        public NodeBuilder item(String string) {
            return new NodeBuilder(this.doc.createElement(string));
        }

        @Override
        public void info(CommandHelp commandHelp) {
            commandHelp.root().item("name").text("help");
            commandHelp.root().item("syntax").text("help [command]");
            commandHelp.root().item("info").text("Prints help message on command and it's parameters");
        }

        public void printCommands(Map<String, Object> map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object object;
                if (entry.getValue() instanceof Map) {
                    object = (Map)entry.getValue();
                    this.printCommands((Map<String, Object>)object);
                    continue;
                }
                if (!(entry.getValue() instanceof ICommand)) continue;
                object = XPathFactory.newInstance();
                XPath xPath = ((XPathFactory)object).newXPath();
                this.newContext();
                ((ICommand)entry.getValue()).info(this);
                System.out.print("  ");
                System.out.print(entry.getKey());
                System.out.print("\n    ");
                try {
                    this.printFormatted(xPath.evaluate("/help/info/text()", this.doc));
                }
                catch (XPathExpressionException xPathExpressionException) {
                    throw new RuntimeException(xPathExpressionException);
                }
                System.out.println();
            }
        }

        private List<Node> toSet(Object object) {
            NodeList nodeList = (NodeList)object;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(nodeList.item(i));
            }
            return arrayList;
        }

        private void printFormatted(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                n += string2.length();
                System.out.print(string2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                if (n > 80) {
                    System.out.println();
                    n = 0;
                    continue;
                }
                System.out.print(' ');
            }
        }

        @Override
        public void exec(String[] stringArray) throws CommandException {
            if (stringArray.length == 1) {
                System.out.print("ONS Java Client v 2.0 CLI\nThe list of available commands: \n");
                this.printCommands(Cli.this.commandMap);
                System.out.print("\nTo get help on any command, execute \"help [command name]\"\n\n");
            } else {
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                try {
                    stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
                    this.newContext();
                    Cli.this.getCommand(stringArray).info(this);
                    System.out.print("Command : ");
                    System.out.println(xPath.evaluate("/help/name/text()", this.doc));
                    System.out.print("Syntax : ");
                    System.out.println(xPath.evaluate("/help/syntax/text()", this.doc));
                    System.out.print("Description : \n  ");
                    this.printFormatted(xPath.evaluate("/help/info/text()", this.doc));
                    System.out.println("\n");
                    System.out.println("Parameters :");
                    for (Node node : this.toSet(xPath.evaluate("/help/parameter", this.doc, XPathConstants.NODESET))) {
                        System.out.println("  " + xPath.evaluate("./name/text()", node));
                        this.printFormatted("    " + xPath.evaluate("./desc/text()", node));
                        System.out.println("\n");
                    }
                    System.out.println("Examples :");
                    for (Node node : this.toSet(xPath.evaluate("/help/example", this.doc, XPathConstants.NODESET))) {
                        System.out.println("  " + xPath.evaluate("./text/text()", node));
                        this.printFormatted("    " + xPath.evaluate("./desc/text()", node));
                        System.out.println("\n");
                    }
                }
                catch (CommandException commandException) {
                    System.err.println(ONS.exceptionMsg(commandException));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }

        public class NodeBuilder {
            Element x;

            NodeBuilder(Element element) {
                this.x = element;
            }

            NodeBuilder item(String string) {
                Element element = CommandHelp.this.doc.createElement(string);
                this.x.appendChild(element);
                return new NodeBuilder(element);
            }

            NodeBuilder text(String string) {
                this.x.appendChild(CommandHelp.this.doc.createTextNode(string));
                return this;
            }

            NodeBuilder push(NodeBuilder nodeBuilder) {
                this.x.appendChild(nodeBuilder.x);
                return this;
            }
        }
    }

    private class SubscriberHolder
    implements CallBack {
        Subscriber s = null;
        Writer output = null;
        boolean showBody = false;

        private SubscriberHolder() {
        }

        @Override
        public void notification_callback(Notification notification) {
            try {
                this.output.write(notification.toNiceString());
                if (this.showBody) {
                    this.output.write(new String(notification.body()));
                }
                this.output.write("\n");
                this.output.flush();
                Cli.this.processedEvents.incrementAndGet();
            }
            catch (IOException iOException) {
                System.err.println("Could not write to a file");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static interface ICommand {
        public void info(CommandHelp var1);

        public void exec(String[] var1) throws CommandException;
    }

    static class CommandException
    extends Exception {
        public CommandException(String string) {
            super(string);
        }
    }
}

