/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import oracle.ons.ConfigurationException;
import oracle.ons.Node;
import oracle.ons.NodeAddress;
import oracle.ons.NotificationManager;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONSException;
import oracle.ons.WebSocket;
import oracle.security.pki.OracleWallet;
import org.w3c.dom.Document;

public class ONSConfiguration {
    static final long NODE_RETRY_DELAY = 60000L;
    static final long DEFAULT_TIMEOUT = 5000L;
    static final int DEFAULT_REMOTE_TIMEOUT = 30000;
    static final Charset ONS_CHARSET = Charset.forName("ASCII");
    static final String ONS_HP_SEPARATOR = ",";
    static final int BASIC_BUFFER_SIZE = 4096;
    static final int MAX_HEADER_SIZE = 16384;
    static final int DEFAULT_SERVER_VERSION = 5;
    static final int ONS_SECURITY_NONE = 0;
    static final int ONS_SECURITY_ORACLE_WALLET = 1;
    static final int ONS_SECURITY_KEYFILE = 2;
    static final int ONS_SECURITY_LOCAL = 3;
    private int protocolVersion = 5;
    private String oracleHome = "undefined";
    private String instanceId = null;
    private static String cachedHostname = null;
    private int remoteTimeout = 30000;
    private String fingerprint = null;
    private String component = "";
    private String formFactorPath = null;
    private static MessageDigest sha1Digest = null;
    private WebSocket websocket = null;
    String keyFile = null;
    char[] keyFilePassword = null;
    int securityScheme = 0;
    boolean ignoreScan = false;
    private int localPort = 0;
    private int remotePort = 0;
    private int defaultMaxConnections = 3;
    private static final String CONFIG_FILE_PATH = "opmn" + File.separator + "conf";
    private static final String CONFIG_FILE_NAME = "ons.config";
    private static final String FORMFACTOR_FILE_NAME = ".formfactor";
    private static final String SYS_ENV_ORACLE_HOME = "ORACLE_HOME";
    private static final String SYS_ENV_ORACLE_BASE_HOME = "ORACLE_BASE_HOME";
    private static final String SYS_ENV_ORACLE_CONFIG_HOME = "ORACLE_CONFIG_HOME";
    private static final Object defaultConfigLock = new Object();
    private static ONSConfiguration defaultConfig = null;
    final Map<String, NodeList> nodeLists = new HashMap<String, NodeList>();
    private static final Map<String, String> configStringTranslator;
    private static final Pattern commentMatcher;
    private static final String SYSPROP_ORACLEHOME = "oracle.ons.oraclehome";
    private static final String SYSPROP_ORACLEBASEHOME = "oracle.ons.oraclebasehome";
    private static final String SYSPROP_ORACLECONFIGHOME = "oracle.ons.oracleconfighome";
    private static final String SYSPROP_ORACLEINSTANCE = "oracle.instance";
    private static final String SYSPROP_MAXCONNECTIONS = "oracle.ons.maxconnections";
    private static final String SYSPROP_ACTIVELIST = "oracle.ons.active";
    private static final String SYSPROP_SHUTDOWNTIMEOUT = "oracle.ons.shutdowntimeout";
    private static final String SYSPROP_IGNORESCANVIP = "oracle.ons.ignorescanvip";
    private static final String SYSPROP_NODES = "oracle.ons.nodes";
    private static final String SYSPROP_REMOTETIMEOUT = "oracle.ons.remotetimeout";
    private static final String SYSPROP_WALLETFILE = "oracle.ons.walletfile";
    private static final String SYSPROP_WALLETPASSWORD = "oracle.ons.walletpassword";
    private static final String SYSPROP_KEYSTOREFILE = "oracle.ons.keystore.location";
    private static final String SYSPROP_KEYSTOREPASSWORD = "oracle.ons.keystore.password";
    private static final String SYSPROP_DEBUG = "oracle.ons.debug";
    private static final String SYSPROP_PING = "oracle.ons.pingtimeout";
    private static final String SYSPROP_PROPFILE = "oracle.ons.propertiesfile";
    private static final String SYSPROP_USEWEBSOCKET = "oracle.ons.usewebsocket";
    private static final String SYSPROP_WEBSOCKETPROXY = "oracle.ons.websocketproxy";
    protected static final String ONS_SSL_CONTEXT_PROTOCOL = "SSL";
    protected static final String ONS_SSL_KEY_MANAGEMENT = "SunX509";
    private SSLSocketFactory sslSocketFactoryCached = null;
    private String key = null;

    private void configure(Properties properties) {
        if (properties.containsKey(SYSPROP_PROPFILE)) {
            String propFile = properties.getProperty(SYSPROP_PROPFILE);
            Properties extProps = ONSConfiguration.loadProperties(propFile);
            properties.remove(SYSPROP_PROPFILE);
            properties.putAll((Map<?, ?>)extProps);
        }
        this.setProperties(System.getProperties());
        this.setProperties(properties);
        this.populateTopologies(properties);
        this.updateSSLSocketFactory();
    }

    private static Properties loadProperties(String propFile) {
        Properties properties = new Properties();
        Reader reader = null;
        try {
            reader = new BufferedReader(new FileReader(propFile));
            properties.load(reader);
        }
        catch (Exception ex) {
            throw new ConfigurationException(propFile + ": failed to read configuration file : " + ex.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return properties;
    }

    public static ONSConfiguration getRemoteConfigFromString(String config) throws ONSException {
        Properties properties = new Properties();
        ONSConfiguration configuration = new ONSConfiguration();
        config = config.replace("|", "\n");
        try {
            properties.load(new StringReader(config));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        configuration.configure(ONSConfiguration.translate(properties));
        return configuration;
    }

    public ONSConfiguration(String config) throws ONSException {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(config));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.configure(ONSConfiguration.translate(properties));
    }

    static String getFileContent(File file) throws IOException {
        String x;
        StringBuilder content = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((x = reader.readLine()) != null) {
            content.append(x);
        }
        reader.close();
        return content.toString();
    }

    static String getFormFactor(String path) throws IOException {
        String hostname = ONSConfiguration.getHostname();
        File formFactorFile = new File(path, ".formfactor." + hostname);
        if (!(formFactorFile.isFile() || (formFactorFile = new File(path, FORMFACTOR_FILE_NAME)).isFile() || (formFactorFile = new File(path, "config" + File.separator + "OPMN" + File.separator + "opmn" + File.separator + FORMFACTOR_FILE_NAME)).isFile())) {
            return "";
        }
        return ONSConfiguration.getFileContent(formFactorFile).trim();
    }

    static File checkConfigDirectory(String home) {
        File file = new File(home + File.separator + CONFIG_FILE_NAME);
        if (!file.isFile()) {
            file = null;
        }
        return file;
    }

    public static String getUncachedHostname() {
        String hostname = System.getenv("HOSTNAME");
        if (hostname == null || hostname.isEmpty()) {
            hostname = System.getenv("COMPUTERNAME");
        }
        if (hostname == null || hostname.isEmpty()) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                NotificationManager.getNotificationManager().logger.log(Level.WARNING, "Could not get the hostname", e);
                hostname = "";
            }
        }
        return hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostname() {
        if (cachedHostname == null) {
            String hostName = ONSConfiguration.getUncachedHostname();
            Object object = defaultConfigLock;
            synchronized (object) {
                if (cachedHostname == null) {
                    cachedHostname = hostName;
                }
            }
        }
        return cachedHostname;
    }

    public static ONSConfiguration getLocalConfigFromFile(String oracleHome, File configFile, String formFactor) throws ONSException {
        ONSConfiguration configuration = new ONSConfiguration();
        File configPath = null;
        if (oracleHome == null && configFile == null) {
            throw new ConfigurationException("Oracle home or config file must be provided");
        }
        if (oracleHome == null) {
            configPath = configFile.getParentFile();
            oracleHome = configPath.getParentFile().getParentFile().getAbsolutePath();
        }
        if (configPath == null) {
            configPath = new File(oracleHome + File.separator + CONFIG_FILE_PATH);
        }
        if (configFile == null) {
            String hostname = ONSConfiguration.getHostname();
            configFile = new File(configPath, "ons.config." + hostname);
            if (!configFile.isFile()) {
                configFile = new File(configPath, CONFIG_FILE_NAME);
            }
        }
        configuration.ignoreScan = true;
        configuration.setOracleHome(oracleHome);
        configuration.setFormFactorPath(configPath.getAbsolutePath());
        Properties properties = ONSConfiguration.loadProperties(configFile.getAbsolutePath());
        for (String k : properties.stringPropertyNames()) {
            if (properties.containsKey(k.toLowerCase())) continue;
            properties.put(k.toLowerCase(), properties.getProperty(k));
        }
        configuration.localPort = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty("localport", "0")));
        configuration.remotePort = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty("remoteport", "0")));
        if (configuration.localPort != 0) {
            configuration.securityScheme = 3;
            configuration.ignoreScan = true;
        }
        properties = ONSConfiguration.translate(properties);
        configuration.setProperties(System.getProperties());
        configuration.setProperties(properties);
        configuration.updateSSLSocketFactory();
        NodeList localConfig = new NodeList("local", configuration);
        localConfig.active = true;
        localConfig.addresses.add(new NodeAddress(configuration.localPort, false));
        localConfig.maxConnections = 1;
        configuration.nodeLists.put(localConfig.publicId, localConfig);
        return configuration;
    }

    private static String stringCoalesce(String a, String b) {
        return a != null ? a : b;
    }

    public static ONSConfiguration getConfigFromOPMN(String oracleInstance) throws ONSException {
        File opmnConfigPath = new File(oracleInstance + File.separator + "config" + File.separator + "OPMN" + File.separator + "opmn");
        File opmnConfigFile = new File(opmnConfigPath, "opmn.xml");
        ONSConfiguration configuration = new ONSConfiguration();
        configuration.ignoreScan = true;
        configuration.setOracleHome(oracleInstance);
        configuration.setFormFactorPath(opmnConfigPath.getAbsolutePath());
        try {
            configuration.setProperties(System.getProperties());
            DocumentBuilderFactory docFact = DocumentBuilderFactory.newInstance();
            docFact.setNamespaceAware(true);
            Document opmnConfig = docFact.newDocumentBuilder().parse(opmnConfigFile);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expr = "//*[local-name()='notification-server']/*[local-name() = 'port']/@local";
            configuration.localPort = Integer.parseInt(ONSConfiguration.stringCoalesce(xpath.evaluate(expr, opmnConfig), "0"));
            configuration.securityScheme = 3;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to open or parse OPMN config file " + opmnConfigFile + " : " + e.getMessage());
        }
        NodeList localConfig = new NodeList("opmn-local", configuration);
        localConfig.active = true;
        localConfig.addresses.add(new NodeAddress(configuration.localPort, true));
        localConfig.maxConnections = 1;
        configuration.nodeLists.put(localConfig.publicId, localConfig);
        return configuration;
    }

    public static ONSConfiguration getRemoteConfigFromHome(String oracleHome) throws ONSException {
        File configFile = ONSConfiguration.checkConfigDirectory(oracleHome);
        if (configFile == null) {
            throw new ConfigurationException("ONS configuration file not found");
        }
        ONSConfiguration configuration = ONSConfiguration.getRemoteConfigFromFile(configFile.toString());
        configuration.setOracleHome(oracleHome);
        return configuration;
    }

    public static ONSConfiguration getRemoteConfigFromFile(String fileName) throws ONSException {
        Properties properties = ONSConfiguration.loadProperties(fileName);
        ONSConfiguration configuration = new ONSConfiguration();
        configuration.configure(properties);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ONSConfiguration getDefaultConfig() throws ONSException {
        if (defaultConfig == null) {
            Object object = defaultConfigLock;
            synchronized (object) {
                if (defaultConfig == null) {
                    return ONSConfiguration.initDefaultConfig();
                }
            }
        }
        return defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConfig(ONSConfiguration config) {
        Object object = defaultConfigLock;
        synchronized (object) {
            defaultConfig = config;
        }
    }

    static ONSConfiguration initDefaultConfig() throws ONSException {
        boolean wantOpmnConf;
        Properties sysProperties = System.getProperties();
        String home = null;
        home = sysProperties.getProperty(SYSPROP_ORACLEINSTANCE);
        boolean bl = wantOpmnConf = home != null;
        if (home == null && (home = sysProperties.getProperty(SYSPROP_ORACLECONFIGHOME)) == null && (home = sysProperties.getProperty(SYSPROP_ORACLEBASEHOME)) == null && (home = sysProperties.getProperty(SYSPROP_ORACLEHOME)) == null && (home = System.getenv(SYS_ENV_ORACLE_CONFIG_HOME)) == null && (home = System.getenv(SYS_ENV_ORACLE_BASE_HOME)) == null && (home = System.getenv(SYS_ENV_ORACLE_HOME)) == null) {
            throw new ConfigurationException(String.format("Default ONS client initialization: Oracle home is not set (looking in %s)", "oracle.instance, oracle.ons.oracleconfighome, oracle.ons.oraclebasehome, oracle.ons.oraclehome"));
        }
        return wantOpmnConf ? ONSConfiguration.getConfigFromOPMN(home) : ONSConfiguration.getLocalConfigFromFile(home, null, null);
    }

    ONSConfiguration() {
    }

    public NotificationNetwork getNetwork() {
        return NotificationManager.getNotificationManager().getNetwork(this);
    }

    public long getNotificationWindow() {
        return 5000L;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public WebSocket getWebSocket() {
        return this.websocket;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public Collection<NodeList> getTopologies() {
        return this.nodeLists.values();
    }

    private static String cleanupComment(String value) {
        int last;
        int index;
        String clean = commentMatcher.matcher(value).replaceFirst("");
        char[] cChars = clean.toCharArray();
        for (index = last = cChars.length - 1; index >= 0 && (cChars[index] == ' ' || cChars[index] == '\t'); --index) {
        }
        if (index != last) {
            clean = index >= 0 ? clean.substring(0, index + 1) : "";
        }
        return clean;
    }

    private static Properties translate(Properties in) {
        Properties out = new Properties();
        for (String name : in.stringPropertyNames()) {
            String value = ONSConfiguration.cleanupComment(in.getProperty(name));
            out.put("oracle.ons." + (configStringTranslator.containsKey(name) ? configStringTranslator.get(name) : name), value);
        }
        return out;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getFormFactor() {
        String formFactor = "";
        if (this.formFactorPath != null) {
            try {
                formFactor = ONSConfiguration.getFormFactor(this.formFactorPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return formFactor;
    }

    @Deprecated
    public void setFormFactor(String formFactor) {
    }

    public void setFormFactorPath(String formFactorPath) {
        this.formFactorPath = formFactorPath;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getOracleHome() {
        return this.oracleHome;
    }

    private void setOracleHome(String oracleHome) {
        this.oracleHome = oracleHome;
    }

    private static synchronized void setSha1Digest() throws NoSuchAlgorithmException {
        if (sha1Digest == null) {
            try {
                sha1Digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                sha1Digest = MessageDigest.getInstance("SHA1");
            }
        }
    }

    public static byte[] getSha1Digest(byte[] data) {
        return sha1Digest.digest(data);
    }

    public static byte[] getSha1Digest(String string) {
        byte[] data = string.getBytes();
        return sha1Digest.digest(data);
    }

    public Object getFingerprint() {
        if (this.fingerprint == null) {
            this.fingerprint = this.toString();
        }
        return this.fingerprint;
    }

    private void setProperties(Properties properties) {
        String webSocketProxy;
        if (properties.containsKey(SYSPROP_PING)) {
            Node.PING_TIMEOUT = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_PING)));
        }
        if (properties.containsKey(SYSPROP_IGNORESCANVIP)) {
            this.ignoreScan = Boolean.parseBoolean(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_IGNORESCANVIP)));
        }
        if (properties.containsKey(SYSPROP_REMOTETIMEOUT)) {
            this.remoteTimeout = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_REMOTETIMEOUT)));
        }
        if (properties.containsKey(SYSPROP_MAXCONNECTIONS)) {
            this.defaultMaxConnections = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_MAXCONNECTIONS)));
        }
        boolean useWebSocket = false;
        if (properties.containsKey(SYSPROP_USEWEBSOCKET)) {
            useWebSocket = Boolean.parseBoolean(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_USEWEBSOCKET)));
        }
        if ((webSocketProxy = properties.getProperty(SYSPROP_WEBSOCKETPROXY)) != null) {
            useWebSocket = true;
        }
        if (useWebSocket) {
            try {
                ONSConfiguration.setSha1Digest();
            }
            catch (NoSuchAlgorithmException nex) {
                throw new ConfigurationException("SHA-1 is required for websocket support: " + nex.getMessage());
            }
            if (webSocketProxy != null) {
                try {
                    this.websocket = new WebSocket(webSocketProxy);
                }
                catch (IllegalArgumentException aex) {
                    throw new ConfigurationException("Invalid value for oracle.ons.websocketproxy=" + webSocketProxy + " : " + aex.getMessage());
                }
            } else {
                this.websocket = new WebSocket(true);
            }
        }
        if (this.securityScheme != 3) {
            if (properties.containsKey(SYSPROP_WALLETFILE)) {
                this.securityScheme = 1;
                this.keyFile = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_WALLETFILE));
                if (properties.containsKey(SYSPROP_WALLETPASSWORD)) {
                    this.keyFilePassword = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_WALLETPASSWORD)).toCharArray();
                }
            } else if (properties.containsKey(SYSPROP_KEYSTOREFILE)) {
                this.securityScheme = 2;
                this.keyFile = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_KEYSTOREFILE));
                if (properties.containsKey(SYSPROP_KEYSTOREPASSWORD)) {
                    this.keyFilePassword = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_KEYSTOREPASSWORD)).toCharArray();
                }
            }
        }
        if (useWebSocket && this.websocket.proxySSL && (this.securityScheme == 0 || this.securityScheme == 3)) {
            this.websocket.proxySSL = false;
        }
    }

    private void populateTopologies(Properties properties) {
        TreeSet<String> idSuffixes = new TreeSet<String>();
        for (String name : properties.stringPropertyNames()) {
            String idSuffix;
            if (!name.startsWith(SYSPROP_NODES) || idSuffixes.add(idSuffix = name.substring(SYSPROP_NODES.length()))) continue;
            throw new ConfigurationException(String.format("Duplicate node list id in configuration : %s", idSuffix));
        }
        if (idSuffixes.isEmpty() && properties.containsKey(SYSPROP_NODES)) {
            idSuffixes.add("");
        }
        for (String id : idSuffixes) {
            NodeList tc = new NodeList(id.isEmpty() ? "" : id.substring(1), this);
            if (properties.containsKey(SYSPROP_ACTIVELIST + id)) {
                tc.active = Boolean.parseBoolean(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_ACTIVELIST + id)));
            }
            tc.maxConnections = properties.containsKey(SYSPROP_MAXCONNECTIONS + id) ? Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_MAXCONNECTIONS + id))) : this.defaultMaxConnections;
            String nodes = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_NODES + id));
            for (String s : nodes.split(ONS_HP_SEPARATOR)) {
                try {
                    int i = s.lastIndexOf(":");
                    if (i == -1) {
                        throw new IllegalArgumentException();
                    }
                    String hostname = s.substring(0, i);
                    int port = Integer.parseInt(s.substring(i + 1));
                    NodeAddress hp = new NodeAddress(hostname, port, this.keyFile, this.websocket);
                    tc.addresses.add(hp);
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationException(String.format("Bad node syntax : %s", s));
                }
            }
            this.nodeLists.put(tc.publicId, tc);
        }
    }

    public long getSocketTimeout() {
        return this.remoteTimeout;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public boolean hasSecureConnection() {
        return this.securityScheme != 0 && this.securityScheme != 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateSSLSocketFactory() {
        block25: {
            if (!this.hasSecureConnection()) {
                return;
            }
            try {
                KeyStore keyStore;
                KeyManagerFactory kmf = null;
                TrustManagerFactory tmf = null;
                boolean useDefaultKeyManager = this.securityScheme != 1;
                while (true) {
                    try {
                        String trustManager;
                        String keyManager;
                        if (useDefaultKeyManager) {
                            keyManager = KeyManagerFactory.getDefaultAlgorithm();
                            trustManager = TrustManagerFactory.getDefaultAlgorithm();
                        } else {
                            keyManager = ONS_SSL_KEY_MANAGEMENT;
                            trustManager = ONS_SSL_KEY_MANAGEMENT;
                        }
                        kmf = KeyManagerFactory.getInstance(keyManager);
                        tmf = TrustManagerFactory.getInstance(trustManager);
                    }
                    catch (NoSuchAlgorithmException e) {
                        if (useDefaultKeyManager) {
                            throw e;
                        }
                        kmf = null;
                        useDefaultKeyManager = true;
                        if (kmf == null) continue;
                    }
                    break;
                }
                if (this.securityScheme == 1) {
                    OracleWallet oracleWallet = new OracleWallet();
                    oracleWallet.open(this.keyFile, this.keyFilePassword);
                    keyStore = oracleWallet.getKeyStore();
                } else {
                    if (this.keyFilePassword == null) {
                        throw new ConfigurationException("No password provided");
                    }
                    keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (FileInputStream fis = new FileInputStream(this.keyFile);){
                        keyStore.load(fis, this.keyFilePassword);
                    }
                }
                kmf.init(keyStore, this.keyFilePassword);
                tmf.init(keyStore);
                SSLContext context = SSLContext.getInstance(ONS_SSL_CONTEXT_PROTOCOL);
                context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                if (this.websocket != null && this.websocket.proxyHostname != null) {
                    this.getCertSubjectCN(keyStore);
                }
                this.sslSocketFactoryCached = context.getSocketFactory();
                if (this.sslSocketFactoryCached != null) {
                    NotificationManager.getNotificationManager().logger.fine("SSL factory created");
                } else {
                    NotificationManager.getNotificationManager().logger.warning("Failed to create SSL factory");
                }
                if (this.keyFilePassword == null) break block25;
            }
            catch (GeneralSecurityException e) {
                try {
                    throw new ConfigurationException(e.getLocalizedMessage());
                    catch (IOException e2) {
                        throw new ConfigurationException(e2.getLocalizedMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (this.keyFilePassword != null) {
                        for (int i2 = 0; i2 < this.keyFilePassword.length; ++i2) {
                            this.keyFilePassword[i2] = '\u0000';
                        }
                    }
                    throw throwable;
                }
            }
            for (int i = 0; i < this.keyFilePassword.length; ++i) {
                this.keyFilePassword[i] = '\u0000';
            }
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.securityScheme == 0 || this.securityScheme == 3) {
            return null;
        }
        if (this.sslSocketFactoryCached == null) {
            try {
                this.updateSSLSocketFactory();
            }
            catch (ONSException e) {
                NotificationManager.getNotificationManager().logger.warning(e.getLocalizedMessage());
            }
        }
        return this.sslSocketFactoryCached;
    }

    private void getCertSubjectCN(KeyStore keyStore) {
        String keyName = null;
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                keyName = alias;
                break;
            }
            if (keyName != null) {
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyName);
                String subject = cert.getSubjectDN().getName();
                int begin = subject.indexOf("CN=");
                if (begin != -1) {
                    int end = subject.indexOf(44, begin += 3);
                    String cn = end != -1 ? subject.substring(begin, end) : subject.substring(begin);
                    this.websocket.setSubjectCN(cn);
                } else {
                    NotificationManager.getNotificationManager().logger.log(Level.WARNING, "Could not find CN from cert subject " + subject + " in cert " + keyName + " in key file " + this.keyFile);
                }
            } else {
                NotificationManager.getNotificationManager().logger.log(Level.WARNING, "Could not find cert key name from key file " + this.keyFile);
            }
        }
        catch (Exception e) {
            if (keyName != null) {
                NotificationManager.getNotificationManager().logger.log(Level.WARNING, "Could not find CN from cert " + keyName + " in key file " + this.keyFile);
            }
            NotificationManager.getNotificationManager().logger.log(Level.WARNING, "Could not find cert from key file " + this.keyFile);
        }
    }

    public String toString() {
        if (this.key == null) {
            StringBuilder sb = new StringBuilder("{");
            sb.append("ss:").append(this.securityScheme).append(";");
            sb.append("ff:").append(this.formFactorPath).append(";conf:[");
            for (NodeList tc : this.nodeLists.values()) {
                sb.append(tc.toString()).append(ONS_HP_SEPARATOR);
            }
            this.key = sb.append("]}").toString();
        }
        return this.key;
    }

    static {
        HashMap<String, String> translator = new HashMap<String, String>();
        translator.put("keystorelocation", "keystore.location");
        translator.put("keystorepassword", "keystore.password");
        configStringTranslator = Collections.unmodifiableMap(translator);
        commentMatcher = Pattern.compile("\\s+#.*");
    }

    static class NodeList {
        public String publicId;
        public ONSConfiguration config;
        public final Set<NodeAddress> addresses = new HashSet<NodeAddress>();
        public final Set<Node> pending = new HashSet<Node>();
        public final Set<Node> connected = new HashSet<Node>();
        public int connectFails;
        public NodeList failedTo;
        public NodeList failedFrom;
        public boolean active = true;
        public int maxConnections = 3;

        public NodeList(String id, ONSConfiguration conf) {
            this.publicId = id;
            this.config = conf;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("{max:%d;a:%b;n:[", this.maxConnections, this.active));
            for (NodeAddress node : this.addresses) {
                sb.append("\"").append(node.toString()).append("\";");
            }
            sb.append("]}");
            return sb.toString();
        }
    }
}

