/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.WebSocket;

class NodeAddress {
    public final String hostname;
    public final int port;
    public final String keyfile;
    public final boolean islocal;
    public final WebSocket websocket;
    public int stamp = 0;
    private int unique = 0;
    private static int uniqueKey = 0;

    NodeAddress(String hostname, int port, String keyFile, WebSocket websocket) {
        this.hostname = hostname;
        this.port = port;
        this.keyfile = keyFile;
        this.islocal = false;
        this.websocket = websocket != null ? websocket : new WebSocket(false);
    }

    NodeAddress(int port, boolean isUnique) {
        this.hostname = "localhost";
        this.port = port;
        this.keyfile = null;
        this.islocal = true;
        this.websocket = new WebSocket(false);
        if (isUnique) {
            this.unique = this.getUnique();
        }
    }

    NodeAddress(NodeAddress parent) {
        this.hostname = parent.hostname;
        this.port = parent.port;
        this.keyfile = parent.keyfile;
        this.websocket = parent.websocket;
        this.islocal = parent.islocal;
        this.unique = parent.unique;
    }

    public synchronized int getStamp() {
        ++this.stamp;
        return this.stamp;
    }

    public synchronized int getUnique() {
        return ++uniqueKey;
    }

    public int hashCode() {
        int code = this.hostname.hashCode();
        if (this.keyfile != null) {
            code ^= this.keyfile.hashCode();
        }
        return code += this.port * 179425171 + this.websocket.hashCode();
    }

    public boolean equals(Object obj) {
        NodeAddress other;
        NodeAddress nodeAddress = other = obj instanceof NodeAddress ? (NodeAddress)obj : null;
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        boolean keyMatch = false;
        if (this.keyfile == null && other.keyfile == null) {
            keyMatch = true;
        } else if (this.keyfile != null && other.keyfile != null && this.keyfile.equals(other.keyfile)) {
            keyMatch = true;
        }
        return this.port == other.port && this.hostname.equals(other.hostname) && this.unique == other.unique && keyMatch && this.websocket.equals(other.websocket);
    }

    public String toString() {
        String wString = "";
        if (this.websocket.enabled) {
            wString = ",websocket=" + this.websocket.toString();
        }
        String kString = "";
        if (this.keyfile != null) {
            kString = ",keyfile=" + this.keyfile;
        }
        return String.format("%s:%d%s%s", this.hostname, this.port, kString, wString);
    }
}

