/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.maven.pof;

import com.oracle.coherence.common.schema.ClassFileSchemaSource;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.SchemaBuilder;
import com.oracle.coherence.common.schema.SchemaSource;
import com.oracle.coherence.common.schema.XmlSchemaSource;
import com.tangosol.io.pof.PofIndexer;
import com.tangosol.io.pof.generator.PortableTypeGenerator;
import com.tangosol.io.pof.schema.annotation.PortableType;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.eclipse.aether.RepositorySystemSession;

public abstract class PortableTypeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject m_project;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> m_listRemoteRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository m_localRepository;
    @Component
    private ArtifactResolver m_artifactResolver;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession m_session;
    @Parameter(name="debug", property="pof.debug", defaultValue="false")
    private boolean m_fDebug;
    @Parameter(name="skip", property="pof.skip", defaultValue="false")
    private boolean m_fSkip = false;
    @Parameter(name="instrumentPofClasses", property="pof.instrument", defaultValue="true")
    private boolean m_fInstrumentPofClasses = true;
    @Parameter(name="indexPofClasses", property="pof.index", defaultValue="true")
    private boolean m_fIndexPofClasses = true;
    @Parameter(name="pofIndexFileName", property="pof.index.name", defaultValue="META-INF/pof.idx")
    private String m_sPofIndexFileName = "META-INF/pof.idx";
    @Parameter(name="pofIndexIncludes", property="pof.index.includes")
    private Set<String> m_sPofIndexIncludeFilterPatterns;
    @Parameter(name="pofIndexPackages", property="pof.index.packages")
    private Set<String> m_sPofIndexPackages;
    private final boolean f_fTests;

    PortableTypeMojo(boolean fTests) {
        this.f_fTests = fTests;
    }

    protected abstract File[] getClassesDirectories();

    public void execute() throws MojoExecutionException {
        try {
            MavenLogger log = new MavenLogger(this.getLog());
            if (this.m_fSkip) {
                log.info("PortableTypeGenerator code generation is skipped");
                return;
            }
            File[] aDirs = this.getClassesDirectories();
            List<File> listInstrument = this.validateClassesDirectories(aDirs, log);
            ArrayList<File> listDeps = new ArrayList<File>();
            listDeps.addAll(this.resolveDependencies());
            if (this.m_fInstrumentPofClasses) {
                SchemaBuilder builder = new SchemaBuilder();
                ClassFileSchemaSource source = new ClassFileSchemaSource();
                for (File dir : listInstrument) {
                    source.withClassesFromDirectory(dir).withTypeFilter(ClassFileSchemaSource.Filters.hasAnnotation(PortableType.class)).withMissingPropertiesAsObject();
                    File xmlSchema = Paths.get(dir.getPath(), "META-INF", "schema.xml").toFile();
                    if (!xmlSchema.exists()) continue;
                    builder.addSchemaSource((SchemaSource)new XmlSchemaSource(xmlSchema));
                }
                if (listInstrument.size() > 0) {
                    ClassFileSchemaSource dependencies = new ClassFileSchemaSource().withTypeFilter(ClassFileSchemaSource.Filters.hasAnnotation(PortableType.class)).withPropertyFilter(fieldNode -> false);
                    listDeps.stream().filter(File::isDirectory).peek(f -> log.debug("Adding classes from " + String.valueOf(f) + " to schema")).forEach(arg_0 -> ((ClassFileSchemaSource)dependencies).withClassesFromDirectory(arg_0));
                    listDeps.stream().filter(f -> f.isFile() && f.getName().endsWith(".jar")).peek(f -> log.debug("Adding classes from " + String.valueOf(f) + " to schema")).forEach(arg_0 -> ((ClassFileSchemaSource)dependencies).withClassesFromJarFile(arg_0));
                    Schema schema = builder.addSchemaSource((SchemaSource)dependencies).addSchemaSource((SchemaSource)source).build();
                    for (File dir : listInstrument) {
                        log.info("Running PortableTypeGenerator for classes in " + dir.getCanonicalPath());
                        PortableTypeGenerator.instrumentClasses((File)dir, (Schema)schema, (boolean)this.m_fDebug, (PortableTypeGenerator.Logger)log);
                    }
                }
            } else {
                log.info("PortableTypeGenerator class instrumentation is skipped");
            }
            if (this.m_fIndexPofClasses) {
                PofIndexer pofIndexer = new PofIndexer((PortableTypeGenerator.Logger)log).ignoreClasspath(true).withClassesFromDirectory(listInstrument).withClassesFromJarFile(listDeps).withIndexFileName(this.m_sPofIndexFileName);
                if (this.m_sPofIndexIncludeFilterPatterns != null && !this.m_sPofIndexIncludeFilterPatterns.isEmpty()) {
                    pofIndexer.setIncludeFilterPatterns(this.m_sPofIndexIncludeFilterPatterns);
                }
                if (this.m_sPofIndexPackages != null && !this.m_sPofIndexPackages.isEmpty()) {
                    pofIndexer.setPackagesToScan(this.m_sPofIndexPackages);
                }
                pofIndexer.createIndexInDirectory(this.getClassesDirectories()[0]);
            } else {
                log.info("PortableTypeGenerator indexing of classess is skipped");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to instrument classes", e);
        }
    }

    List<File> validateClassesDirectories(File[] aDirs, MavenLogger log) {
        ArrayList<File> listInstrument = new ArrayList<File>();
        if (aDirs.length == 0) {
            return listInstrument;
        }
        for (File dir : aDirs) {
            if (dir.isDirectory() && dir.exists()) {
                listInstrument.add(dir);
                continue;
            }
            log.info("PortableTypeGenerator skipping " + String.valueOf(dir) + " as it is not a directory");
        }
        return listInstrument;
    }

    public void setProject(MavenProject project) {
        this.m_project = project;
    }

    public void setRemoteRepositories(List<ArtifactRepository> listRemoteRepositories) {
        this.m_listRemoteRepositories = listRemoteRepositories;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.m_localRepository = localRepository;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.m_artifactResolver = artifactResolver;
    }

    public void setDebug(boolean fDebug) {
        this.m_fDebug = fDebug;
    }

    public void setSkip(boolean fSkip) {
        this.m_fSkip = fSkip;
    }

    public void setInstrumentPofClasses(boolean fInstrumentPofClasses) {
        this.m_fInstrumentPofClasses = fInstrumentPofClasses;
    }

    public void setIndexPofClasses(boolean fIndexPofClasses) {
        this.m_fIndexPofClasses = fIndexPofClasses;
    }

    public void setPofIndexFileName(String m_sPofIndexFileName) {
        this.m_sPofIndexFileName = m_sPofIndexFileName;
    }

    public void setPofIndexIncludes(Set<String> pofIndexIncludes) {
        this.m_sPofIndexIncludeFilterPatterns = pofIndexIncludes;
    }

    public void setPofIndexPackages(Set<String> pofIndexPackages) {
        this.m_sPofIndexPackages = pofIndexPackages;
    }

    private List<File> resolveDependencies() throws ArtifactResolverException {
        ArrayList<File> listArtifacts = new ArrayList<File>();
        Log log = this.getLog();
        for (Artifact artifact : this.m_project.getArtifacts()) {
            File file;
            if (artifact.getScope().equals("test") && !this.f_fTests) continue;
            String sArtifactId = artifact.getArtifactId();
            if (!artifact.isResolved()) {
                log.debug((CharSequence)("Resolving artifact " + String.valueOf(artifact)));
                ProjectBuildingRequest req = new DefaultProjectBuildingRequest().setRepositorySession(this.m_session).setLocalRepository(this.m_localRepository).setRemoteRepositories(this.m_listRemoteRepositories);
                ArtifactResult result = this.m_artifactResolver.resolveArtifact(req, artifact);
                artifact = result.getArtifact();
            }
            if ((file = artifact.getFile()) == null || !file.exists()) {
                log.warn((CharSequence)("Artifact " + sArtifactId + " has no attached file. Its content will not be copied to the target model directory."));
                continue;
            }
            log.debug((CharSequence)("Adding file: artifact=" + String.valueOf(artifact) + " file=" + String.valueOf(file)));
            listArtifacts.add(file);
        }
        return listArtifacts;
    }

    private static class MavenLogger
    implements PortableTypeGenerator.Logger {
        private final Log f_log;

        MavenLogger(Log log) {
            this.f_log = log;
        }

        public void debug(String message) {
            this.f_log.debug((CharSequence)message);
        }

        public void info(String message) {
            this.f_log.info((CharSequence)message);
        }
    }
}

