/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.maven.pof;

import com.oracle.coherence.common.schema.ClassFileSchemaSource;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.SchemaBuilder;
import com.oracle.coherence.common.schema.SchemaSource;
import com.oracle.coherence.common.schema.XmlSchemaSource;
import com.tangosol.io.pof.generator.PortableTypeGenerator;
import com.tangosol.io.pof.schema.annotation.PortableType;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.eclipse.aether.RepositorySystemSession;

public abstract class PortableTypeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject m_project;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> m_listRemoteRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository m_localRepository;
    @Component
    private ArtifactResolver m_artifactResolver;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession m_session;
    @Parameter(name="debug", property="pof.debug", defaultValue="false")
    private boolean m_fDebug;
    @Parameter(name="skip", property="pof.skip", defaultValue="false")
    private boolean m_fSkip = false;
    private final boolean f_fTests;

    PortableTypeMojo(boolean fTests) {
        this.f_fTests = fTests;
    }

    protected abstract File[] getClassesDirectories();

    public void execute() throws MojoExecutionException {
        try {
            MavenLogger log = new MavenLogger(this.getLog());
            if (this.m_fSkip) {
                log.info("PortableTypeGenerator code generation is skipped");
                return;
            }
            SchemaBuilder builder = new SchemaBuilder();
            ClassFileSchemaSource source = new ClassFileSchemaSource();
            File[] aDirs = this.getClassesDirectories();
            ArrayList<File> listInstrument = new ArrayList<File>();
            if (aDirs.length == 0) {
                return;
            }
            for (File dir : aDirs) {
                if (dir.isDirectory() && dir.exists()) {
                    source.withClassesFromDirectory(dir).withTypeFilter(ClassFileSchemaSource.Filters.hasAnnotation(PortableType.class)).withMissingPropertiesAsObject();
                    File xmlSchema = Paths.get(dir.getPath(), "META-INF", "schema.xml").toFile();
                    if (xmlSchema.exists()) {
                        builder.addSchemaSource((SchemaSource)new XmlSchemaSource(xmlSchema));
                    }
                    listInstrument.add(dir);
                    continue;
                }
                log.info("PortableTypeGenerator skipping " + dir + " as it is not a directory");
            }
            if (listInstrument.size() > 0) {
                List<File> listDeps = this.resolveDependencies();
                ClassFileSchemaSource dependencies = new ClassFileSchemaSource().withTypeFilter(ClassFileSchemaSource.Filters.hasAnnotation(PortableType.class)).withPropertyFilter(fieldNode -> false);
                listDeps.stream().filter(File::isDirectory).peek(f -> log.debug("Adding classes from " + f + " to schema")).forEach(arg_0 -> ((ClassFileSchemaSource)dependencies).withClassesFromDirectory(arg_0));
                listDeps.stream().filter(f -> f.isFile() && f.getName().endsWith(".jar")).peek(f -> log.debug("Adding classes from " + f + " to schema")).forEach(arg_0 -> ((ClassFileSchemaSource)dependencies).withClassesFromJarFile(arg_0));
                Schema schema = builder.addSchemaSource((SchemaSource)dependencies).addSchemaSource((SchemaSource)source).build();
                for (File dir : listInstrument) {
                    log.info("Running PortableTypeGenerator for classes in " + dir.getCanonicalPath());
                    PortableTypeGenerator.instrumentClasses((File)dir, (Schema)schema, (boolean)this.m_fDebug, (PortableTypeGenerator.Logger)log);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to instrument classes", e);
        }
    }

    public void setProject(MavenProject project) {
        this.m_project = project;
    }

    public void setRemoteRepositories(List<ArtifactRepository> listRemoteRepositories) {
        this.m_listRemoteRepositories = listRemoteRepositories;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.m_localRepository = localRepository;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.m_artifactResolver = artifactResolver;
    }

    public void setDebug(boolean fDebug) {
        this.m_fDebug = fDebug;
    }

    public void setSkip(boolean fSkip) {
        this.m_fSkip = fSkip;
    }

    private List<File> resolveDependencies() throws ArtifactResolverException {
        ArrayList<File> listArtifacts = new ArrayList<File>();
        Log log = this.getLog();
        for (Artifact artifact : this.m_project.getArtifacts()) {
            File file;
            if (artifact.getScope().equals("test") && !this.f_fTests) continue;
            String sArtifactId = artifact.getArtifactId();
            if (!artifact.isResolved()) {
                log.debug((CharSequence)("Resolving artifact " + artifact));
                ProjectBuildingRequest req = new DefaultProjectBuildingRequest().setRepositorySession(this.m_session).setLocalRepository(this.m_localRepository).setRemoteRepositories(this.m_listRemoteRepositories);
                ArtifactResult result = this.m_artifactResolver.resolveArtifact(req, artifact);
                artifact = result.getArtifact();
            }
            if ((file = artifact.getFile()) == null || !file.exists()) {
                log.warn((CharSequence)("Artifact " + sArtifactId + " has no attached file. Its content will not be copied to the target model directory."));
                continue;
            }
            log.debug((CharSequence)("Adding file: artifact=" + artifact + " file=" + file));
            listArtifacts.add(file);
        }
        return listArtifacts;
    }

    private static class MavenLogger
    implements PortableTypeGenerator.Logger {
        private final Log f_log;

        MavenLogger(Log log) {
            this.f_log = log;
        }

        public void debug(String message) {
            this.f_log.debug((CharSequence)message);
        }

        public void info(String message) {
            this.f_log.info((CharSequence)message);
        }
    }
}

