/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.gradle;

import java.io.File;
import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;

public final class PluginUtils {
    private PluginUtils() {
        throw new AssertionError((Object)"This is a static utility class.");
    }

    static int getGradleMajorVersion(Project project) {
        Objects.requireNonNull(project, "The provided project must not be null.");
        String sGradleVersion = project.getGradle().getGradleVersion();
        return Integer.parseInt(sGradleVersion.substring(0, sGradleVersion.indexOf(".")));
    }

    static Directory getMainJavaOutputDir(Project project) {
        Objects.requireNonNull(project, "The provided project must not be null.");
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet sourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
        Directory fileClassesDir = (Directory)sourceSet.getJava().getClassesDirectory().getOrNull();
        Logger logger = project.getLogger();
        if (fileClassesDir == null) {
            logger.warn("Main Java output directory not available.");
        } else {
            logger.warn("Main Java output directory: {}.", (Object)fileClassesDir.getAsFile().getAbsolutePath());
        }
        return fileClassesDir;
    }

    static File getMainResourcesOutputDir(Project project) {
        Objects.requireNonNull(project, "The provided project must not be null.");
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet sourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
        File fileResourcesDir = sourceSet.getOutput().getResourcesDir();
        Logger logger = project.getLogger();
        if (fileResourcesDir == null) {
            logger.warn("Main Resources output directory not available.");
        } else {
            logger.warn("Main Resources output directory: {}.", (Object)fileResourcesDir.getAbsolutePath());
        }
        return fileResourcesDir;
    }

    static Directory getTestJavaOutputDir(Project project) {
        Objects.requireNonNull(project, "The provided project must not be null.");
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet sourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("test");
        Directory fileClassesDir = (Directory)sourceSet.getJava().getClassesDirectory().getOrNull();
        Logger logger = project.getLogger();
        if (fileClassesDir == null) {
            logger.warn("Test Java output directory not available.");
        } else {
            logger.warn("Test Java output directory: {}.", (Object)fileClassesDir.getAsFile().getAbsolutePath());
        }
        return fileClassesDir;
    }

    static File getTestResourcesOutputDir(Project project) {
        Objects.requireNonNull(project, "The provided project must not be null.");
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet sourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("test");
        File fileResourcesDir = sourceSet.getOutput().getResourcesDir();
        Logger logger = project.getLogger();
        if (fileResourcesDir == null) {
            logger.warn("Test Resources output directory not available.");
        } else {
            logger.warn("Test Resources output directory: {}.", (Object)fileResourcesDir.getAbsolutePath());
        }
        return fileResourcesDir;
    }
}

