/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.gradle;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.schema.ClassFileSchemaSource;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.SchemaBuilder;
import com.oracle.coherence.common.schema.SchemaSource;
import com.oracle.coherence.common.schema.XmlSchemaSource;
import com.oracle.coherence.gradle.GradleLogger;
import com.oracle.coherence.gradle.PluginUtils;
import com.tangosol.io.pof.generator.PortableTypeGenerator;
import com.tangosol.io.pof.schema.annotation.PortableType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

abstract class CoherenceTask
extends DefaultTask {
    @Inject
    public CoherenceTask(Project project) {
        File testResourcesOutputDir;
        this.getLogger().info("Setting up Task property conventions.");
        this.getDebug().convention((Object)false);
        this.getInstrumentTestClasses().convention((Object)false);
        Directory mainJavaOutputDir = PluginUtils.getMainJavaOutputDir(project);
        this.getMainClassesDirectory().convention((Object)mainJavaOutputDir.getAsFile());
        Directory testJavaOutputDir = PluginUtils.getTestJavaOutputDir(project);
        this.getTestClassesDirectory().convention((Object)testJavaOutputDir.getAsFile());
        File fileMainResourcesOutputDir = PluginUtils.getMainResourcesOutputDir(project);
        if (fileMainResourcesOutputDir != null) {
            this.getMainResourcesDirectory().convention((Object)fileMainResourcesOutputDir);
        }
        if ((testResourcesOutputDir = PluginUtils.getTestResourcesOutputDir(project)) != null) {
            this.getTestResourcesDirectory().convention((Object)testResourcesOutputDir);
        }
    }

    @Input
    @Optional
    public abstract Property<Boolean> getDebug();

    @Input
    @Optional
    public abstract Property<Boolean> getInstrumentTestClasses();

    @InputFiles
    @Optional
    public abstract Property<File> getTestClassesDirectory();

    @InputFiles
    @Optional
    public abstract Property<File> getTestResourcesDirectory();

    @InputFiles
    @Optional
    public abstract Property<File> getMainClassesDirectory();

    @InputFiles
    @Optional
    public abstract Property<File> getMainResourcesDirectory();

    @TaskAction
    public void instrumentPofClasses() {
        boolean fDebug = (Boolean)this.getDebug().get();
        Logger logger = this.getLogger();
        logger.lifecycle("Start executing Gradle task instrumentPofClasses...");
        logger.info("The following configuration properties are configured:");
        logger.info("Property debug = {}", (Object)fDebug);
        logger.info("Property instrumentTestClasses = {}", this.getInstrumentTestClasses().get());
        Property<File> propTestClassesDirectory = this.getTestClassesDirectory();
        logger.info("Property testClassesDirectory = {}", propTestClassesDirectory);
        Property<File> propMainClassesDirectory = this.getMainClassesDirectory();
        logger.info("Property mainClassesDirectory = {}", propMainClassesDirectory);
        ClassFileSchemaSource source = new ClassFileSchemaSource();
        ArrayList<File> listInstrument = new ArrayList<File>();
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        ArrayList<File> listClassesDirectories = new ArrayList<File>();
        this.addSchemaSourceIfExists(schemaBuilder, this.getTestResourcesDirectory());
        this.addSchemaSourceIfExists(schemaBuilder, this.getMainResourcesDirectory());
        if (propTestClassesDirectory.isPresent() && ((File)propTestClassesDirectory.get()).exists()) {
            File fileTestClassesDirectory = (File)propTestClassesDirectory.get();
            listClassesDirectories.add(fileTestClassesDirectory);
        } else {
            logger.error("PortableTypeGenerator skipping test classes directory as it does not exist.");
        }
        if (propMainClassesDirectory.isPresent() && ((File)propMainClassesDirectory.get()).exists()) {
            File fileMainClassesDirectory = (File)propMainClassesDirectory.get();
            listClassesDirectories.add(fileMainClassesDirectory);
        } else {
            logger.error("PortableTypeGenerator skipping main classes directory as it does not exist.");
        }
        if (!listClassesDirectories.isEmpty()) {
            source.withTypeFilter(ClassFileSchemaSource.Filters.hasAnnotation(PortableType.class)).withMissingPropertiesAsObject();
            for (File classesDir : listClassesDirectories) {
                source.withClassesFromDirectory(classesDir);
                listInstrument.add(classesDir);
            }
        }
        if (!listInstrument.isEmpty()) {
            List<File> listDeps = this.resolveDependencies();
            ClassFileSchemaSource dependencies = new ClassFileSchemaSource().withTypeFilter(ClassFileSchemaSource.Filters.hasAnnotation(PortableType.class)).withPropertyFilter(fieldNode -> false);
            listDeps.stream().filter(File::isDirectory).peek(f -> logger.lifecycle("Adding classes from " + f + " to schema")).forEach(arg_0 -> ((ClassFileSchemaSource)dependencies).withClassesFromDirectory(arg_0));
            listDeps.stream().filter(f -> f.isFile() && f.getName().endsWith(".jar")).peek(f -> logger.lifecycle("Adding classes from " + f + " to schema")).forEach(arg_0 -> ((ClassFileSchemaSource)dependencies).withClassesFromJarFile(arg_0));
            Schema schema = schemaBuilder.addSchemaSource((SchemaSource)dependencies).addSchemaSource((SchemaSource)source).build();
            for (File dir : listInstrument) {
                try {
                    logger.warn("Running PortableTypeGenerator for classes in " + dir.getCanonicalPath());
                    PortableTypeGenerator.instrumentClasses((File)dir, (Schema)schema, (boolean)fDebug, (PortableTypeGenerator.Logger)new GradleLogger(logger));
                }
                catch (IOException e) {
                    throw Exceptions.ensureRuntimeException((Throwable)e);
                }
            }
        }
    }

    private void addSchemaSourceIfExists(SchemaBuilder builder, Property<File> propResourcesDirectory) {
        Logger logger = this.getLogger();
        if (propResourcesDirectory.isPresent()) {
            File fileResourcesDirectory = (File)propResourcesDirectory.get();
            if (fileResourcesDirectory.exists()) {
                File xmlSchema = Paths.get(fileResourcesDirectory.getPath(), "META-INF", "schema.xml").toFile();
                if (xmlSchema.exists()) {
                    logger.lifecycle("Add XmlSchemaSource '{}'.", new Object[]{xmlSchema.getAbsolutePath()});
                    builder.addSchemaSource((SchemaSource)new XmlSchemaSource(xmlSchema));
                } else {
                    logger.info("No schema.xml file found at {}", (Object)xmlSchema.getAbsolutePath());
                }
            } else {
                logger.info("The specified resources directory '{}' does not exist.", (Object)fileResourcesDirectory.getAbsolutePath());
            }
        } else {
            logger.info("The resources directory property is not present.");
        }
    }

    private List<File> resolveDependencies() {
        ArrayList<File> listArtifacts = new ArrayList<File>();
        Configuration configuration = this.getProject().getConfigurations().getByName("runtimeClasspath");
        configuration.forEach(file -> {
            this.getLogger().info("Adding dependency '{}'.", (Object)file.getAbsolutePath());
            if (file.exists()) {
                listArtifacts.add((File)file);
            } else {
                this.getLogger().info("Dependency '{}' does not exist.", (Object)file.getAbsolutePath());
            }
        });
        this.getLogger().lifecycle("Resolved {} dependencies.", new Object[]{listArtifacts.size()});
        return listArtifacts;
    }
}

