/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.gradle;

import com.oracle.coherence.gradle.CoherenceExtension;
import com.oracle.coherence.gradle.CoherenceTask;
import com.oracle.coherence.gradle.PluginUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.compile.JavaCompile;

public class CoherencePlugin
implements Plugin<Project> {
    private static final String POF_TASK_NAME = "coherencePof";
    private static final int MINIMAL_SUPPORTED_GRADLE_VERSION = 7;

    public void apply(Project project) {
        project.getLogger().debug("Configuring the Coherence Gradle Plugin.");
        if (PluginUtils.getGradleMajorVersion(project) < 7) {
            throw new GradleException("The Coherence Gradle plugin requires Gradle version 7 or higher.");
        }
        if (!project.getPluginManager().hasPlugin("java")) {
            throw new GradleException("The Java Gradle plugin has not been applied.");
        }
        project.getExtensions().create(POF_TASK_NAME, CoherenceExtension.class, new Object[0]);
        project.getTasks().register(POF_TASK_NAME, CoherenceTask.class, coherencePofTask -> {
            coherencePofTask.dependsOn(new Object[]{"compileJava", "processResources"});
            CoherenceExtension coherenceExtension = (CoherenceExtension)project.getExtensions().getByType(CoherenceExtension.class);
            if (coherenceExtension.getDebug().isPresent()) {
                coherencePofTask.getDebug().set((Object)((Boolean)coherenceExtension.getDebug().get()));
            }
            if (coherenceExtension.getMainClassesDirectory().isPresent()) {
                coherencePofTask.getMainClassesDirectory().set(coherenceExtension.getMainClassesDirectory().getAsFile());
            }
            if (coherenceExtension.getInstrumentTestClasses().isPresent()) {
                coherencePofTask.dependsOn(new Object[]{"compileTestJava", "processTestResources"});
                coherencePofTask.getInstrumentTestClasses().set(coherenceExtension.getInstrumentTestClasses());
            }
            if (coherenceExtension.getTestClassesDirectory().isPresent()) {
                coherencePofTask.getTestClassesDirectory().set(coherenceExtension.getTestClassesDirectory().getAsFile());
            }
        });
        JavaCompile javaCompileTask = (JavaCompile)project.getTasks().findByName("compileJava");
        if (javaCompileTask != null) {
            javaCompileTask.finalizedBy(new Object[]{POF_TASK_NAME});
        }
    }
}

