/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.gradle;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoherenceBuildTimeProperties {
    public static final String PROPERTIES_FILE_NAME = "/coherence-gradle-plugin.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(CoherenceBuildTimeProperties.class);
    private final String m_sCoherenceGroupId;
    private final String m_sCoherenceVersion;
    private final String m_sCoherenceLocalDependencyRepo;

    public CoherenceBuildTimeProperties() {
        Properties coherenceBuildTimeProperties = new Properties();
        try (InputStream is = CoherenceBuildTimeProperties.class.getResourceAsStream(PROPERTIES_FILE_NAME);){
            coherenceBuildTimeProperties.load(is);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load properties from InputStream");
        }
        String sCoherenceGroupId = coherenceBuildTimeProperties.getProperty("coherence-group-id");
        Objects.requireNonNull(sCoherenceGroupId, "Property coherence-group-id must not be null");
        String sCoherenceVersion = coherenceBuildTimeProperties.getProperty("coherence-version");
        Objects.requireNonNull(sCoherenceVersion, "Property coherence-version must not be null");
        String sCoherenceLocalDependencyRepo = coherenceBuildTimeProperties.getProperty("local-dependency-repo").replace("\\", "/");
        Objects.requireNonNull(sCoherenceVersion, "Property local-dependency-repo must not be null");
        this.m_sCoherenceGroupId = sCoherenceGroupId;
        this.m_sCoherenceVersion = sCoherenceVersion;
        this.m_sCoherenceLocalDependencyRepo = sCoherenceLocalDependencyRepo;
        LOGGER.info("Retrieved CoherenceBuildTimeProperty 'coherence-group-id' with value: {}", (Object)this.m_sCoherenceGroupId);
        LOGGER.info("Retrieved CoherenceBuildTimeProperty 'coherence-version' with value: {}", (Object)this.m_sCoherenceVersion);
        LOGGER.info("Retrieved CoherenceBuildTimeProperty 'local-dependency-repo' with value: {}", (Object)this.m_sCoherenceLocalDependencyRepo);
    }

    public String getCoherenceGroupId() {
        return this.m_sCoherenceGroupId;
    }

    public String getCoherenceVersion() {
        return this.m_sCoherenceVersion;
    }

    public String getCoherenceLocalDependencyRepo() {
        return this.m_sCoherenceLocalDependencyRepo;
    }
}

