/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.io;

import com.tangosol.coherence.rest.KeyConverter;
import com.tangosol.coherence.rest.io.Marshaller;
import com.tangosol.util.Base;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;

public class KeyConverterAdapter
implements Marshaller<Object> {
    private final KeyConverter m_keyConverter;

    public KeyConverterAdapter(KeyConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException("null converter");
        }
        this.m_keyConverter = converter;
    }

    @Override
    public void marshal(Object oValue, OutputStream out, MultivaluedMap<String, Object> httpHeaders) throws IOException {
        PrintStream stream = new PrintStream(out);
        stream.print(this.m_keyConverter.toString(oValue));
        stream.flush();
    }

    @Override
    public Object unmarshal(InputStream in, MediaType mediaType) throws IOException {
        String sInput = Base.read((Reader)new InputStreamReader(in));
        return this.m_keyConverter.fromString(sInput);
    }
}

