/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.io;

import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.rest.io.AbstractMarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;

public class JaxbXmlMarshaller<T>
extends AbstractMarshaller<T> {
    private JAXBContext m_ctx;

    public JaxbXmlMarshaller(Class<T> clzRoot) {
        super(clzRoot);
        try {
            this.m_ctx = JAXBContext.newInstance((Class[])new Class[]{clzRoot});
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("error creating JAXB context for class \"" + clzRoot.getName() + "\"", e);
        }
    }

    @Override
    public void marshal(T value, OutputStream out, MultivaluedMap<String, Object> httpHeaders) throws IOException {
        try {
            Marshaller marshaller = this.m_ctx.createMarshaller();
            this.configureJaxbMarshaller(marshaller);
            marshaller.marshal(value, out);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void marshalAsFragment(T value, OutputStream out, MultivaluedMap<String, Object> httpHeaders) throws IOException {
        try {
            Marshaller marshaller = this.m_ctx.createMarshaller();
            this.configureJaxbMarshaller(marshaller);
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal(value, out);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public T unmarshal(InputStream in, MediaType mediaType) throws IOException {
        try {
            Unmarshaller unmarshaller = this.m_ctx.createUnmarshaller();
            this.configureJaxbUnmarshaller(unmarshaller);
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.supportDTD", Config.getBoolean((String)"coherence.rest.xml.allowDTD"));
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", Config.getBoolean((String)"coherence.rest.xml.allowExternalEntities"));
            return (T)unmarshaller.unmarshal(xif.createXMLStreamReader(new StreamSource(in)), this.getRootClass()).getValue();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        catch (XMLStreamException e) {
            throw new IOException("XML stream reader exception.", e);
        }
    }

    protected void configureJaxbMarshaller(Marshaller marshaller) throws PropertyException {
        marshaller.setProperty("jaxb.formatted.output", (Object)Config.getBoolean((String)"coherence.rest.format-output"));
    }

    protected void configureJaxbUnmarshaller(Unmarshaller unmarshaller) throws PropertyException {
    }
}

