/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.io;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.rest.DefaultKeyConverter;
import com.tangosol.coherence.rest.io.JacksonJsonMarshaller;
import com.tangosol.coherence.rest.io.JaxbXmlMarshaller;
import com.tangosol.coherence.rest.io.KeyConverterAdapter;
import com.tangosol.coherence.rest.io.Marshaller;
import com.tangosol.coherence.rest.io.StaticContentMarshaller;
import com.tangosol.coherence.rest.io.StringMarshaller;
import com.tangosol.coherence.rest.util.JsonMap;
import com.tangosol.coherence.rest.util.StaticContent;
import com.tangosol.util.Base;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class MarshallerRegistry {
    private static final Marshaller NULL_MARSHALLER = new NullMarshaller();
    private ConcurrentMap<String, Marshaller> m_mapMarshallers = new ConcurrentHashMap<String, Marshaller>();
    private ConcurrentMap<String, Class> m_mapDefaultMarshallers = new ConcurrentHashMap<String, Class>();

    public MarshallerRegistry() {
        this.setDefaultMarshaller("application/json", JacksonJsonMarshaller.class);
        this.setDefaultMarshaller("application/xml", JaxbXmlMarshaller.class);
        this.setDefaultMarshaller("text/plain", StringMarshaller.class);
        this.registerMarshaller(StaticContent.class, MediaType.WILDCARD_TYPE, (Marshaller)new StaticContentMarshaller());
        this.registerMarshaller(StaticContent.class, "application/json", new JacksonJsonMarshaller<JsonMap>(JsonMap.class));
        this.registerMarshaller(JsonMap.class, "application/json", new JacksonJsonMarshaller<JsonMap>(JsonMap.class));
        this.registerMarshaller(Short.class, MediaType.WILDCARD_TYPE, (Marshaller)new KeyConverterAdapter(new DefaultKeyConverter(Short.class)));
        this.registerMarshaller(Integer.class, MediaType.WILDCARD_TYPE, (Marshaller)new KeyConverterAdapter(new DefaultKeyConverter(Integer.class)));
        this.registerMarshaller(Long.class, MediaType.WILDCARD_TYPE, (Marshaller)new KeyConverterAdapter(new DefaultKeyConverter(Long.class)));
        this.registerMarshaller(Float.class, MediaType.WILDCARD_TYPE, (Marshaller)new KeyConverterAdapter(new DefaultKeyConverter(Float.class)));
        this.registerMarshaller(Double.class, MediaType.WILDCARD_TYPE, (Marshaller)new KeyConverterAdapter(new DefaultKeyConverter(Double.class)));
        this.registerMarshaller(String.class, "application/json", JacksonJsonMarshaller.class);
        this.registerMarshaller(String.class, MediaType.WILDCARD_TYPE, (Marshaller)new KeyConverterAdapter(new DefaultKeyConverter(String.class)));
        this.registerMarshaller(BigDecimal.class, MediaType.WILDCARD_TYPE, (Marshaller)new KeyConverterAdapter(new DefaultKeyConverter(BigDecimal.class)));
        this.registerMarshaller(BigInteger.class, MediaType.WILDCARD_TYPE, (Marshaller)new KeyConverterAdapter(new DefaultKeyConverter(BigInteger.class)));
    }

    public Marshaller getMarshaller(Class clzRoot, MediaType mediaType) {
        String sMediaType = mediaType.getType() + "/" + mediaType.getSubtype();
        return this.getMarshaller(clzRoot, sMediaType);
    }

    public Marshaller getMarshaller(Class clzRoot, String sMediaType) {
        Marshaller old;
        String sKey = this.createKey(clzRoot, sMediaType);
        Marshaller marshaller = (Marshaller)this.m_mapMarshallers.get(sKey);
        if (marshaller == null && (marshaller = (Marshaller)this.m_mapMarshallers.get(this.createKey(clzRoot, "*/*"))) == null && (marshaller = this.createDefaultMarshaller(clzRoot, sMediaType)) != null && (old = this.m_mapMarshallers.putIfAbsent(sKey, marshaller)) != null) {
            marshaller = old;
        }
        return marshaller == NULL_MARSHALLER ? null : marshaller;
    }

    public void registerMarshaller(Class clzRoot, MediaType mediaType, Class clzMarshaller) {
        this.registerMarshaller(clzRoot, mediaType.toString(), clzMarshaller);
    }

    public void registerMarshaller(Class clzRoot, String sMediaType, Class clzMarshaller) {
        this.registerMarshaller(clzRoot, sMediaType, this.createMarshaller(clzRoot, sMediaType, clzMarshaller));
    }

    public void registerMarshaller(Class clzRoot, MediaType mediaType, Marshaller marshaller) {
        this.registerMarshaller(clzRoot, mediaType.toString(), marshaller);
    }

    public void registerMarshaller(Class clzRoot, String sMediaType, Marshaller marshaller) {
        this.m_mapMarshallers.put(this.createKey(clzRoot, sMediaType), marshaller);
    }

    public void setDefaultMarshaller(MediaType mediaType, Class clzMarshaller) {
        this.setDefaultMarshaller(mediaType.toString(), clzMarshaller);
    }

    public void setDefaultMarshaller(String sMediaType, Class clzMarshaller) {
        this.m_mapDefaultMarshallers.put(sMediaType, clzMarshaller);
    }

    public void setDefaultMarshallers(Map<String, Class> mapMarshallers) {
        for (Map.Entry<String, Class> entry : mapMarshallers.entrySet()) {
            this.m_mapDefaultMarshallers.put(entry.getKey(), entry.getValue());
        }
    }

    protected String createKey(Class clzRoot, String sMediaType) {
        return clzRoot.getName() + ":" + sMediaType;
    }

    protected Marshaller createDefaultMarshaller(Class clzRoot, String sMediaType) {
        Class clzDefaultMarshaller = (Class)this.m_mapDefaultMarshallers.get(sMediaType);
        if (clzDefaultMarshaller == null) {
            Logger.warn((String)("Default marshaller for media type " + sMediaType + " is not registered."));
            return NULL_MARSHALLER;
        }
        return this.createMarshaller(clzRoot, sMediaType, clzDefaultMarshaller);
    }

    protected Marshaller createMarshaller(Class<?> clzRoot, String sMediaType, Class<?> clzMarshaller) {
        if (clzMarshaller == null || !Marshaller.class.isAssignableFrom(clzMarshaller)) {
            throw new IllegalArgumentException("invalid marshaller: " + String.valueOf(clzMarshaller));
        }
        Constructor<?> ctor = null;
        try {
            ctor = clzMarshaller.getConstructor(Class.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            return ctor == null ? (Marshaller)clzMarshaller.newInstance() : (Marshaller)ctor.newInstance(clzRoot);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e, (String)("error creating marshaller " + String.valueOf(clzMarshaller) + " for class \"" + clzRoot.getName() + "\" and media type \"" + sMediaType + "\""));
        }
    }

    private static class NullMarshaller
    implements Marshaller<Object> {
        private NullMarshaller() {
        }

        @Override
        public void marshal(Object oValue, OutputStream out, MultivaluedMap<String, Object> httpHeaders) throws IOException {
        }

        @Override
        public Object unmarshal(InputStream in, MediaType mediaType) throws IOException {
            return null;
        }
    }
}

