/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util;

import com.oracle.coherence.rest.internal.asm.ClassReader;
import com.oracle.coherence.rest.internal.asm.ClassVisitor;
import com.oracle.coherence.rest.internal.asm.ClassWriter;
import com.oracle.coherence.rest.internal.asm.Type;
import com.oracle.coherence.rest.internal.asm.tree.AnnotationNode;
import com.oracle.coherence.rest.internal.asm.tree.ClassNode;
import com.oracle.coherence.rest.internal.asm.tree.InsnNode;
import com.oracle.coherence.rest.internal.asm.tree.LdcInsnNode;
import com.oracle.coherence.rest.internal.asm.tree.MethodInsnNode;
import com.oracle.coherence.rest.internal.asm.tree.MethodNode;
import com.oracle.coherence.rest.internal.asm.tree.TypeInsnNode;
import com.oracle.coherence.rest.internal.asm.tree.VarInsnNode;
import com.tangosol.coherence.rest.util.PropertySet;
import com.tangosol.coherence.rest.util.PropertySpec;
import com.tangosol.util.Base;
import com.tangosol.util.CopyOnWriteMap;
import com.tangosol.util.UID;
import com.tangosol.util.asm.BaseClassReaderInternal;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class PartialObject {
    protected static Map<PartialClassLoader, ConcurrentHashMap<String, Class>> s_mapPartialClasses = new CopyOnWriteMap(WeakHashMap.class);
    protected static Map<PartialClassLoader, ConcurrentHashMap<String, Constructor>> s_mapPartialConstructors = new CopyOnWriteMap(WeakHashMap.class);
    protected static Map<ClassLoader, PartialClassLoader> s_mapPartialClassLoaders = new CopyOnWriteMap(WeakHashMap.class);
    protected Map m_mapProperties;

    public PartialObject() {
    }

    public PartialObject(Map mapProperties) {
        this.m_mapProperties = mapProperties;
    }

    public Object get(String sName) {
        return this.m_mapProperties.get(sName);
    }

    public String toString() {
        return "PartialObject{properties=" + this.m_mapProperties + "}";
    }

    public static Object create(Object oSource, PropertySet propertySet) {
        return propertySet.extract(oSource);
    }

    public static PartialObject create(Class clzSource, PropertySet propertySet, Map<String, Object> mapProperties) {
        try {
            String sKey = PartialObject.createKey(clzSource, propertySet);
            ConcurrentHashMap<String, Constructor> mapPartial = PartialObject.getPartialConstructorMap(PartialObject.getPartialClassLoader());
            Constructor ctorPartial = (Constructor)mapPartial.get(sKey);
            if (ctorPartial == null) {
                Class clzPartial = PartialObject.getPartialClass(clzSource, propertySet);
                ctorPartial = clzPartial.getConstructor(Map.class);
                Constructor ctorOld = mapPartial.putIfAbsent(sKey, ctorPartial);
                if (ctorOld != null) {
                    ctorPartial = ctorOld;
                }
            }
            return (PartialObject)ctorPartial.newInstance(mapProperties);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    public static Class getPartialClass(Class clzSource, PropertySet propertySet) {
        Class clzOld;
        String sKey = PartialObject.createKey(clzSource, propertySet);
        ConcurrentHashMap<String, Class> mapPartial = PartialObject.getPartialClassMap(PartialObject.getPartialClassLoader());
        Class clzPartial = (Class)mapPartial.get(sKey);
        if (clzPartial == null && (clzOld = mapPartial.putIfAbsent(sKey, clzPartial = PartialObject.createPartialClass(clzSource, propertySet))) != null) {
            clzPartial = clzOld;
        }
        return clzPartial;
    }

    public static <T> Class createPartialClass(Class clzSource, PropertySet<T> propertySet) {
        ClassNode cn = new ClassNode();
        cn.version = 52;
        cn.access = 1;
        cn.superName = "com/tangosol/coherence/rest/util/PartialObject";
        cn.name = "com/tangosol/coherence/rest/util/gen/partial/" + clzSource.getSimpleName() + "_" + new UID();
        ClassNode cnSrc = PartialObject.getClassNode(clzSource);
        PartialObject.copyClassAnnotations(cnSrc, cn);
        PartialObject.createConstructors(cn);
        ArrayList<ClassNode> listClassNodes = new ArrayList<ClassNode>();
        while (!clzSource.equals(Object.class)) {
            listClassNodes.add(cnSrc);
            clzSource = clzSource.getSuperclass();
            cnSrc = PartialObject.getClassNode(clzSource);
        }
        for (PropertySpec p : propertySet) {
            MethodNode mn = PartialObject.findProperty(listClassNodes, p.getName());
            if (mn == null) continue;
            if (p.isPartial()) {
                mn.desc = "()" + Type.getDescriptor(p.getPartialClass());
                mn.signature = null;
            }
            mn.instructions.clear();
            mn.instructions.add(new VarInsnNode(25, 0));
            mn.instructions.add(new LdcInsnNode(p.getName()));
            mn.instructions.add(new MethodInsnNode(182, cn.name, "get", "(Ljava/lang/String;)Ljava/lang/Object;", false));
            PartialObject.castReturnValue(mn);
            cn.methods.add(mn);
            Character chFirst = Character.valueOf(p.getName().charAt(0));
            String sSetterName = "set" + chFirst.toString().toUpperCase() + p.getName().substring(1);
            MethodNode setter = new MethodNode(1, sSetterName, "(" + Type.getReturnType(mn.desc) + ")V", null, null);
            setter.instructions.add(new InsnNode(177));
            cn.methods.add(setter);
        }
        return PartialObject.createClass(cn);
    }

    protected static String createKey(Class clzSource, PropertySet propertySet) {
        return clzSource.getName() + "(" + propertySet + ")";
    }

    protected static void copyClassAnnotations(ClassNode cnSource, ClassNode cnTarget) {
        List<AnnotationNode> listAnnotations = cnSource.visibleAnnotations;
        if (listAnnotations != null) {
            for (AnnotationNode an : listAnnotations) {
                if (an.desc.equals("Lcom/fasterxml/jackson/annotation/JsonTypeInfo;")) continue;
                if (cnTarget.visibleAnnotations == null) {
                    cnTarget.visibleAnnotations = new ArrayList<AnnotationNode>(cnSource.visibleAnnotations.size());
                }
                cnTarget.visibleAnnotations.add(an);
            }
        }
    }

    protected static void createConstructors(ClassNode cn) {
        MethodNode ctorDefault = new MethodNode(1, "<init>", "()V", null, null);
        ctorDefault.instructions.add(new VarInsnNode(25, 0));
        ctorDefault.instructions.add(new MethodInsnNode(183, "com/tangosol/coherence/rest/util/PartialObject", "<init>", "()V", false));
        ctorDefault.instructions.add(new InsnNode(177));
        cn.methods.add(ctorDefault);
        MethodNode ctorMap = new MethodNode(1, "<init>", "(Ljava/util/Map;)V", null, null);
        ctorMap.instructions.add(new VarInsnNode(25, 0));
        ctorMap.instructions.add(new VarInsnNode(25, 1));
        ctorMap.instructions.add(new MethodInsnNode(183, "com/tangosol/coherence/rest/util/PartialObject", "<init>", "(Ljava/util/Map;)V", false));
        ctorMap.instructions.add(new InsnNode(177));
        cn.methods.add(ctorMap);
    }

    protected static void castReturnValue(MethodNode mn) {
        Type typeReturn = Type.getReturnType(mn.desc);
        String sType = typeReturn.getDescriptor();
        if (sType.length() > 1) {
            mn.instructions.add(new TypeInsnNode(192, typeReturn.getInternalName()));
            mn.instructions.add(new InsnNode(176));
        } else {
            String sMethod;
            String sClass;
            int nRetCode = 172;
            char cType = sType.charAt(0);
            switch (cType) {
                case 'Z': {
                    sClass = "java/lang/Boolean";
                    sMethod = "booleanValue";
                    break;
                }
                case 'B': {
                    sClass = "java/lang/Byte";
                    sMethod = "byteValue";
                    break;
                }
                case 'C': {
                    sClass = "java/lang/Character";
                    sMethod = "charValue";
                    break;
                }
                case 'S': {
                    sClass = "java/lang/Short";
                    sMethod = "shortValue";
                    break;
                }
                case 'I': {
                    sClass = "java/lang/Integer";
                    sMethod = "intValue";
                    break;
                }
                case 'J': {
                    sClass = "java/lang/Long";
                    sMethod = "longValue";
                    nRetCode = 173;
                    break;
                }
                case 'F': {
                    sClass = "java/lang/Float";
                    sMethod = "floatValue";
                    nRetCode = 174;
                    break;
                }
                case 'D': {
                    sClass = "java/lang/Double";
                    sMethod = "doubleValue";
                    nRetCode = 175;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported type: " + sType);
                }
            }
            mn.instructions.add(new TypeInsnNode(192, sClass));
            mn.instructions.add(new MethodInsnNode(182, sClass, sMethod, "()" + cType, false));
            mn.instructions.add(new InsnNode(nRetCode));
        }
    }

    protected static Class createClass(ClassNode cn) {
        ClassWriter cw = new ClassWriter(3);
        cn.accept(cw);
        return PartialObject.getPartialClassLoader().defineClass(cn.name.replace('/', '.'), cw.toByteArray());
    }

    protected static MethodNode findProperty(List<ClassNode> listClassNodes, String sName) {
        for (ClassNode cn : listClassNodes) {
            MethodNode mn = PartialObject.findProperty(cn, sName);
            if (mn == null) continue;
            return mn;
        }
        return null;
    }

    protected static MethodNode findProperty(ClassNode cn, String sName) {
        for (MethodNode mn : cn.methods) {
            if (!mn.desc.startsWith("()") || !PartialObject.isMatch(mn.name, sName)) continue;
            return mn;
        }
        return null;
    }

    protected static boolean isMatch(String sMethodName, String sPropertyName) {
        if (sMethodName.startsWith("get")) {
            sMethodName = sMethodName.substring(3);
        } else if (sMethodName.startsWith("is")) {
            sMethodName = sMethodName.substring(2);
        }
        return sMethodName.equalsIgnoreCase(sPropertyName);
    }

    protected static ClassNode getClassNode(Class clz) {
        InputStream classStream = null;
        try {
            ClassNode cn = new ClassNode();
            classStream = PartialObject.getPartialClassLoader().getResourceAsStream(clz.getName().replace('.', '/') + ".class");
            ClassReaderInternal cr = new ClassReaderInternal(classStream);
            cr.accept(cn, 0);
            ClassNode classNode = cn;
            return classNode;
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
        finally {
            if (classStream != null) {
                try {
                    classStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PartialClassLoader getPartialClassLoader() {
        ClassLoader contextLoader = Base.getContextClassLoader();
        PartialClassLoader loader = s_mapPartialClassLoaders.get(contextLoader);
        if (loader == null) {
            Map<ClassLoader, PartialClassLoader> map = s_mapPartialClassLoaders;
            synchronized (map) {
                loader = s_mapPartialClassLoaders.get(contextLoader);
                if (loader == null) {
                    loader = new PartialClassLoader(contextLoader);
                    s_mapPartialClassLoaders.put(contextLoader, loader);
                }
            }
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ConcurrentHashMap<String, Class> getPartialClassMap(PartialClassLoader loader) {
        ConcurrentHashMap<String, Class<Object>> mapPartialClasses = s_mapPartialClasses.get(loader);
        if (mapPartialClasses == null) {
            PartialClassLoader partialClassLoader = loader;
            synchronized (partialClassLoader) {
                mapPartialClasses = s_mapPartialClasses.get(loader);
                if (mapPartialClasses == null) {
                    mapPartialClasses = new ConcurrentHashMap();
                    s_mapPartialClasses.put(loader, mapPartialClasses);
                }
            }
        }
        return mapPartialClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ConcurrentHashMap<String, Constructor> getPartialConstructorMap(PartialClassLoader loader) {
        ConcurrentHashMap<String, Constructor<Object>> mapPartialConstructors = s_mapPartialConstructors.get(loader);
        if (mapPartialConstructors == null) {
            PartialClassLoader partialClassLoader = loader;
            synchronized (partialClassLoader) {
                mapPartialConstructors = s_mapPartialConstructors.get(loader);
                if (mapPartialConstructors == null) {
                    mapPartialConstructors = new ConcurrentHashMap();
                    s_mapPartialConstructors.put(loader, mapPartialConstructors);
                }
            }
        }
        return mapPartialConstructors;
    }

    protected static final class ClassReaderInternal
    extends BaseClassReaderInternal<ClassReader, ClassVisitor> {
        public ClassReaderInternal(InputStream streamIn) throws IOException {
            super(streamIn);
        }

        public ClassReaderInternal(byte[] abBytes) {
            super(abBytes);
        }

        protected ClassReader createReader(byte[] abBytes) {
            return new ClassReader(abBytes);
        }

        protected void accept(ClassReader classReader, ClassVisitor classVisitor, int nParsingOptions) {
            classReader.accept(classVisitor, nParsingOptions);
        }
    }

    protected static class PartialClassLoader
    extends ClassLoader {
        private static final String PACKAGE_PARTIAL_CLASSES = "com.tangosol.coherence.rest.util.gen.partial";
        private Package m_package = this.definePackage("com.tangosol.coherence.rest.util.gen.partial", "Coherence REST Partial Classes", "1.0", "Oracle", "Coherence REST Partial Classes", "1.0", "Oracle", null);

        public PartialClassLoader(ClassLoader parentLoader) {
            super(parentLoader);
        }

        public Class defineClass(String sName, byte[] ab) {
            return this.defineClass(sName, ab, 0, ab.length);
        }

        @Override
        protected Package getPackage(String name) {
            return PACKAGE_PARTIAL_CLASSES.equals(name) ? this.m_package : super.getPackage(name);
        }

        @Override
        protected Package[] getPackages() {
            Package[] aPackages = super.getPackages();
            int cPackages = aPackages == null ? 0 : aPackages.length;
            Package[] aPackagesNew = new Package[cPackages + 1];
            if (cPackages > 0) {
                System.arraycopy(aPackages, 0, aPackagesNew, 0, cPackages);
            }
            aPackagesNew[cPackages] = this.m_package;
            return aPackagesNew;
        }
    }
}

