/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util;

import com.tangosol.coherence.mvel2.PropertyAccessException;
import com.tangosol.coherence.rest.util.PropertySet;
import com.tangosol.coherence.rest.util.extractor.MvelExtractor;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ValueExtractor;
import java.io.IOException;
import java.io.Serializable;

public class PropertySpec
implements Comparable<PropertySpec>,
Serializable,
PortableObject {
    protected String m_sName;
    protected PropertySet m_propertySet;
    protected transient Class m_clzPartialClass;
    protected transient ValueExtractor m_extractor;

    public PropertySpec() {
    }

    public PropertySpec(String sName) {
        this(sName, null);
    }

    public PropertySpec(String sName, PropertySet propertySet) {
        this.m_sName = sName;
        this.m_propertySet = propertySet;
    }

    public static PropertySpec fromString(String sSpec) {
        return PropertySet.fromString(sSpec).first();
    }

    public Object getValue(Object oTarget) {
        try {
            return this.getExtractor().extract(oTarget);
        }
        catch (PropertyAccessException e) {
            return null;
        }
    }

    @Override
    public int compareTo(PropertySpec o) {
        return this.m_sName.compareTo(o.m_sName);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.m_sName = reader.readString(0);
        this.m_propertySet = (PropertySet)reader.readObject(1);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeString(0, this.m_sName);
        writer.writeObject(1, (Object)this.m_propertySet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Base.equals(this.getClass(), o.getClass())) {
            return false;
        }
        PropertySpec that = (PropertySpec)o;
        return Base.equals((Object)this.m_sName, (Object)that.m_sName) && Base.equals((Object)this.m_propertySet, (Object)that.m_propertySet);
    }

    public int hashCode() {
        PropertySet propertySet = this.m_propertySet;
        int nResult = this.m_sName.hashCode();
        nResult = 31 * nResult + (propertySet == null ? 0 : propertySet.hashCode());
        return nResult;
    }

    public String toString() {
        return this.m_sName + (this.isPartial() ? ":(" + this.m_propertySet + ')' : "");
    }

    public String getName() {
        return this.m_sName;
    }

    public PropertySet getPropertySet() {
        return this.m_propertySet;
    }

    public boolean isPartial() {
        return this.m_propertySet != null;
    }

    public Class getPartialClass() {
        return this.m_clzPartialClass;
    }

    public void setPartialClass(Class clzPartialClass) {
        this.m_clzPartialClass = clzPartialClass;
    }

    protected ValueExtractor getExtractor() {
        ValueExtractor extractor = this.m_extractor;
        if (extractor == null) {
            this.m_extractor = extractor = new MvelExtractor(this.m_sName);
        }
        return extractor;
    }
}

