/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tangosol.coherence.rest.io.AbstractMarshaller;
import com.tangosol.coherence.rest.providers.JacksonMapperProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class JacksonJsonMarshaller<T>
extends AbstractMarshaller<T> {
    private final ObjectMapper m_objectMapper = JacksonMapperProvider.getObjectMapper();

    public JacksonJsonMarshaller(Class<T> clzRoot) {
        super(clzRoot);
    }

    @Override
    public void marshal(T value, OutputStream out, MultivaluedMap<String, Object> httpHeaders) throws IOException {
        this.m_objectMapper.writeValue(out, value);
    }

    @Override
    public T unmarshal(InputStream in, MediaType mediaType) throws IOException {
        return (T)this.m_objectMapper.readValue(in, this.getRootClass());
    }
}

