/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel2.conversion;

import com.tangosol.coherence.mvel2.ConversionException;
import com.tangosol.coherence.mvel2.ConversionHandler;
import com.tangosol.coherence.mvel2.conversion.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class DoubleCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private static Converter stringConverter = new Converter(){

        @Override
        public Object convert(Object o) {
            if (((String)o).length() == 0) {
                return 0.0;
            }
            return Double.parseDouble((String)o);
        }
    };

    @Override
    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    @Override
    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            @Override
            public Object convert(Object o) {
                return stringConverter.convert(String.valueOf(o));
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            @Override
            public Double convert(Object o) {
                return ((BigDecimal)o).doubleValue();
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            @Override
            public Double convert(Object o) {
                return ((BigInteger)o).doubleValue();
            }
        });
        CNV.put(Double.class, new Converter(){

            @Override
            public Object convert(Object o) {
                return o;
            }
        });
        CNV.put(Float.class, new Converter(){

            @Override
            public Double convert(Object o) {
                if ((double)((Float)o).floatValue() > Double.MAX_VALUE) {
                    throw new ConversionException("cannot coerce Float to Double since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Double.");
                }
                return ((Float)o).doubleValue();
            }
        });
        CNV.put(Integer.class, new Converter(){

            @Override
            public Double convert(Object o) {
                return ((Integer)o).doubleValue();
            }
        });
        CNV.put(Short.class, new Converter(){

            @Override
            public Double convert(Object o) {
                return ((Short)o).doubleValue();
            }
        });
        CNV.put(Long.class, new Converter(){

            @Override
            public Double convert(Object o) {
                return ((Long)o).doubleValue();
            }
        });
        CNV.put(Boolean.class, new Converter(){

            @Override
            public Double convert(Object o) {
                if (((Boolean)o).booleanValue()) {
                    return 1.0;
                }
                return 0.0;
            }
        });
    }
}

