/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel2.optimizers.impl.refl.nodes;

import com.tangosol.coherence.mvel2.DataConversion;
import com.tangosol.coherence.mvel2.compiler.AccessorNode;
import com.tangosol.coherence.mvel2.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel2.util.PropertyTools;
import java.lang.reflect.Field;

public class FieldAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private Field field;
    private boolean coercionRequired = false;
    private boolean primitive;

    public FieldAccessor() {
    }

    public FieldAccessor(Field field) {
        this.field = field;
        this.primitive = this.field.getType().isPrimitive();
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.field.get(ctx), elCtx, vars);
            }
            return this.field.get(ctx);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to access field: " + this.field.getName(), e);
        }
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        if (this.nextNode != null) {
            try {
                return this.nextNode.setValue(this.field.get(ctx), elCtx, variableFactory, value == null && this.primitive ? PropertyTools.getPrimitiveInitialValue(this.field.getType()) : value);
            }
            catch (Exception e) {
                throw new RuntimeException("unable to access field", e);
            }
        }
        boolean attemptedCoercion = this.coercionRequired;
        try {
            if (this.coercionRequired) {
                value = DataConversion.convert(ctx, this.field.getClass());
                this.field.set(ctx, value);
                return value;
            }
            this.field.set(ctx, value);
            return value;
        }
        catch (IllegalArgumentException e) {
            if (!attemptedCoercion) {
                this.coercionRequired = true;
                return this.setValue(ctx, elCtx, variableFactory, value);
            }
            throw new RuntimeException("unable to bind property", e);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to access field", e);
        }
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    @Override
    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    @Override
    public Class getKnownEgressType() {
        return this.field.getClass();
    }
}

