/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel2.integration.impl;

import com.tangosol.coherence.mvel2.UnresolveablePropertyException;
import com.tangosol.coherence.mvel2.integration.VariableResolver;
import com.tangosol.coherence.mvel2.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel2.integration.impl.BaseVariableResolverFactory;
import com.tangosol.coherence.mvel2.integration.impl.IndexVariableResolver;
import com.tangosol.coherence.mvel2.integration.impl.MapVariableResolverFactory;
import com.tangosol.coherence.mvel2.integration.impl.SimpleValueResolver;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class IndexedVariableResolverFactory
extends BaseVariableResolverFactory {
    public IndexedVariableResolverFactory(String[] varNames, VariableResolver[] resolvers) {
        this.indexedVariableNames = varNames;
        this.indexedVariableResolvers = resolvers;
    }

    public IndexedVariableResolverFactory(String[] varNames, Object[] values) {
        this.indexedVariableNames = varNames;
        this.indexedVariableResolvers = IndexedVariableResolverFactory.createResolvers(values, varNames.length);
    }

    public IndexedVariableResolverFactory(String[] varNames, Object[] values, VariableResolverFactory nextFactory) {
        this.indexedVariableNames = varNames;
        this.nextFactory = new MapVariableResolverFactory();
        this.nextFactory.setNextFactory(nextFactory);
        this.indexedVariableResolvers = IndexedVariableResolverFactory.createResolvers(values, varNames.length);
    }

    private static VariableResolver[] createResolvers(Object[] values, int size) {
        VariableResolver[] vr = new VariableResolver[size];
        for (int i = 0; i < size; ++i) {
            vr[i] = i >= values.length ? new SimpleValueResolver(null) : new IndexVariableResolver(i, values);
        }
        return vr;
    }

    @Override
    public VariableResolver createIndexedVariable(int index, String name, Object value) {
        VariableResolver r = this.indexedVariableResolvers[index];
        r.setValue(value);
        return r;
    }

    @Override
    public VariableResolver getIndexedVariableResolver(int index) {
        return this.indexedVariableResolvers[index];
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        VariableResolver vr = this.getResolver(name);
        if (vr != null) {
            vr.setValue(value);
        }
        return vr;
    }

    @Override
    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        VariableResolver vr = this.getResolver(name);
        if (vr != null) {
            vr.setValue(value);
        }
        return vr;
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        VariableResolver vr = this.getResolver(name);
        if (vr != null) {
            return vr;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.getVariableResolver(name);
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + name + "'");
    }

    @Override
    public boolean isResolveable(String name) {
        return this.isTarget(name) || this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    protected VariableResolver addResolver(String name, VariableResolver vr) {
        this.variableResolvers.put(name, vr);
        return vr;
    }

    private VariableResolver getResolver(String name) {
        for (int i = 0; i < this.indexedVariableNames.length; ++i) {
            if (!this.indexedVariableNames[i].equals(name)) continue;
            return this.indexedVariableResolvers[i];
        }
        return null;
    }

    @Override
    public boolean isTarget(String name) {
        for (String indexedVariableName : this.indexedVariableNames) {
            if (!indexedVariableName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getKnownVariables() {
        return new HashSet<String>(Arrays.asList(this.indexedVariableNames));
    }

    public void clear() {
    }

    @Override
    public boolean isIndexedFactory() {
        return true;
    }
}

