/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel2.compiler;

import com.tangosol.coherence.mvel2.ParserContext;
import com.tangosol.coherence.mvel2.compiler.Accessor;
import com.tangosol.coherence.mvel2.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel2.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel2.optimizers.OptimizerFactory;
import java.io.Serializable;

public class CompiledAccExpression
implements ExecutableStatement,
Serializable {
    private char[] expression;
    private int start;
    private int offset;
    private transient Accessor accessor;
    private ParserContext context;
    private Class ingressType;

    public CompiledAccExpression(char[] expression, Class ingressType, ParserContext context) {
        this(expression, 0, expression.length, ingressType, context);
    }

    public CompiledAccExpression(char[] expression, int start, int offset, Class ingressType, ParserContext context) {
        this.expression = expression;
        this.start = start;
        this.offset = offset;
        this.context = context;
        this.ingressType = ingressType != null ? ingressType : Object.class;
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory vrf, Object value) {
        if (this.accessor == null) {
            if (this.ingressType == Object.class && value != null) {
                this.ingressType = value.getClass();
            }
            this.accessor = OptimizerFactory.getThreadAccessorOptimizer().optimizeSetAccessor(this.context, this.expression, 0, this.expression.length, ctx, ctx, vrf, false, value, this.ingressType);
        } else {
            this.accessor.setValue(ctx, elCtx, vrf, value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Object staticContext, VariableResolverFactory factory) {
        if (this.accessor == null) {
            try {
                this.accessor = OptimizerFactory.getThreadAccessorOptimizer().optimizeAccessor(this.context, this.expression, 0, this.expression.length, staticContext, staticContext, factory, false, this.ingressType);
                Object object = this.getValue(staticContext, factory);
                return object;
            }
            finally {
                OptimizerFactory.clearThreadAccessorOptimizer();
            }
        }
        return this.accessor.getValue(staticContext, staticContext, factory);
    }

    @Override
    public void setKnownIngressType(Class type) {
        this.ingressType = type;
    }

    @Override
    public void setKnownEgressType(Class type) {
    }

    @Override
    public Class getKnownIngressType() {
        return this.ingressType;
    }

    @Override
    public Class getKnownEgressType() {
        return null;
    }

    @Override
    public boolean isConvertableIngressEgress() {
        return false;
    }

    @Override
    public void computeTypeConversionRule() {
    }

    @Override
    public boolean intOptimized() {
        return false;
    }

    @Override
    public boolean isLiteralOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (this.accessor == null) {
            try {
                this.accessor = OptimizerFactory.getThreadAccessorOptimizer().optimizeAccessor(this.context, this.expression, this.start, this.offset, ctx, elCtx, variableFactory, false, this.ingressType);
                Object object = this.getValue(ctx, elCtx, variableFactory);
                return object;
            }
            finally {
                OptimizerFactory.clearThreadAccessorOptimizer();
            }
        }
        return this.accessor.getValue(ctx, elCtx, variableFactory);
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public boolean isEmptyStatement() {
        return this.accessor == null;
    }

    @Override
    public boolean isExplicitCast() {
        return false;
    }
}

