/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest;

import com.tangosol.coherence.rest.KeyConverter;
import com.tangosol.util.Base;
import com.tangosol.util.UID;
import com.tangosol.util.UUID;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DefaultKeyConverter
implements KeyConverter {
    protected final Class m_clzKey;
    protected final Constructor m_ctorFromString;
    protected final Method m_methFromString;
    protected static final String[] METHODS = new String[]{"fromString", "valueOf", "parse"};
    protected static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public DefaultKeyConverter(Class clzKey) {
        Constructor ctor;
        this.m_clzKey = clzKey;
        this.m_ctorFromString = ctor = this.findConstructor();
        Method meth = null;
        if (ctor == null) {
            String sMethodName;
            String[] stringArray = METHODS;
            int n = stringArray.length;
            for (int i = 0; i < n && (meth = this.findMethod(sMethodName = stringArray[i])) == null; ++i) {
            }
            if (meth == null) {
                throw new IllegalArgumentException("DefaultKeyConverter cannot be created for key class " + clzKey.getName() + " because it doesn't have a constructor or a static fromString(), valueOf() or parse method that accepts a single String argument");
            }
        }
        this.m_methFromString = meth;
    }

    @Override
    public Object fromString(String sKey) {
        try {
            if (Date.class.equals((Object)this.m_clzKey)) {
                return DATE_FORMAT.parse(sKey);
            }
            if (this.m_ctorFromString == null) {
                return this.m_methFromString.invoke(null, sKey);
            }
            return this.m_ctorFromString.newInstance(sKey);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    @Override
    public String toString(Object oKey) {
        if (Date.class.equals((Object)this.m_clzKey)) {
            return DATE_FORMAT.format(oKey);
        }
        if (UUID.class.equals((Object)this.m_clzKey) || UID.class.equals((Object)this.m_clzKey)) {
            return oKey.toString().substring(2);
        }
        return oKey.toString();
    }

    protected Constructor findConstructor() {
        try {
            return this.m_clzKey.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected Method findMethod(String sMethodName) {
        try {
            return this.m_clzKey.getMethod(sMethodName, String.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

