/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util;

import com.tangosol.coherence.rest.util.PartialObject;
import com.tangosol.coherence.rest.util.PropertySpec;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ValueExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class PropertySet<T>
implements Iterable<PropertySpec>,
ValueExtractor<T, Object>,
ExternalizableLite,
PortableObject {
    protected final SortedSet<PropertySpec> m_setProperties;

    public PropertySet() {
        this.m_setProperties = new TreeSet<PropertySpec>();
    }

    public PropertySet(PropertySpec ... aProperties) {
        this.m_setProperties = new TreeSet<PropertySpec>(Arrays.asList(aProperties));
    }

    public PropertySet(Set<PropertySpec> setProperties) {
        this.m_setProperties = new TreeSet<PropertySpec>(setProperties);
    }

    public static PropertySet fromString(String sPropertySet) {
        if (sPropertySet == null) {
            throw new IllegalArgumentException("null property set descriptor");
        }
        sPropertySet = sPropertySet.trim();
        StringBuilder sbName = new StringBuilder();
        PropertySet psOuter = new PropertySet();
        PropertySet psInner = null;
        int ich = 0;
        int cch = sPropertySet.length();
        while (ich < cch) {
            char c;
            if ((c = sPropertySet.charAt(ich++)) == ',') {
                psOuter.add(new PropertySpec(sbName.toString(), psInner));
                sbName = new StringBuilder();
                psInner = null;
                continue;
            }
            if (c == ':') {
                ++ich;
                StringBuilder sbInner = new StringBuilder();
                int cParen = 1;
                while (cParen > 0 && ich < cch) {
                    char cc;
                    if ((cc = sPropertySet.charAt(ich++)) == ')') {
                        --cParen;
                    } else if (cc == '(') {
                        ++cParen;
                    }
                    if (cParen <= 0) continue;
                    sbInner.append(cc);
                }
                psInner = PropertySet.fromString(sbInner.toString());
                continue;
            }
            if (c == ' ') continue;
            sbName.append(c);
        }
        if (sbName.length() > 0) {
            psOuter.add(new PropertySpec(sbName.toString(), psInner));
        }
        return psOuter;
    }

    public void add(PropertySpec property) {
        this.m_setProperties.add(property);
    }

    public Collection<Object> extract(Collection<? extends T> colSource) {
        if (colSource == null) {
            throw new IllegalArgumentException("null source collection");
        }
        ArrayList<Object> colValues = new ArrayList<Object>(colSource.size());
        for (T o : colSource) {
            colValues.add(this.extract(o));
        }
        return colValues;
    }

    public Object[] extract(Object[] aSource) {
        if (aSource == null) {
            throw new IllegalArgumentException("null source array");
        }
        int cSource = aSource.length;
        if (cSource == 0) {
            return new PartialObject[0];
        }
        Class clzElementType = PartialObject.getPartialClass(aSource[0].getClass(), this);
        Object[] aValues = (PartialObject[])Array.newInstance(clzElementType, cSource);
        for (int i = 0; i < cSource; ++i) {
            aValues[i] = this.extract(aSource[i]);
        }
        return aValues;
    }

    public Object extract(T source) {
        if (source == null) {
            throw new IllegalArgumentException("null source object");
        }
        SortedSet<PropertySpec> setProperties = this.m_setProperties;
        LinkedHashMap<String, Object> mapProps = new LinkedHashMap<String, Object>(setProperties.size());
        for (PropertySpec property : setProperties) {
            String sName = property.getName();
            Object oValue = property.getValue(source);
            if (oValue != null && property.getPropertySet() != null) {
                if (oValue.getClass().isArray()) {
                    oValue = property.getPropertySet().extract((Object[])oValue);
                } else if (oValue instanceof Collection) {
                    Object[] aValues = new ArrayList((Collection)oValue).toArray();
                    oValue = property.getPropertySet().extract(aValues);
                } else {
                    oValue = property.getPropertySet().extract(oValue);
                }
                property.setPartialClass(oValue.getClass());
            }
            mapProps.put(sName, oValue);
        }
        return source instanceof Map ? mapProps : PartialObject.create(source.getClass(), this, mapProps);
    }

    @Override
    public Iterator<PropertySpec> iterator() {
        return this.m_setProperties.iterator();
    }

    public void readExternal(DataInput in) throws IOException {
        ExternalizableHelper.readCollection((DataInput)in, this.m_setProperties, null);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeCollection((DataOutput)out, this.m_setProperties);
    }

    public void readExternal(PofReader reader) throws IOException {
        reader.readCollection(0, this.m_setProperties);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeCollection(0, this.m_setProperties, PropertySpec.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertySet that = (PropertySet)o;
        return this.m_setProperties.equals(that.m_setProperties);
    }

    public int hashCode() {
        return this.m_setProperties.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean fFirst = true;
        for (PropertySpec p : this) {
            if (!fFirst) {
                sb.append(',');
            }
            sb.append(p);
            fFirst = false;
        }
        return sb.toString();
    }

    protected PropertySpec first() {
        SortedSet<PropertySpec> setProperties = this.m_setProperties;
        if (setProperties.size() > 0) {
            return setProperties.first();
        }
        return null;
    }

    protected SortedSet<PropertySpec> getProperties() {
        return this.m_setProperties;
    }
}

