/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util;

import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.WeakHashMap;

public class MvelHelper {
    public static final boolean s_fEnabled;
    public static final Class<?> s_clzMVEL;
    public static final Class<?> s_clzParserContext;
    public static final MethodHandle HANDLE_PARSER_CONTEXT_ADD_PACKAGE_IMPORT;
    public static final MethodHandle HANDLE_PARSER_CONTEXT_GET_PARSER_CONFIGURATION;
    public static final MethodHandle HANDLE_PARSER_CONFIGURATION_SET_CLASS_LOADER;
    public static final MethodHandle HANDLE_COMPILE_EXPRESSION;
    public static final MethodHandle HANDLE_EXECUTE_EXPRESSION;
    public static final MethodHandle HANDLE_COMPILE_SET_EXPRESSION;
    public static final MethodHandle HANDLE_EXECUTE_SET_EXPRESSION;
    private static final WeakHashMap<ClassLoader, Object> s_mapParserContextByLoader;

    public static boolean isEnabled() {
        return s_fEnabled;
    }

    public static Object getMvelParserContext() {
        MvelHelper.ensureMvel2();
        ClassLoader contextLoader = Base.getContextClassLoader();
        return s_mapParserContextByLoader.computeIfAbsent(contextLoader, MvelHelper::makeParserContext);
    }

    private static Object makeParserContext(ClassLoader contextLoader) {
        Object ctx = null;
        try {
            ctx = s_clzParserContext.getConstructor(new Class[0]).newInstance(new Object[0]);
            HANDLE_PARSER_CONTEXT_ADD_PACKAGE_IMPORT.invoke(ctx, "java.util");
            Object config = HANDLE_PARSER_CONTEXT_GET_PARSER_CONFIGURATION.invoke(ctx);
            HANDLE_PARSER_CONFIGURATION_SET_CLASS_LOADER.invoke(config, contextLoader);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            CacheFactory.err((String)("MvelHelper.makeParserContext: handled unexpected exception " + e.getClass().getName() + " : " + e.getLocalizedMessage()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ctx;
    }

    public static Serializable compileExpression(String sExpr, Object ctx) {
        MvelHelper.ensureMvel2();
        try {
            return HANDLE_COMPILE_EXPRESSION.invoke(sExpr, ctx);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object executeExpression(Object compiledExpr, Object oTarget) {
        MvelHelper.ensureMvel2();
        try {
            return HANDLE_EXECUTE_EXPRESSION.invoke(compiledExpr, oTarget);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Serializable compileSetExpression(String sExpr, Object ctx) {
        MvelHelper.ensureMvel2();
        try {
            return HANDLE_COMPILE_SET_EXPRESSION.invoke(sExpr, ctx);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void executeSetExpression(Serializable compiledSet, Object oTarget, Object oValue) {
        MvelHelper.ensureMvel2();
        try {
            HANDLE_EXECUTE_SET_EXPRESSION.invoke(compiledSet, oTarget, oValue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void ensureMvel2() {
        if (!s_fEnabled) {
            throw new UnsupportedOperationException("Invalid usage of optional module \"org.mvel.mvel2\" without its implementation being provided on path");
        }
    }

    static {
        boolean fMvelEnabled = false;
        Class<?> clzMVEL = null;
        Class<?> clzParserContext = null;
        Class<?> clzParserConfiguration = null;
        MethodHandle handleParserCtxAddPackageImport = null;
        MethodHandle handleParserCtxGetParserConfig = null;
        MethodHandle handleParserConfigSetClassLoader = null;
        MethodHandle handleCompileExpression = null;
        MethodHandle handleExecuteExpression = null;
        MethodHandle handleCompileSetExpression = null;
        MethodHandle handleExecuteSetExpression = null;
        try {
            clzMVEL = Class.forName("org.mvel2.MVEL");
            clzParserContext = Class.forName("org.mvel2.ParserContext");
            clzParserConfiguration = Class.forName("org.mvel2.ParserConfiguration");
            Method methodCompileExpr = clzMVEL.getDeclaredMethod("compileExpression", String.class, clzParserContext);
            Method methodExecuteExpr = clzMVEL.getDeclaredMethod("executeExpression", Object.class, Object.class);
            Method methodCompileSetExpr = clzMVEL.getDeclaredMethod("compileSetExpression", String.class, clzParserContext);
            Method methodExecuteSetExpr = clzMVEL.getDeclaredMethod("executeSetExpression", Serializable.class, Object.class, Object.class);
            Method methodParserCtxAddPackageImport = clzParserContext.getDeclaredMethod("addPackageImport", String.class);
            Method methodParserCtxGetParserConfig = clzParserContext.getDeclaredMethod("getParserConfiguration", new Class[0]);
            Method methodParserConfigSetClassLoader = clzParserConfiguration.getDeclaredMethod("setClassLoader", ClassLoader.class);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            handleCompileExpression = lookup.unreflect(methodCompileExpr);
            handleExecuteExpression = lookup.unreflect(methodExecuteExpr);
            handleCompileSetExpression = lookup.unreflect(methodCompileSetExpr);
            handleExecuteSetExpression = lookup.unreflect(methodExecuteSetExpr);
            handleParserCtxAddPackageImport = lookup.unreflect(methodParserCtxAddPackageImport);
            handleParserCtxGetParserConfig = lookup.unreflect(methodParserCtxGetParserConfig);
            handleParserConfigSetClassLoader = lookup.unreflect(methodParserConfigSetClassLoader);
            Field fieldCOMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = clzMVEL.getDeclaredField("COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING");
            fieldCOMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING.set(clzMVEL, true);
            fMvelEnabled = true;
        }
        catch (ClassNotFoundException e) {
            assert (e.getMessage().contains("org.mvel2."));
            fMvelEnabled = false;
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            CacheFactory.log((String)("Deprecated org.mvel2.mvel implementation jar found on classpath but MVEL is disabled due to unexpected exception " + e.getClass().getName() + " : " + e.getLocalizedMessage()), (int)2);
            fMvelEnabled = false;
        }
        s_fEnabled = fMvelEnabled;
        if (fMvelEnabled) {
            CacheFactory.log((String)"Deprecated org.mvel2.mvel jar found on classpath. Backwards compatible REST query using MVEL evaluation is enabled.", (int)2);
        }
        s_clzMVEL = clzMVEL;
        s_clzParserContext = clzParserContext;
        HANDLE_COMPILE_EXPRESSION = handleCompileExpression;
        HANDLE_EXECUTE_EXPRESSION = handleExecuteExpression;
        HANDLE_COMPILE_SET_EXPRESSION = handleCompileSetExpression;
        HANDLE_EXECUTE_SET_EXPRESSION = handleExecuteSetExpression;
        HANDLE_PARSER_CONTEXT_ADD_PACKAGE_IMPORT = handleParserCtxAddPackageImport;
        HANDLE_PARSER_CONTEXT_GET_PARSER_CONFIGURATION = handleParserCtxGetParserConfig;
        HANDLE_PARSER_CONFIGURATION_SET_CLASS_LOADER = handleParserConfigSetClassLoader;
        s_mapParserContextByLoader = fMvelEnabled ? new WeakHashMap() : null;
    }
}

