/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util.extractor;

import com.tangosol.coherence.rest.util.MvelHelper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class MvelExtractor
extends AbstractExtractor
implements ValueExtractor,
ExternalizableLite,
PortableObject {
    protected String m_sExpr;
    protected transient Serializable m_oExpr;

    public MvelExtractor() {
    }

    public MvelExtractor(String sExpr) {
        this(sExpr, 0);
    }

    public MvelExtractor(String sExpr, int nTarget) {
        if (sExpr == null) {
            throw new IllegalArgumentException("null MVEL expression");
        }
        if (nTarget != 0 && nTarget != 1) {
            throw new IllegalArgumentException("invalid target: " + nTarget);
        }
        this.m_sExpr = sExpr;
        this.m_nTarget = nTarget;
    }

    public Object extract(Object oTarget) {
        if (oTarget == null) {
            return null;
        }
        return MvelHelper.executeExpression(this.getCompiledExpression(), oTarget);
    }

    protected Serializable getCompiledExpression() {
        Serializable oExpr = this.m_oExpr;
        if (oExpr == null) {
            Object ctx = MvelHelper.getMvelParserContext();
            this.m_oExpr = oExpr = MvelHelper.compileExpression(this.m_sExpr, ctx);
        }
        return oExpr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MvelExtractor) {
            MvelExtractor that = (MvelExtractor)((Object)o);
            return Base.equals((Object)this.m_sExpr, (Object)that.m_sExpr);
        }
        return false;
    }

    public int hashCode() {
        String sExpr = this.m_sExpr;
        return sExpr == null ? 0 : sExpr.hashCode();
    }

    public String toString() {
        return String.valueOf(this.m_sExpr);
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_nTarget = in.readInt();
        this.m_sExpr = ExternalizableHelper.readSafeUTF((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_nTarget);
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.m_sExpr);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_nTarget = in.readInt(0);
        this.m_sExpr = in.readString(1);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nTarget);
        out.writeString(1, this.m_sExpr);
    }
}

