/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.mp.metrics;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.net.metrics.MBeanMetric;
import com.tangosol.net.metrics.MetricsRegistryAdapter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryScope;

@ApplicationScoped
public class MpMetricsRegistryAdapter
implements MetricsRegistryAdapter {
    private final MetricRegistry f_vendorRegistry;
    private final MetricRegistry f_appRegistry;

    @Inject
    public MpMetricsRegistryAdapter(@RegistryScope(scope="vendor") MetricRegistry vendorRegistry, @RegistryScope(scope="application") MetricRegistry appRegistry) {
        this.f_vendorRegistry = Objects.requireNonNull(vendorRegistry);
        this.f_appRegistry = Objects.requireNonNull(appRegistry);
    }

    public synchronized void register(MBeanMetric metric) {
        String sName = metric.getName();
        String sDescription = this.getDescription(metric);
        Tag[] aTags = this.getTags(metric.getIdentifier());
        MetricID id = new MetricID(sName, aTags);
        Metadata metadata = Metadata.builder().withName(sName).build();
        MBeanMetricGauge gauge = new MBeanMetricGauge(metric);
        switch (metric.getScope()) {
            case VENDOR: {
                if (this.f_vendorRegistry.getGauges().containsKey(id)) break;
                this.f_vendorRegistry.gauge(metadata, (Supplier)gauge, aTags);
                break;
            }
            case APPLICATION: {
                if (this.f_appRegistry.getGauges().containsKey(id)) break;
                this.f_appRegistry.gauge(metadata, (Supplier)gauge, aTags);
                break;
            }
        }
    }

    public void remove(MBeanMetric.Identifier identifier) {
        Tag[] aTags = this.getTags(identifier);
        MetricID id = new MetricID(identifier.getName(), aTags);
        switch (identifier.getScope()) {
            case VENDOR: {
                if (!this.f_vendorRegistry.getGauges().containsKey(id)) break;
                this.f_vendorRegistry.remove(id);
                break;
            }
            case APPLICATION: {
                if (!this.f_appRegistry.getGauges().containsKey(id)) break;
                this.f_appRegistry.remove(id);
                break;
            }
        }
    }

    Tag[] getTags(MBeanMetric.Identifier identifier) {
        String sName = identifier.getName();
        return (Tag[])identifier.getTags().entrySet().stream().map(e -> this.toTag(sName, (Map.Entry<String, String>)e)).filter(Objects::nonNull).toArray(Tag[]::new);
    }

    Tag toTag(String sName, Map.Entry<String, String> entry) {
        String sKey = entry.getKey();
        String sValue = String.valueOf(entry.getValue());
        try {
            return new Tag(sKey, sValue);
        }
        catch (Throwable e) {
            Logger.err((String)String.format("Metric '%s' tag '%s' = '%s' is invalid and will be ignored due to: %s", sName, sKey, sValue, e.getMessage()));
            return null;
        }
    }

    String getDescription(MBeanMetric metric) {
        int nPos;
        String sDescription = metric.getDescription();
        if (sDescription != null && (nPos = sDescription.indexOf(" (MBean '")) > 0) {
            sDescription = sDescription.substring(0, nPos);
        }
        return sDescription;
    }

    private static class MBeanMetricGauge
    implements Supplier<Number> {
        private final MBeanMetric metric;

        private MBeanMetricGauge(MBeanMetric metric) {
            this.metric = metric;
        }

        @Override
        public Number get() {
            Number value = (Number)this.metric.getValue();
            return value == null ? (Number)0 : (Number)value;
        }
    }
}

