/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.mp.metrics;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class CoherenceTagsConfigSource
implements ConfigSource {
    private static final Set<String> PROPERTY_NAMES = Collections.singleton("mp.metrics.tags");
    private volatile boolean m_fInit = false;
    private String m_sTags;

    public Map<String, String> getProperties() {
        return this.m_fInit ? Collections.singletonMap("mp.metrics.tags", this.getValue("mp.metrics.tags")) : Collections.emptyMap();
    }

    public Set<String> getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public int getOrdinal() {
        return Integer.MAX_VALUE;
    }

    public String getValue(String propertyName) {
        if (!"mp.metrics.tags".equals(propertyName)) {
            return null;
        }
        this.ensureInitialized();
        return this.m_sTags;
    }

    public String getName() {
        return "coherenceTags";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        if (!this.m_fInit) {
            CoherenceTagsConfigSource coherenceTagsConfigSource = this;
            synchronized (coherenceTagsConfigSource) {
                if (!this.m_fInit) {
                    StringBuilder sb = new StringBuilder();
                    ConfigProviderResolver resolver = ConfigProviderResolver.instance();
                    ConfigBuilder builder = resolver.getBuilder();
                    Config config = builder.addDefaultSources().build();
                    Optional globalTags = config.getOptionalValue("mp.metrics.tags", String.class);
                    globalTags.ifPresent(gt -> sb.append((String)gt).append(','));
                    Cluster cluster = CacheFactory.ensureCluster();
                    Member member = cluster.getLocalMember();
                    this.appendTag(sb, "cluster", member.getClusterName());
                    this.appendTag(sb, "machine", member.getMachineName());
                    this.appendTag(sb, "member", member.getMemberName());
                    this.appendTag(sb, "role", member.getRoleName());
                    this.appendTag(sb, "site", member.getSiteName());
                    this.appendTag(sb, "node_id", String.valueOf(member.getId()));
                    this.m_sTags = sb.substring(0, sb.length() - 1);
                    this.m_fInit = true;
                }
            }
        }
    }

    private void appendTag(StringBuilder sb, String tagName, String tagValue) {
        if (tagValue != null) {
            sb.append(tagName).append('=').append(this.escape(tagValue)).append(',');
        }
    }

    private String escape(String tagValue) {
        tagValue = tagValue.replace(",", "\\,");
        tagValue = tagValue.replace("=", "\\=");
        return tagValue;
    }
}

