/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.mp.metrics;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.net.metrics.MBeanMetric;
import com.tangosol.net.metrics.MetricsRegistryAdapter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;

public class CdiMetricsRegistryAdapter
implements MetricsRegistryAdapter {
    private volatile Instance<MetricsRegistryAdapter> m_adapters;
    private final List<Consumer<MetricsRegistryAdapter>> f_deferredActions = Collections.synchronizedList(new ArrayList());

    public void register(MBeanMetric metric) {
        this.delegate(adapter -> adapter.register(metric));
    }

    public void remove(MBeanMetric.Identifier identifier) {
        this.delegate(adapter -> adapter.remove(identifier));
    }

    private void delegate(Consumer<MetricsRegistryAdapter> action) {
        try {
            Instance adapters = this.m_adapters;
            if (adapters == null) {
                this.m_adapters = CDI.current().select(MetricsRegistryAdapter.class, new Annotation[0]);
                adapters = this.m_adapters;
                if (adapters.isUnsatisfied()) {
                    Logger.config((String)"No CDI-managed metrics registry adapters were discovered");
                } else {
                    String sAdapterNames = adapters.stream().map(a -> a.getClass().getSimpleName()).collect(Collectors.joining(", "));
                    Logger.config((String)("Registering CDI-managed metrics registry adapters: " + sAdapterNames));
                }
            }
            if (!this.f_deferredActions.isEmpty()) {
                for (Consumer<MetricsRegistryAdapter> deferredAction : this.f_deferredActions) {
                    adapters.forEach(deferredAction);
                }
                this.f_deferredActions.clear();
            }
            adapters.forEach(action);
        }
        catch (IllegalStateException cdiNotAvailable) {
            this.f_deferredActions.add(action);
        }
    }
}

