/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.mp.config;

import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class CdiConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger LOG = Logger.getLogger(CdiConfigSourceProvider.class.getName());

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        try {
            Instance sources = CDI.current().select(ConfigSource.class, new Annotation[0]);
            if (sources.isUnsatisfied()) {
                LOG.config("No CDI-managed configuration sources were discovered");
            } else {
                String sSourceNames = sources.stream().map(ConfigSource::getName).collect(Collectors.joining(", "));
                LOG.config("Registering CDI-managed configuration sources: " + sSourceNames);
            }
            return sources;
        }
        catch (IllegalStateException cdiNotAvailable) {
            LOG.info("CDI is not available. No CDI-managed configuration sources will be used.");
            return Collections.emptySet();
        }
    }
}

