/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.micrometer;

import com.oracle.coherence.common.collections.WeakIdentityHashMap;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.metrics.MBeanMetric;
import com.tangosol.net.metrics.MetricsRegistryAdapter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class CoherenceMicrometerMetrics
implements MeterBinder {
    public static final String PROP_USE_GLOBAL_REGISTRY = "coherence.micrometer.bind.to.global";
    public static final CoherenceMicrometerMetrics INSTANCE = new CoherenceMicrometerMetrics();
    private final Map<MBeanMetric.Identifier, Holder> f_mapMetric = new ConcurrentHashMap<MBeanMetric.Identifier, Holder>();
    private final Map<MeterRegistry, Integer> f_mapRegistry = new WeakIdentityHashMap();

    private CoherenceMicrometerMetrics() {
        if (Config.getBoolean((String)PROP_USE_GLOBAL_REGISTRY, (boolean)false)) {
            this.bindTo((MeterRegistry)Metrics.globalRegistry);
        }
    }

    public void bindTo(@NonNull MeterRegistry registry) {
        this.f_mapRegistry.put(registry, 0);
        Set<MeterRegistry> set = Collections.singleton(registry);
        this.f_mapMetric.values().forEach(m -> this.register(set, (Holder)m));
    }

    public void register(MBeanMetric metric) {
        Holder holder = this.f_mapMetric.compute(metric.getIdentifier(), (k, v) -> v == null ? this.createHolder(metric) : v.setMetric(metric));
        this.register(this.f_mapRegistry.keySet(), holder);
    }

    Holder createHolder(MBeanMetric metric) {
        MBeanMetric.Identifier identifier = metric.getIdentifier();
        String sName = identifier.getFormattedName();
        Tags tags = this.getTags(identifier);
        return new Holder(metric, sName, tags);
    }

    void register(Set<MeterRegistry> setRegistry, Holder holder) {
        MBeanMetric.Identifier identifier = holder.getIdentifier();
        String sName = holder.getName();
        Tags tags = holder.getTags();
        for (MeterRegistry registry : setRegistry) {
            if (registry.find(sName).tags((Iterable)tags).gauges().size() != 0) continue;
            Gauge.builder((String)sName, (Object)identifier, this::metricToDouble).tags((Iterable)tags).description(holder.getDescription()).register(registry);
        }
    }

    void remove(MBeanMetric.Identifier identifier) {
        Holder holder = this.f_mapMetric.remove(identifier);
        if (holder != null) {
            String sName = holder.getName();
            Tags tags = holder.getTags();
            for (MeterRegistry registry : this.f_mapRegistry.keySet()) {
                registry.find(sName).tags((Iterable)tags).gauges().forEach(g -> registry.remove(g.getId()));
            }
        }
    }

    double metricToDouble(MBeanMetric.Identifier identifier) {
        if (identifier != null) {
            Holder holder = this.f_mapMetric.get(identifier);
            return holder == null ? 0.0 : holder.getValue();
        }
        return 0.0;
    }

    Tags getTags(MBeanMetric.Identifier identifier) {
        String sName = identifier.getName();
        List tags = identifier.getFormattedTags().entrySet().stream().map(e -> this.toTag(sName, (Map.Entry<String, String>)e)).filter(Objects::nonNull).collect(Collectors.toList());
        return Tags.of(tags);
    }

    Tag toTag(String sName, Map.Entry<String, String> entry) {
        String sKey = entry.getKey();
        String sValue = String.valueOf(entry.getValue());
        try {
            return Tag.of((String)sKey, (String)sValue);
        }
        catch (Throwable e) {
            CacheFactory.err((String)String.format("Metric '%s' tag '%s' = '%s' is invalid and will be ignored due to: %s", sName, sKey, sValue, e.getMessage()));
            return null;
        }
    }

    public Map<MBeanMetric.Identifier, Holder> getMetrics() {
        return this.f_mapMetric;
    }

    public static class Holder {
        private MBeanMetric f_metric;
        private final String f_sName;
        private final Tags f_tags;

        public Holder(MBeanMetric metric, String sName, Tags tags) {
            this.f_metric = metric;
            this.f_sName = sName;
            this.f_tags = tags;
        }

        public MBeanMetric.Identifier getIdentifier() {
            return this.f_metric.getIdentifier();
        }

        public String getName() {
            return this.f_sName;
        }

        public Tags getTags() {
            return this.f_tags;
        }

        public String getDescription() {
            return this.f_metric.getDescription();
        }

        public double getValue() {
            Object oValue = this.f_metric.getValue();
            if (oValue instanceof Number) {
                return ((Number)oValue).doubleValue();
            }
            return 0.0;
        }

        public Holder setMetric(MBeanMetric metric) {
            this.f_metric = metric;
            return this;
        }
    }

    public static class Adapter
    implements MetricsRegistryAdapter {
        public void register(MBeanMetric metric) {
            INSTANCE.register(metric);
        }

        public void remove(MBeanMetric.Identifier identifier) {
            INSTANCE.remove(identifier);
        }
    }
}

