/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.ClusterNameSupplier;
import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.VersionUtils;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.coherence.management.internal.resources.VersionResource;
import com.tangosol.util.Filter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/coherence")
public class VersionsResource
extends AbstractManagementResource {
    @Context
    protected ClusterNameSupplier f_supplierClusters;

    @GET
    @Produces(value={"application/json"})
    public Response get() {
        return this.response(this.getResponseBody());
    }

    private EntityMBeanResponse getResponseBody() {
        Filter<String> propertiesFilter = this.getAttributesFilter();
        Filter<String> linksFilter = this.getLinksFilter();
        EntityMBeanResponse response = new EntityMBeanResponse(this.getRequestContext(), linksFilter);
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        response.addSelfResourceLinks(this.getCurrentUri());
        response.addResourceLink("current", VersionsResource.getSubUri(this.getCurrentUri(), "12.2.1.4.0"));
        items.add(this.getVersion("12.2.1.4.0", propertiesFilter, linksFilter));
        response.setEntities(items);
        return response;
    }

    private Map<String, Object> getVersion(String sVersion, Filter<String> filterProps, Filter<String> filterLinks) {
        EntityMBeanResponse response = new EntityMBeanResponse(this.getRequestContext(), filterLinks);
        response.setEntity(new LinkedHashMap<String, Object>(VersionUtils.getVersion(sVersion, true, "active", filterProps)));
        response.addSelfResourceLinks(VersionsResource.getSubUri(this.getCurrentUri(), sVersion));
        return response.toJson();
    }

    @Path(value="12.2.1.4.0")
    public Object getV1Resource() {
        return new VersionResource(this, this.f_supplierClusters);
    }

    @Path(value="latest")
    public Object getLatestResource() {
        return new VersionResource(this, this.f_supplierClusters);
    }
}

