/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.coherence.management.internal.resources.JournalMembersResource;
import com.tangosol.net.management.MBeanAccessor;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public class JournalResource
extends AbstractManagementResource {
    public JournalResource(AbstractManagementResource resource) {
        super(resource);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="journalType") String sJournalType, @QueryParam(value="role") String sRoleName, @QueryParam(value="collector") String sCollector) {
        EntityMBeanResponse response = this.getLinksOnlyResponseBody(this.getParentUri(), this.getCurrentUri(), "members");
        Map<String, Object> responseMap = response.toJson();
        this.addAggregatedMetricsToResponseMap(sRoleName, sCollector, this.getQuery(sJournalType), responseMap);
        return this.response(responseMap);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="compact")
    public Response compact(@PathParam(value="journalType") String sJournalType, Map<String, Object> entity) {
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sJournalType);
        Object oRegular = entity == null ? null : entity.get("regular");
        boolean fRegular = oRegular == null ? false : Boolean.parseBoolean(oRegular.toString());
        return this.executeMBeanOperation(bldrQuery, "compact", new Object[]{fRegular}, new String[]{Boolean.TYPE.getName()});
    }

    @Path(value="members")
    public Object getMembersResource() throws Exception {
        return new JournalMembersResource(this);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(Map mapQuery, Map<String, String> mapArguments, URI uriParent) {
        Object oChildren = this.getChildrenQuery(mapQuery);
        if (oChildren != null && oChildren instanceof Map) {
            LinkedHashMap<String, Object> mapResponse = new LinkedHashMap<String, Object>();
            Map mapChildrenQuery = (Map)oChildren;
            this.addChildResourceQueryResult(new JournalMembersResource(this), "members", mapResponse, mapChildrenQuery, mapArguments, this.getParentUri());
            EntityMBeanResponse responseEntity = new EntityMBeanResponse();
            responseEntity.setEntity(mapResponse);
            return responseEntity;
        }
        return null;
    }

    protected MBeanAccessor.QueryBuilder getQuery(String sJournalType) {
        return this.createQueryBuilder().withBaseQuery((String)MAP_JOURNAL_URL_TO_MBEAN_QUERY.get(sJournalType));
    }
}

