/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.management.internal.Converter;
import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.MBeanResponse;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.ValueExtractor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public abstract class AbstractManagementResource {
    public static final String INCLUDE_FIELDS = "fields";
    public static final String INCLUDE_LINKS = "links";
    public static final String EXCLUDE_FIELDS = "excludeFields";
    public static final String EXCLUDE_LINKS = "excludeLinks";
    public static final String MEDIA_TYPE_JSON = "application/json";
    public static final String MEDIA_TYPE_SWAGGER_JSON = "application/swagger+json";
    public static final String SWAGGER_RESOURCE = "management-swagger.json";
    public static final String MEDIA_TYPES = "application/json";
    public static final String CACHES_QUERY = ":type=Cache";
    public static final String CACHE_QUERY = ":type=Cache,name=";
    public static final String CACHE_MEMBERS_WITH_SERVICE_QUERY = ":type=Cache,name=";
    public static final String CLUSTER_MEMBERS_QUERY = ":type=Node";
    public static final String REPORTER_MEMBERS_QUERY = ":type=Reporter";
    public static final String FLASH_JOURNAL_QUERY = ":type=Journal,name=FlashJournalRM";
    public static final String RAM_JOURNAL_QUERY = ":type=Journal,name=RamJournalRM";
    public static final String CLUSTER_QUERY = ":type=Cluster";
    public static final String MANAGEMENT_QUERY = ":type=Management";
    public static final String POINT_TO_POINT_QUERY = ":type=PointToPoint";
    public static final String CONNECTION_MANAGERS_QUERY = ":type=ConnectionManager";
    public static final String CONNECTION_MANAGER_QUERY = ":type=ConnectionManager,name=";
    public static final String CONNECTIONS_QUERY = ":type=Connection,name=";
    public static final String SERVICE_MEMBERS_QUERY = ":type=Service,name=";
    public static final String PARTITION_ASSIGNMENT_QUERY = ":type=PartitionAssignment";
    public static final String SERVICES_QUERY = ":type=Service";
    public static final String FEDERATION_TYPE = ":type=Federation";
    public static final String FEDERATION_COORDINATOR_QUERY = ":type=Federation,responsibility=Coordinator";
    public static final String FEDERATION_TOPOLOGY_MEMBER_QUERY = ":type=Federation,subType=Topology,name=%s";
    public static final String FEDERATION_TOPOLOGIES_QUERY = ":type=Federation,subType=Topology";
    public static final String DESTINATIONS_QUERY = ":type=Federation,subType=Destination,name=";
    public static final String DESTINATIONS_COLLECTION_QUERY = ":type=Federation,subType=Destination";
    public static final String ORIGINS_COLLECTION_QUERY = ":type=Federation,subType=Origin";
    public static final String ORIGINS_QUERY = ":type=Federation,subType=Origin,name=";
    public static final String PERSISTENCE_CONTROLLER_QUERY = ":type=Persistence,responsibility=PersistenceCoordinator";
    public static final String PLATFORM_MEMORY_QUERY = ":type=Platform,Domain=java.lang,subType=Memory";
    public static final String COMPRESSED_CLASS_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=Compressed Class Space";
    public static final String META_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=Metaspace";
    public static final String PS_MARK_SWEEP_QUERY = ":type=Platform,Domain=java.lang,subType=GarbageCollector,name=PS MarkSweep";
    public static final String PS_SCAVENGE_QUERY = ":type=Platform,Domain=java.lang,subType=GarbageCollector,name=PS Scavenge";
    public static final String PS_OLDGEN_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=PS Old Gen";
    public static final String CODECACHE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=Code Cache";
    public static final String PS_EDEN_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=PS Eden Space";
    public static final String PS_SURVIVOR_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=PS Survivor Space";
    public static final String OS_QUERY = ":type=Platform,Domain=java.lang,subType=OperatingSystem";
    public static final String RUNTIME_QUERY = ":type=Platform,Domain=java.lang,subType=Runtime";
    public static final String G1_OLD_GENERATION_QUERY = ":type=Platform,Domain=java.lang,subType=GarbageCollector,name=G1 Old Generation";
    public static final String G1_YOUNG_GENERATION_QUERY = ":type=Platform,Domain=java.lang,subType=GarbageCollector,name=G1 Young Generation";
    public static final String G1_EDEN_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=G1 Eden Space";
    public static final String G1_OLDGEN_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=G1 Old Gen";
    public static final String G1_SURVIVOR_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=G1 Survivor Space";
    public static final String G1_CODEHEAP_NON_NMETHODS_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=CodeHeap 'non-nmethods'";
    public static final String G1_CODEHEAP_PROFILED_NMETHODS_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=CodeHeap 'profiled nmethods'";
    public static final String G1_CODECACHE_MANAGER = ":type=Platform,Domain=java.lang,subType=MemoryManager,name=CodeCacheManager";
    public static final String G1_METASPACE_MANAGER = ":type=Platform,Domain=java.lang,subType=MemoryManager,name=Metaspace Manager";
    public static final String CWEB_APPLICATIONS_QUERY = ":type=*HttpSessionManager";
    public static final String CWEB_APPLICATION_QUERY = ":type=*HttpSessionManager,appId=";
    public static final String STORAGE_MANAGERS_QUERY = ":type=StorageManager,cache=%s";
    public static final String STORAGE_MANAGER_QUERY = ":type=StorageManager,cache=%s,service=%s,nodeId=%s";
    public static final String CLUSTER_NAME = "clusterName";
    public static final String SERVICE_NAME = "serviceName";
    public static final String CACHE_NAME = "cacheName";
    public static final String MEMBER_KEY = "memberKey";
    public static final String VERSION = "versionName";
    public static final String PARTICIPANT_NAME = "participantName";
    public static final String TOPOLOGY_NAME = "topologyName";
    public static final String OPERATION_NAME = "operationName";
    public static final String PLATFORM_MBEAN = "platformMBean";
    public static final String APPLICATION_ID = "applicationId";
    public static final String DOMAIN_PARTITION = "domainPartition";
    public static final String TOPOLOGIES = "topologies";
    public static final String SNAPSHOT_NAME = "snapshotName";
    public static final String JFR_CMD = "jfrCmd";
    public static final String METADATA_CATALOG = "metadata-catalog";
    public static final String SERVICES = "services";
    public static final String MEMBERS = "members";
    public static final String REPORTERS = "reporters";
    public static final String CACHES = "caches";
    public static final String MANAGEMENT = "management";
    public static final String SHUTDOWN = "shutdown";
    public static final String CLUSTER = "cluster";
    public static final String SEARCH = "search";
    public static final String STORAGE = "storage";
    public static final String JOURNAL = "journal";
    public static final String JOURNAL_TYPE = "journalType";
    public static final String NETWORK_STATS = "networkStats";
    public static final String VERBOSE = "verbose";
    public static final String WEB_APPS = "webApplications";
    public static final String PERSISTENCE = "persistence";
    public static final String PROXY = "proxy";
    public static final String STATISTICS = "statistics";
    public static final String INCOMING = "incoming";
    public static final String OUTGOING = "outgoing";
    public static final String LOADER = "loader";
    public static final String MEMBER = "member";
    public static final String CONNECTIONS = "connections";
    public static final String ROLE_NAME = "role";
    public static final String COLLECTOR = "collector";
    public static final String PLATFORM = "platform";
    public static final String RAM_JOURNAL_TYPE = "ram";
    public static final String FLASH_JOURNAL_TYPE = "flash";
    public static final String PARTITION = "partition";
    public static final String RESET_STATS = "resetStatistics";
    public static final String CHILDREN = "children";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String NODE_ID = "nodeId";
    public static final String SERVICE = "service";
    public static final String TIER_BACK = "back";
    public static final String TIER = "tier";
    public static final String OPTIONS = "options";
    public static final Map<String, String> MAP_PLATFORM_URL_TO_MBEAN_QUERY = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("memory", AbstractManagementResource.PLATFORM_MEMORY_QUERY);
            this.put("metaSpace", AbstractManagementResource.META_SPACE_QUERY);
            this.put("compressedClassSpace", AbstractManagementResource.COMPRESSED_CLASS_SPACE_QUERY);
            this.put("operatingSystem", AbstractManagementResource.OS_QUERY);
            this.put("runtime", AbstractManagementResource.RUNTIME_QUERY);
        }
    });
    public static final Map<String, String> MAP_PLATFORM_PS_URL_TO_MBEAN_QUERY = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("psMarkSweep", AbstractManagementResource.PS_MARK_SWEEP_QUERY);
            this.put("psScavenge", AbstractManagementResource.PS_SCAVENGE_QUERY);
            this.put("psOldGen", AbstractManagementResource.PS_OLDGEN_QUERY);
            this.put("psEdenSpace", AbstractManagementResource.PS_EDEN_SPACE_QUERY);
            this.put("psSurvivorSpace", AbstractManagementResource.PS_SURVIVOR_SPACE_QUERY);
            this.put("codeCache", AbstractManagementResource.CODECACHE_QUERY);
        }
    });
    public static final Map<String, String> MAP_PLATFORM_G1_URL_TO_MBEAN_QUERY = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("g1EdenSpace", AbstractManagementResource.G1_EDEN_SPACE_QUERY);
            this.put("g1OldGen", AbstractManagementResource.G1_OLDGEN_QUERY);
            this.put("g1OldGeneration", AbstractManagementResource.G1_OLD_GENERATION_QUERY);
            this.put("g1SurvivorSpace", AbstractManagementResource.G1_SURVIVOR_SPACE_QUERY);
            this.put("g1YoungGeneration", AbstractManagementResource.G1_YOUNG_GENERATION_QUERY);
            this.put("g1CodeHeapNonNMethods", AbstractManagementResource.G1_CODEHEAP_NON_NMETHODS_QUERY);
            this.put("g1CodeHeapProfiledNMethods", AbstractManagementResource.G1_CODEHEAP_PROFILED_NMETHODS_QUERY);
            this.put("g1CodeCacheManager", AbstractManagementResource.G1_CODECACHE_MANAGER);
            this.put("g1MetaSpaceManager", AbstractManagementResource.G1_METASPACE_MANAGER);
        }
    });
    public static final Map<String, String> MAP_JOURNAL_URL_TO_MBEAN_QUERY = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(AbstractManagementResource.FLASH_JOURNAL_TYPE, AbstractManagementResource.FLASH_JOURNAL_QUERY);
            this.put(AbstractManagementResource.RAM_JOURNAL_TYPE, AbstractManagementResource.RAM_JOURNAL_QUERY);
        }
    });
    private static final Set<String> SET_LONG = new HashSet<String>(Arrays.asList("intervalSeconds", "currentBatch", "maxQueryThresholdMillis", "batchFactor", "transportRetainedBytes"));
    private static final Set<String> SET_INTEGER = new HashSet<String>(Arrays.asList("expiryDelay"));
    private static final Set<String> SET_FLOAT = new HashSet<String>(Arrays.asList("tracingSamplingRatio"));
    private static final Pattern PATH_PATTERN = Pattern.compile("/");
    @Context
    protected HttpHeaders m_requestHeaders;
    @Context
    protected UriInfo m_uriInfo;
    @Context
    protected ContainerRequestContext m_requestContext;
    @Context
    protected MBeanServerProxy m_mBeanServerProxy;
    private Filter<String> m_filterDomainPartition;
    private String m_sClusterName;
    private String m_sMBeanDomainName;
    protected MBeanAccessor m_accessor;

    public AbstractManagementResource() {
    }

    public AbstractManagementResource(AbstractManagementResource resource) {
        this.m_requestContext = resource.m_requestContext;
        this.m_requestHeaders = resource.m_requestHeaders;
        this.m_uriInfo = resource.m_uriInfo;
        this.m_mBeanServerProxy = resource.m_mBeanServerProxy;
        this.m_filterDomainPartition = resource.m_filterDomainPartition;
        this.m_sClusterName = resource.m_sClusterName;
        this.m_sMBeanDomainName = resource.m_sMBeanDomainName;
        if (this.m_sMBeanDomainName == null) {
            this.m_sMBeanDomainName = "*";
        }
    }

    protected Response update(Map<String, Object> entity, MBeanAccessor.QueryBuilder bldrQuery) {
        try {
            if (bldrQuery.toString().contains(MANAGEMENT_QUERY)) {
                this.checkAttributeTypeConversion(entity, true);
            } else {
                this.checkAttributeTypeConversion(entity);
            }
            MBeanResponse responseEntity = new MBeanResponse(this.getRequestContext());
            MBeanAccessor accessor = this.getMBeanAccessor();
            if (!entity.isEmpty()) {
                Map<String, Object> attrMap = entity.entrySet().stream().collect(Collectors.toMap(e -> AbstractManagementResource.fromRestName((String)e.getKey()), Map.Entry::getValue));
                Map mapUpdatedMBeans = accessor.update(bldrQuery.build(), attrMap);
                if (mapUpdatedMBeans.isEmpty()) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
                for (Map.Entry entry : mapUpdatedMBeans.entrySet()) {
                    String sObjName = (String)entry.getKey();
                    Map mapAttributes = (Map)entry.getValue();
                    for (String sAttrKey : attrMap.keySet()) {
                        if (mapAttributes.containsKey(sAttrKey)) continue;
                        responseEntity.addFailure(AbstractManagementResource.getRestName(sAttrKey), "Update attribute failed for MBean :" + sObjName);
                    }
                }
            }
            return this.response(responseEntity.toJson());
        }
        catch (IllegalArgumentException iae) {
            Response.Status status = Response.Status.BAD_REQUEST;
            Logger.info((String)("Request precondition failure for updating an MBean with query " + bldrQuery.toString() + ". Failure is " + iae.getClass().getName() + " " + iae.getMessage()));
            throw new WebApplicationException(Response.status((Response.Status)status).entity((Object)("HTTP " + status.getStatusCode() + ' ' + status.getReasonPhrase() + '\n' + iae.getMessage())).build());
        }
        catch (Exception e2) {
            Logger.warn((String)("Exception occurred while updating an MBean with query " + bldrQuery.toString()), (Throwable)e2);
            if (e2 instanceof WebApplicationException) {
                throw e2;
            }
            throw new WebApplicationException();
        }
    }

    protected EntityMBeanResponse getResponseEntityForMbean(MBeanAccessor.QueryBuilder bldrQuery, String ... asChildLinks) {
        return this.getResponseEntityForMbean(bldrQuery, this.getParentUri(), this.getCurrentUri(), this.getAttributesFilter(), this.getLinksFilter(), asChildLinks);
    }

    protected EntityMBeanResponse getResponseEntityForMbean(MBeanAccessor.QueryBuilder bldrQuery, URI uriParent, URI uriSelf, Map mapQuery, String ... asChildLinks) {
        return this.getResponseEntityForMbean(bldrQuery, uriParent, uriSelf, this.getAttributesFilter(mapQuery), this.getLinksFilter(mapQuery), asChildLinks);
    }

    protected EntityMBeanResponse getResponseEntityForMbean(MBeanAccessor.QueryBuilder bldrQuery, URI uriParent, URI uriSelf, Filter<String> filterAttributes, Filter<String> filterLinks, String ... asChildLinks) {
        try {
            EntityMBeanResponse responseEntity = this.createResponse(uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.getMBeanAccessor();
            Map mapResponses = accessor.getAttributes(bldrQuery.build());
            if (mapResponses.isEmpty()) {
                return null;
            }
            Map.Entry responseEntry = mapResponses.entrySet().iterator().next();
            responseEntity.setEntity(this.getMBeanAttributesMap(filterAttributes, (Map)responseEntry.getValue(), (String)responseEntry.getKey()));
            if (asChildLinks != null) {
                Arrays.stream(asChildLinks).forEach(l -> responseEntity.addResourceLink((String)l, AbstractManagementResource.getSubUri(uriSelf, l)));
            }
            return responseEntity;
        }
        catch (Exception e) {
            Logger.warn((String)("Exception occurred while getting response body for MBean with query " + bldrQuery.build()), (Throwable)e);
            if (e instanceof WebApplicationException) {
                throw (WebApplicationException)e;
            }
            throw new WebApplicationException();
        }
    }

    protected Response executeMBeanOperation(MBeanAccessor.QueryBuilder bldrQuery, String sOperationName, Object[] aoArguments, String[] asSignature) {
        try {
            MBeanAccessor accessor = this.getMBeanAccessor();
            Map mapMBeans = accessor.invoke(bldrQuery.build(), sOperationName, aoArguments, asSignature);
            if (mapMBeans.isEmpty()) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
        }
        catch (RuntimeException e) {
            Logger.warn((String)("Exception occurred while executing an Mbean operation on query " + bldrQuery.build() + ", and operationName " + sOperationName), (Throwable)e);
            if (e instanceof WebApplicationException) {
                throw (WebApplicationException)e;
            }
            MBeanResponse response = new MBeanResponse(this.getRequestContext());
            String sCause = "unknown, refer to log files for more information";
            Throwable tCause = Base.getOriginalException((RuntimeException)e);
            if (tCause != null) {
                sCause = Base.getDeepMessage((Throwable)tCause, (String)"\n");
            }
            response.addFailure(sOperationName + " failed, Cause=" + sCause);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(response.toJson()).build();
        }
        return this.response(new MBeanResponse(this.getRequestContext()).toJson());
    }

    protected EntityMBeanResponse getResponseFromMBeanOperation(MBeanAccessor.QueryBuilder bldrQuery, String sResponseKey, String sOperationName) {
        return this.getResponseFromMBeanOperation(bldrQuery, sResponseKey, sOperationName, null, null);
    }

    protected EntityMBeanResponse getResponseFromMBeanOperation(MBeanAccessor.QueryBuilder bldrQuery, String sResponseKey, String sOperationName, Object[] aoArguments, String[] asSignature) {
        URI uriParent = this.getParentUri();
        URI uriSelf = this.getCurrentUri();
        Filter<String> filterLinks = this.getLinksFilter();
        Filter<String> filterAttributes = this.getAttributesFilter();
        try {
            EntityMBeanResponse responseBody = this.createResponse(uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.getMBeanAccessor();
            Map mapMBeans = accessor.invoke(bldrQuery.build(), sOperationName, aoArguments, asSignature);
            if (!mapMBeans.isEmpty()) {
                Map.Entry entry = mapMBeans.entrySet().iterator().next();
                LinkedHashMap<String, Object> mapResponse = new LinkedHashMap<String, Object>();
                if (filterAttributes.evaluate((Object)sResponseKey.toUpperCase())) {
                    mapResponse.put(AbstractManagementResource.getRestName(sResponseKey), Converter.convert(entry.getValue()));
                }
                responseBody.setEntity(mapResponse);
            }
            return responseBody;
        }
        catch (RuntimeException e) {
            Logger.warn((String)("Exception occurred while executing an Mbean operation on query" + bldrQuery.toString() + "and operationName " + sOperationName), (Throwable)e);
            if (e instanceof WebApplicationException) {
                throw e;
            }
            EntityMBeanResponse responseBody = this.createResponse(uriParent, uriSelf, filterLinks);
            String sCause = "unknown, refer to log files for more information";
            Throwable tCause = Base.getOriginalException((RuntimeException)e);
            if (tCause != null) {
                sCause = Base.getDeepMessage((Throwable)tCause, (String)"\n");
            }
            responseBody.addFailure(sOperationName + " failed, Cause=" + sCause);
            return responseBody;
        }
    }

    protected EntityMBeanResponse getResponseBodyForMBeanCollection(MBeanAccessor.QueryBuilder bldrQuery, AbstractManagementResource resource, String sUniqueKeyProperty, Map mapQuery, URI uriParent, URI uriSelf, Map<String, String> mapArguments) {
        try {
            ArrayList<Map<String, Object>> listChildEntities;
            Filter<String> filterLinks = this.getLinksFilter(mapQuery);
            EntityMBeanResponse responseEntity = this.createResponse(uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.getMBeanAccessor();
            Set setObjectNames = accessor.queryKeys(bldrQuery.build());
            if (setObjectNames != null && !setObjectNames.isEmpty()) {
                listChildEntities = new ArrayList<Map<String, Object>>();
                Set<ObjectName> setObjNames = AbstractManagementResource.convertToObjectNames(setObjectNames);
                Map<String, List<ObjectName>> mapMBeanToName = setObjNames.stream().collect(Collectors.groupingBy(o -> o.getKeyProperty(sUniqueKeyProperty)));
                for (Map.Entry<String, List<ObjectName>> entry : mapMBeanToName.entrySet()) {
                    HashMap<String, String> mapChildResourceArgs = new HashMap<String, String>();
                    if (mapArguments != null) {
                        mapChildResourceArgs.putAll(mapArguments);
                    }
                    mapChildResourceArgs.put(sUniqueKeyProperty, entry.getKey());
                    Map<String, Object> mapObjResponse = resource.getQueryResult(mapQuery, mapChildResourceArgs, uriSelf).toJson();
                    listChildEntities.add(mapObjResponse);
                }
            } else {
                return null;
            }
            responseEntity.setEntities(listChildEntities);
            return responseEntity;
        }
        catch (Exception e) {
            Logger.warn((String)("Exception occurred while getting response for an MBean collection with query " + bldrQuery.build().getQuery()), (Throwable)e);
            throw new WebApplicationException();
        }
    }

    protected EntityMBeanResponse getResponseBodyForMBeanCollection(MBeanAccessor.QueryBuilder bldrQuery, AbstractManagementResource resource, Map mapQuery, Map<String, String> mapArguments, URI uriParent, URI uriSelf) {
        try {
            Filter<String> filterLinks = this.getLinksFilter(mapQuery);
            EntityMBeanResponse responseEntity = this.createResponse(uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.getMBeanAccessor();
            Map mapMBeans = accessor.getAttributes(bldrQuery.build());
            if (mapMBeans != null && !mapMBeans.isEmpty()) {
                ArrayList<Map<String, Object>> listChildEntities = new ArrayList<Map<String, Object>>();
                Filter<String> filterAttributes = this.getAttributesFilter(mapQuery);
                for (Map.Entry entry : mapMBeans.entrySet()) {
                    String sObjName = (String)entry.getKey();
                    ObjectName objName = new ObjectName(sObjName);
                    HashMap<String, String> mapChildResourceArgs = new HashMap<String, String>();
                    if (mapArguments != null) {
                        mapChildResourceArgs.putAll(mapArguments);
                    }
                    mapChildResourceArgs.put(MEMBER_KEY, this.getMemberReference(objName));
                    EntityMBeanResponse response = resource.getQueryResult(mapQuery, mapChildResourceArgs, uriSelf);
                    response.getEntity().putAll(this.getMBeanAttributesMap(filterAttributes, (Map)entry.getValue(), (String)entry.getKey()));
                    listChildEntities.add(response.toJson());
                }
                responseEntity.setEntities(listChildEntities);
            }
            return responseEntity;
        }
        catch (Exception e) {
            Logger.warn((String)("Exception occurred while getting response for an MBean collection with query " + bldrQuery.build()), (Throwable)e);
            throw new WebApplicationException();
        }
    }

    protected EntityMBeanResponse getResponseBodyForMBeanCollection(MBeanAccessor.QueryBuilder bldrQuery, String sUniqueKeyProperty, Map mapQuery, URI uriParent, URI uriSelf) {
        try {
            Filter<String> filterLinks = this.getLinksFilter(mapQuery);
            EntityMBeanResponse responseEntity = this.createResponse(uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.getMBeanAccessor();
            Map mapMBeans = accessor.getAttributes(bldrQuery.build());
            if (mapMBeans != null && !mapMBeans.isEmpty()) {
                ArrayList<Map<String, Object>> listChildEntities = new ArrayList<Map<String, Object>>();
                Filter<String> filterAttributes = this.getAttributesFilter(mapQuery);
                for (Map.Entry entry : mapMBeans.entrySet()) {
                    String sObjName = (String)entry.getKey();
                    Map mapAttributes = (Map)entry.getValue();
                    ObjectName objectName = new ObjectName((String)entry.getKey());
                    URI uriSub = AbstractManagementResource.getSubUri(uriSelf, objectName.getKeyProperty(sUniqueKeyProperty));
                    EntityMBeanResponse responseEntityChild = this.createResponse(uriSelf, uriSub, filterLinks);
                    responseEntityChild.setEntity(this.getMBeanAttributesMap(filterAttributes, mapAttributes, sObjName));
                    listChildEntities.add(responseEntityChild.toJson());
                }
                responseEntity.setEntities(listChildEntities);
            }
            return responseEntity;
        }
        catch (Exception e) {
            Logger.warn((String)("Exception occurred while getting response for an MBean collection with query " + bldrQuery.build()), (Throwable)e);
            throw new WebApplicationException();
        }
    }

    protected EntityMBeanResponse getResponseBodyForMBeanCollection(MBeanAccessor.QueryBuilder bldrQuery, Map mapQuery, URI uriParent, URI uriSelf) {
        try {
            Filter<String> filterLinks = this.getLinksFilter(mapQuery);
            EntityMBeanResponse responseEntity = this.createResponse(uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.getMBeanAccessor();
            Map mapMBeans = accessor.getAttributes(bldrQuery.build());
            if (mapMBeans != null && !mapMBeans.isEmpty()) {
                ArrayList<Map<String, Object>> listChildEntities = new ArrayList<Map<String, Object>>();
                Filter<String> filterAttributes = this.getAttributesFilter(mapQuery);
                for (Map.Entry entry : mapMBeans.entrySet()) {
                    listChildEntities.add(this.getMBeanAttributesMap(filterAttributes, (Map)entry.getValue(), (String)entry.getKey()));
                }
                responseEntity.setEntities(listChildEntities);
            }
            return responseEntity;
        }
        catch (Exception e) {
            Logger.warn((String)("Exception occurred while getting response for an MBean collection with query " + bldrQuery.build()), (Throwable)e);
            throw new WebApplicationException();
        }
    }

    protected EntityMBeanResponse getLinksOnlyResponseBody(URI uriParent, URI uriSelf, Filter<String> filterLinks, String ... aChildLinks) {
        EntityMBeanResponse responseEntity = this.createResponse(uriParent, uriSelf, filterLinks);
        if (aChildLinks != null) {
            Arrays.stream(aChildLinks).forEach(l -> responseEntity.addResourceLink((String)l, AbstractManagementResource.getSubUri(uriSelf, l)));
        }
        return responseEntity;
    }

    protected EntityMBeanResponse getLinksOnlyResponseBody(URI uriParent, URI uriSelf, String ... aChildLinks) {
        return this.getLinksOnlyResponseBody(uriParent, uriSelf, this.getLinksFilter(), aChildLinks);
    }

    protected Map<String, Object> getAggregatedMetrics(String sLocator, String sAttribute, String sCollector, MBeanAccessor.QueryBuilder bldrQuery) {
        try {
            MBeanAccessor accessor = this.getMBeanAccessor();
            return accessor.aggregate(bldrQuery.build(), sLocator, sAttribute, sCollector);
        }
        catch (RuntimeException e) {
            Response.Status status = Response.Status.SERVICE_UNAVAILABLE;
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!(t instanceof IllegalArgumentException) && !(t instanceof AttributeNotFoundException)) continue;
                status = Response.Status.BAD_REQUEST;
            }
            if (status.equals((Object)Response.Status.BAD_REQUEST)) {
                throw new WebApplicationException(Response.status((Response.Status)status).entity((Object)("HTTP " + status.getStatusCode() + ' ' + status.getReasonPhrase() + '\n' + e.getMessage())).build());
            }
            Logger.warn((String)("Exception occurred while aggregating metrics with query " + bldrQuery.build()), (Throwable)e);
            throw new WebApplicationException();
        }
    }

    protected EntityMBeanResponse getQueryResult(Map mapQuery, Map<String, String> mapArguments, URI uriParent) {
        return null;
    }

    protected void addChildResourceQueryResult(AbstractManagementResource resource, String sChildResourceKey, Map<String, Object> mapResponse, Map mapQuery, Map<String, String> mapArguments, URI uriParent) {
        EntityMBeanResponse responseEntity;
        Object childQueryEntity = mapQuery.get(sChildResourceKey);
        if (childQueryEntity != null && childQueryEntity instanceof Map && (responseEntity = resource.getQueryResult((Map)childQueryEntity, mapArguments, uriParent)) != null) {
            mapResponse.put(sChildResourceKey, responseEntity.toJson());
        }
    }

    protected void addChildMbeanQueryResult(String sChildKey, MBeanAccessor.QueryBuilder bldrQuery, Map<String, Object> mapResponse, Map mapQuery, String ... childLinks) {
        Object oChildValue = mapQuery.get(sChildKey);
        if (oChildValue != null && oChildValue instanceof Map) {
            Map mapChildrenQuery = (Map)oChildValue;
            EntityMBeanResponse responseEntity = this.getResponseEntityForMbean(bldrQuery, this.getParentUri(), this.getCurrentUri(), this.getAttributesFilter(mapChildrenQuery), this.getLinksFilter(mapChildrenQuery), childLinks);
            if (responseEntity != null) {
                mapResponse.put(sChildKey, responseEntity.toJson());
            }
        }
    }

    protected void addAggregatedMetricsToResponseMap(String sRoleName, String sCollector, MBeanAccessor.QueryBuilder bldrQuery, Map<String, Object> mapResponse) {
        Map<String, Object> mapAggregatedMetrics = this.getAggregatedMetrics(sRoleName, null, sCollector, bldrQuery);
        Filter<String> filterAttributes = this.getAttributesFilter();
        for (Map.Entry<String, Object> entry : mapAggregatedMetrics.entrySet()) {
            String sAttributeKey = entry.getKey();
            if (!filterAttributes.evaluate((Object)sAttributeKey.toUpperCase())) continue;
            mapResponse.put(AbstractManagementResource.getRestName(sAttributeKey), Converter.convert(entry.getValue()));
        }
    }

    protected Filter<String> getDomainPartitionFilter() {
        return this.m_filterDomainPartition;
    }

    protected String getMemberReference(ObjectName objName) {
        String sMemberName = objName.getKeyProperty(MEMBER);
        if (sMemberName != null) {
            return sMemberName;
        }
        return objName.getKeyProperty(MBeanAccessor.NODE_ID);
    }

    protected Object getChildrenQuery(Map mapQuery) {
        return mapQuery == null ? null : mapQuery.get(CHILDREN);
    }

    protected Map<String, Object> getMBeanAttributesMap(Filter<String> filterAttributes, Map<String, Object> mapResponse, String sObjName) throws Exception {
        LinkedHashMap<String, Object> mapAttributes = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : mapResponse.entrySet()) {
            String sAttrName = AbstractManagementResource.getRestName(entry.getKey());
            if (!filterAttributes.evaluate((Object)sAttrName)) continue;
            mapAttributes.put(sAttrName, Converter.convert(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : new ObjectName(sObjName).getKeyPropertyList().entrySet()) {
            String sKey = AbstractManagementResource.getRestName(entry.getKey());
            if (!filterAttributes.evaluate((Object)sKey)) continue;
            mapAttributes.putIfAbsent(sKey, entry.getValue());
        }
        return mapAttributes;
    }

    protected AttributeList getAttributeList(Map<String, Object> mapEntity) {
        return new AttributeList(mapEntity.entrySet().stream().map(e -> new Attribute(AbstractManagementResource.fromRestName((String)e.getKey()), e.getValue())).collect(Collectors.toList()));
    }

    protected Filter<String> getAttributesFilter() {
        String sIncludeFields = (String)this.m_uriInfo.getQueryParameters().getFirst((Object)INCLUDE_FIELDS);
        String sExcludeFields = (String)this.m_uriInfo.getQueryParameters().getFirst((Object)EXCLUDE_FIELDS);
        return this.getAttributesFilter(sIncludeFields, sExcludeFields);
    }

    protected Filter<String> getAttributesFilter(String sIncludeFields, String sExcludeFields) {
        Filter filterAttributes = Filters.always();
        if (sIncludeFields != null) {
            Set setIncludedFields = Arrays.stream(sIncludeFields.split(",")).map(String::toUpperCase).collect(Collectors.toSet());
            filterAttributes = Filters.in(String::toUpperCase, setIncludedFields);
        }
        if (sExcludeFields != null) {
            Set setExcludedFields = Arrays.stream(sExcludeFields.split(",")).map(String::toUpperCase).collect(Collectors.toSet());
            Filter filterExclude = Filters.not((Filter)Filters.in(String::toUpperCase, setExcludedFields));
            filterAttributes = filterExclude.and(filterAttributes);
        }
        return filterAttributes;
    }

    protected Filter<String> getLinksFilter() {
        String sIncludeLinks = (String)this.m_uriInfo.getQueryParameters().getFirst((Object)INCLUDE_LINKS);
        String sExcludeLinks = (String)this.m_uriInfo.getQueryParameters().getFirst((Object)EXCLUDE_LINKS);
        Filter filterLinks = Filters.always();
        if (sIncludeLinks != null) {
            Set setIncludedLinks = Arrays.stream(sIncludeLinks.split(",")).collect(Collectors.toSet());
            filterLinks = Filters.in((ValueExtractor)ValueExtractor.identity(), setIncludedLinks);
        }
        if (sExcludeLinks != null) {
            Set setExcludedLinks = Arrays.stream(sExcludeLinks.split(",")).collect(Collectors.toSet());
            Filter filterExclude = Filters.not((Filter)Filters.in((ValueExtractor)ValueExtractor.identity(), setExcludedLinks));
            filterLinks = filterExclude.and(filterLinks);
        }
        return filterLinks;
    }

    protected Filter<String> getAttributesFilter(Map mapQuery) {
        if (mapQuery == null) {
            return this.getAttributesFilter();
        }
        List listIncludeFields = (List)mapQuery.get(INCLUDE_FIELDS);
        List listExcludeFields = (List)mapQuery.get(EXCLUDE_FIELDS);
        Filter filterAttributes = Filters.always();
        if (listIncludeFields != null) {
            Set setIncludedFields = listIncludeFields.stream().map(String::toUpperCase).collect(Collectors.toSet());
            filterAttributes = Filters.in(String::toUpperCase, setIncludedFields);
        }
        if (listExcludeFields != null) {
            Set setExcludedFields = listExcludeFields.stream().map(String::toUpperCase).collect(Collectors.toSet());
            Filter filterExclude = Filters.not((Filter)Filters.in(String::toUpperCase, setExcludedFields));
            filterAttributes = filterExclude.and(filterAttributes);
        }
        return filterAttributes;
    }

    protected Filter<String> getLinksFilter(Map mapQuery) {
        if (mapQuery == null) {
            return this.getLinksFilter();
        }
        List listIncludeLinks = (List)mapQuery.get(INCLUDE_LINKS);
        List listExcludeLinks = (List)mapQuery.get(EXCLUDE_LINKS);
        Filter filterLinks = Filters.always();
        if (listIncludeLinks != null) {
            Set setIncludedLinks = listIncludeLinks.stream().collect(Collectors.toSet());
            filterLinks = Filters.in((ValueExtractor)ValueExtractor.identity(), setIncludedLinks);
        }
        if (listExcludeLinks != null) {
            Set setExcludedLinks = listExcludeLinks.stream().map(s -> AbstractManagementResource.fromRestName(s)).collect(Collectors.toSet());
            Filter filterExclude = Filters.not((Filter)Filters.in((ValueExtractor)ValueExtractor.identity(), setExcludedLinks));
            filterLinks = filterExclude.and(filterLinks);
        }
        return filterLinks;
    }

    protected String getExcludeList(Map mapQuery) {
        if (mapQuery == null) {
            return (String)this.m_uriInfo.getQueryParameters().getFirst((Object)EXCLUDE_FIELDS);
        }
        List listExcludeFields = (List)mapQuery.get(EXCLUDE_FIELDS);
        return listExcludeFields == null ? null : listExcludeFields.stream().collect(Collectors.joining(","));
    }

    protected EntityMBeanResponse createResponse(URI parentUri, URI selfUri, Filter<String> linksFilter) {
        EntityMBeanResponse responseBody = new EntityMBeanResponse(this.m_requestContext, linksFilter);
        responseBody.addParentResourceLink(parentUri);
        responseBody.addSelfResourceLinks(selfUri);
        return responseBody;
    }

    protected Response response(EntityMBeanResponse responseEntity) {
        if (responseEntity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (responseEntity.hasFailures()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(responseEntity.toJson()).build();
        }
        return Response.ok(responseEntity.toJson()).build();
    }

    protected void setDomainPartitionFilter(Filter<String> filter) {
        this.m_filterDomainPartition = filter;
    }

    protected Response response(Map<String, Object> mapResponse) {
        return Response.ok(mapResponse).build();
    }

    public void setClusterName(String sClusterName) {
        this.m_sClusterName = sClusterName;
    }

    public void setMBeanDomainName(String sMBeanDomainName) {
        this.m_sMBeanDomainName = sMBeanDomainName;
    }

    protected void checkAttributeTypeConversion(Map<String, Object> entity) {
        this.checkAttributeTypeConversion(entity, false);
    }

    protected void checkAttributeTypeConversion(Map<String, Object> entity, boolean fManagement) {
        entity.replaceAll((k, v) -> {
            Class<Object> clzConvertTo = Object.class;
            try {
                if ((SET_LONG.contains(k) || fManagement && k.compareToIgnoreCase("expiryDelay") == 0) && !(v instanceof Long)) {
                    clzConvertTo = Long.TYPE;
                    return Long.valueOf(v.toString());
                }
                if (SET_INTEGER.contains(k) && !(v instanceof Integer)) {
                    clzConvertTo = Integer.TYPE;
                    return Integer.valueOf(v.toString());
                }
                if (SET_FLOAT.contains(k) && !(v instanceof Float)) {
                    clzConvertTo = Float.TYPE;
                    return Float.valueOf(v.toString());
                }
                return v;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid value for attribute " + k + "; failed type conversion to " + clzConvertTo.getName() + " due to " + e.getClass().getName() + " " + e.getMessage(), e);
            }
        });
    }

    protected String getService() {
        return (String)this.m_uriInfo.getPathParameters().getFirst((Object)SERVICE_NAME);
    }

    protected URI getParentUri() {
        return AbstractManagementResource.getParentUri(this.m_uriInfo);
    }

    protected URI getCurrentUri() {
        return AbstractManagementResource.getSubUri(this.m_uriInfo, new String[0]);
    }

    protected MBeanServerProxy getMBeanServerProxy() {
        return this.m_mBeanServerProxy;
    }

    protected ContainerRequestContext getRequestContext() {
        return this.m_requestContext;
    }

    protected String getCluster() {
        return this.m_sClusterName;
    }

    protected String getMBeanDomainName() {
        return this.m_sMBeanDomainName;
    }

    public static String getRestName(String sName) {
        int count;
        for (count = 0; count < sName.length() && Character.isUpperCase(sName.charAt(count)); ++count) {
        }
        if (count == sName.length()) {
            return sName;
        }
        if (count == 0) {
            return sName;
        }
        if (count == 1) {
            return sName.substring(0, count).toLowerCase() + sName.substring(count);
        }
        return sName;
    }

    public static String fromRestName(String sName) {
        return sName.substring(0, 1).toUpperCase() + sName.substring(1);
    }

    public static URI getSubUri(URI uriParent, String ... asSegments) {
        UriBuilder bldr = UriBuilder.fromUri((URI)uriParent);
        for (String segment : asSegments) {
            int cSlash = segment.indexOf(47);
            if (cSlash == -1) {
                bldr.segment(new String[]{segment});
                continue;
            }
            for (String sPart : PATH_PATTERN.split(segment)) {
                bldr.segment(new String[]{sPart});
            }
        }
        return bldr.build(new Object[0]);
    }

    public static URI getSubUri(UriInfo uriInfo, String ... asSegments) {
        UriBuilder builder = uriInfo.getAbsolutePathBuilder();
        Arrays.stream(asSegments).forEach(xva$0 -> builder.segment(new String[]{xva$0}));
        return builder.build(new Object[0]);
    }

    public static URI getParentUri(UriInfo uriInfo) {
        int count = AbstractManagementResource.getParentUriSegmentsCount(uriInfo);
        List pathSegments = uriInfo.getPathSegments();
        UriBuilder bldr = uriInfo.getBaseUriBuilder();
        for (int i = 0; i < count; ++i) {
            bldr.path(((PathSegment)pathSegments.get(i)).getPath());
        }
        return bldr.build(new Object[0]);
    }

    public static Set<ObjectName> convertToObjectNames(Set<String> setObjectNames) throws MalformedObjectNameException {
        HashSet<ObjectName> setObjNames = new HashSet<ObjectName>();
        for (String sObjectName : setObjectNames) {
            setObjNames.add(new ObjectName(sObjectName));
        }
        return setObjNames;
    }

    protected static int getParentUriSegmentsCount(UriInfo uriInfo) {
        int count;
        List pathSegments = uriInfo.getPathSegments();
        if (((PathSegment)pathSegments.get(count = pathSegments.size() - 1)).getPath().isEmpty()) {
            --count;
        }
        return count;
    }

    protected MBeanAccessor.QueryBuilder createQueryBuilder() {
        MBeanAccessor.QueryBuilder bldrQuery = new MBeanAccessor.QueryBuilder().withMBeanDomainName(this.getMBeanDomainName()).withCluster(this.getCluster());
        Filter<String> filter = this.getDomainPartitionFilter();
        if (filter != null) {
            bldrQuery.withFilter(DOMAIN_PARTITION, this.getDomainPartitionFilter());
        }
        return bldrQuery;
    }

    protected MBeanAccessor getMBeanAccessor() {
        MBeanAccessor accessor = this.m_accessor;
        if (accessor == null) {
            accessor = this.m_accessor = new MBeanAccessor(this.m_mBeanServerProxy);
        }
        return accessor;
    }
}

