/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.MBeanResponse;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.coherence.management.internal.resources.ServiceResource;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class ServicesResource
extends AbstractManagementResource {
    public ServicesResource(AbstractManagementResource resource) {
        super(resource);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get() {
        return this.response(this.getResponseBodyForMBeanCollection(this.getQuery(), new ServiceResource(this), "name", null, this.getParentUri(), this.getCurrentUri(), null));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="members")
    public Response getAllServiceMembers() {
        return this.response(this.getResponseBodyForMBeanCollection(this.getQuery(), null, this.getParentUri(), this.getCurrentUri()));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="proxy/members")
    public Response getAllProxyMembers() {
        MBeanAccessor.QueryBuilder bldrQuery = this.createQueryBuilder().withBaseQuery(":type=ConnectionManager");
        return this.response(this.getResponseBodyForMBeanCollection(bldrQuery, null, this.getParentUri(), this.getCurrentUri()));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="persistence/snapshots/{snapshotName}")
    public Response executeSnapshotOperationAllServices(@PathParam(value="snapshotName") String sSnapshotName) {
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        EntityMBeanResponse response = this.getResponseBodyForMBeanCollection(this.instantiatePersistentServicesQuery(), null, this.getParentUri(), this.getCurrentUri());
        List<Map<String, Object>> listEntities = response.getEntities();
        if (listEntities.isEmpty()) {
            Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(response.toJson()).build();
        } else {
            for (Map<String, Object> entity : listEntities) {
                String sService = (String)entity.get("service");
                Response resp = this.executeMBeanOperation(this.instantiatePersistentServicesQuery(sService), "createSnapshot", aoArguments, asSignature);
                if (resp.getStatus() == 200) continue;
                MBeanResponse mbeanResponse = new MBeanResponse(this.getRequestContext());
                String sMsg = "Creation of a snapshot across all service failed for service " + sService + '.';
                mbeanResponse.addFailure(sMsg);
                mbeanResponse.addFailure(resp.getEntity().toString());
                return Response.status((int)resp.getStatus()).entity(mbeanResponse.toJson()).build();
            }
        }
        return Response.status((int)200).build();
    }

    @Path(value="{serviceName}")
    public Object getServiceResource() {
        return new ServiceResource(this);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(Map mapQuery, Map<String, String> mapArguments, URI uriParent) {
        try {
            Filter<String> filterLinks = this.getLinksFilter(mapQuery);
            URI uriSelf = ServicesResource.getSubUri(uriParent, "services");
            MBeanAccessor accessor = new MBeanAccessor(this.getMBeanServerProxy());
            EntityMBeanResponse responseEntity = this.createResponse(uriParent, uriSelf, filterLinks);
            Set setObjectNames = accessor.queryKeys(this.getQuery().build());
            if (setObjectNames != null && !setObjectNames.isEmpty()) {
                Set<ObjectName> setObjNames = ServicesResource.convertToObjectNames(setObjectNames);
                ArrayList<Map<String, Object>> listServices = new ArrayList<Map<String, Object>>();
                Set setDomainPartitions = setObjNames.stream().map(o -> o.getKeyProperty("domainPartition")).collect(Collectors.toSet());
                for (String domainPartition : setDomainPartitions) {
                    listServices.addAll(this.getResponseForDomainPartition(mapQuery, uriSelf, setObjNames, domainPartition));
                }
                responseEntity.setEntities(listServices);
            }
            return responseEntity;
        }
        catch (Exception e) {
            CacheFactory.log((String)("Exception occurred while getting response for an MBean collection for Services\n" + CacheFactory.getStackTrace((Throwable)e)));
            throw new WebApplicationException();
        }
    }

    protected MBeanAccessor.QueryBuilder getQuery() {
        return this.createQueryBuilder().withBaseQuery(":type=Service");
    }

    protected List<Map<String, Object>> getResponseForDomainPartition(Map mapQuery, URI uriSelf, Set<ObjectName> setObjectNames, String sDomainPartition) {
        ArrayList<Map<String, Object>> listChildEntities = new ArrayList<Map<String, Object>>();
        Map<String, List<ObjectName>> mapMBeanToName = setObjectNames.stream().filter(this.matchesDomainPartition(sDomainPartition)).collect(Collectors.groupingBy(o -> o.getKeyProperty("name")));
        for (Map.Entry<String, List<ObjectName>> entry : mapMBeanToName.entrySet()) {
            ServiceResource resource = new ServiceResource(this);
            resource.setDomainPartitionFilter(this.createDomainPartitionPredicate(sDomainPartition));
            listChildEntities.add(((AbstractManagementResource)resource).getQueryResult(mapQuery, Collections.singletonMap("name", entry.getKey()), uriSelf).toJson());
        }
        return listChildEntities;
    }

    protected Predicate<ObjectName> matchesDomainPartition(String domainPartition) {
        return o -> domainPartition == null ? o.getKeyProperty("domainPartition") == null : domainPartition.equals(o.getKeyProperty("domainPartition"));
    }

    public Filter<String> createDomainPartitionPredicate(String sDomainPartitionName) {
        return sDomainPartitionName == null ? Objects::isNull : (Filter & Serializable)s -> s.equals(sDomainPartitionName);
    }

    protected MBeanAccessor.QueryBuilder instantiatePersistentServicesQuery(String sService) {
        return this.createQueryBuilder().withBaseQuery(":type=Persistence,responsibility=PersistenceCoordinator").withService(sService);
    }

    protected MBeanAccessor.QueryBuilder instantiatePersistentServicesQuery() {
        return this.createQueryBuilder().withBaseQuery(":type=Persistence,responsibility=PersistenceCoordinator").exact(false);
    }
}

