/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;

public class KeystoreLogin
implements LoginModule {
    public static final String KEYSTORE_TYPE = "JKS";
    private CallbackHandler m_handler;
    private Subject m_subject;
    private Set m_setPrincipals = new HashSet();
    private Set m_setPublicCreds = new HashSet();
    private Set m_setPrivateCreds = new HashSet();
    protected KeyStore m_store;
    protected String m_sKeyStoreType = "JKS";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map mapSharedState, Map mapOptions) {
        File fileKeyStore;
        int ofEnd;
        String sKeyStoreType;
        if (subject == null) {
            throw new IllegalArgumentException("Subject is not specified");
        }
        if (callbackHandler == null) {
            throw new IllegalArgumentException("CallbackHandler is not specified");
        }
        String sKeyStorePath = (String)mapOptions.get("keyStorePath");
        if (sKeyStorePath == null) {
            sKeyStorePath = "${java.home}${/}.keystore";
        }
        String sKeyStorePass = (String)mapOptions.get("keyStorePass");
        char[] achPwd = null;
        if (sKeyStorePass != null) {
            achPwd = sKeyStorePass.toCharArray();
        }
        if ((sKeyStoreType = (String)mapOptions.get("keyStoreType")) != null && !sKeyStoreType.isEmpty()) {
            this.m_sKeyStoreType = sKeyStoreType;
        }
        int ofVar = sKeyStorePath.indexOf("${");
        while (ofVar >= 0 && (ofEnd = sKeyStorePath.indexOf(125, ofVar)) >= 0) {
            String sVal;
            String sVar = sKeyStorePath.substring(ofVar + 2, ofEnd);
            String string = sVal = sVar.equals("/") ? File.separator : System.getProperty(sVar);
            if (sVal == null) break;
            sKeyStorePath = sKeyStorePath.substring(0, ofVar) + sVal + sKeyStorePath.substring(ofEnd + 1);
            ofVar = sKeyStorePath.indexOf("${");
        }
        if (!(fileKeyStore = new File(sKeyStorePath)).exists()) {
            throw new IllegalArgumentException("Keystore is not accessible: " + fileKeyStore.getAbsolutePath());
        }
        FileInputStream inStore = null;
        try {
            KeyStore store = KeyStore.getInstance(this.m_sKeyStoreType);
            inStore = new FileInputStream(fileKeyStore);
            store.load(inStore, achPwd);
            this.m_store = store;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load keystore: " + fileKeyStore.getAbsolutePath() + "; " + e);
        }
        finally {
            if (inStore != null) {
                try {
                    inStore.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.m_subject = subject;
        this.m_handler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.m_store == null || this.m_subject == null || this.m_handler == null) {
            throw new LoginException("Module initialization failed");
        }
        NameCallback callbackName = new NameCallback("Username:");
        PasswordCallback callbackPwd = new PasswordCallback("Password:", false);
        try {
            this.m_handler.handle(new Callback[]{callbackName, callbackPwd});
        }
        catch (Exception e) {
            throw new LoginException("Callback failed: " + e);
        }
        String sName = callbackName.getName();
        char[] acPwd = callbackPwd.getPassword();
        callbackPwd.clearPassword();
        try {
            this.validate(sName, acPwd);
            return true;
        }
        catch (GeneralSecurityException e) {
            this.m_setPrincipals.clear();
            this.m_setPublicCreds.clear();
            this.m_setPrivateCreds.clear();
            throw new LoginException("Validation failed: " + e);
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.m_setPrincipals.isEmpty()) {
            throw new IllegalStateException("Commit is called out of sequence");
        }
        Subject subject = this.m_subject;
        if (subject.isReadOnly()) {
            throw new LoginException("Subject is Readonly");
        }
        subject.getPrincipals().addAll(this.m_setPrincipals);
        subject.getPublicCredentials().addAll(this.m_setPublicCreds);
        subject.getPrivateCredentials().addAll(this.m_setPrivateCreds);
        this.m_setPrincipals.clear();
        this.m_setPublicCreds.clear();
        this.m_setPrivateCreds.clear();
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return this.logout();
    }

    @Override
    public boolean logout() throws LoginException {
        this.m_setPrincipals.clear();
        this.m_setPublicCreds.clear();
        this.m_setPrivateCreds.clear();
        try {
            Subject subject = this.m_subject;
            if (!subject.isReadOnly()) {
                subject.getPrincipals().clear();
                subject.getPublicCredentials().clear();
                subject.getPrivateCredentials().clear();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return true;
    }

    protected void validate(String sName, char[] acPwd) throws GeneralSecurityException {
        PrivateKey keyPrivate = (PrivateKey)this.m_store.getKey(sName, acPwd);
        if (keyPrivate == null) {
            throw new GeneralSecurityException("Invalid name: " + sName);
        }
        Certificate[] acert = this.m_store.getCertificateChain(sName);
        if (acert != null && acert.length > 0) {
            Certificate cert = acert[0];
            if (cert instanceof X509Certificate) {
                X509Certificate certX509 = (X509Certificate)cert;
                X500Principal principal = new X500Principal(certX509.getIssuerDN().getName());
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                CertPath certPath = factory.generateCertPath(Arrays.asList(acert));
                this.m_setPrincipals.add(principal);
                this.m_setPublicCreds.add(certPath);
                this.m_setPrivateCreds.add(new X500PrivateCredential(certX509, keyPrivate, sName));
            } else {
                this.m_setPublicCreds.add(cert);
                this.m_setPrivateCreds.add(keyPrivate);
            }
        }
    }
}

