/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.internal;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.stream.JsonWriter;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import com.oracle.coherence.io.json.internal.JsonPortableException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class ThrowableConverter
implements Converter<Throwable> {
    public static final ThrowableConverter INSTANCE = new ThrowableConverter();

    protected ThrowableConverter() {
    }

    @Override
    public void serialize(Throwable throwable, ObjectWriter writer, Context context) throws Exception {
        ((JsonWriter)writer).clearMetadata();
        writer.beginObject();
        writer.writeMetadata("class", JsonPortableException.class.getSimpleName());
        writer.writeString("name", throwable.getClass().getName());
        writer.writeString("message", throwable.getMessage());
        writer.writeName("stack").beginArray();
        for (StackTraceElement element : throwable.getStackTrace()) {
            writer.writeValue(element.toString());
        }
        writer.endArray();
        writer.endObject();
    }

    @Override
    public Throwable deserialize(ObjectReader in, Context context) throws Exception {
        String name = JsonPortableException.class.getName();
        String message = null;
        ArrayList<String> stack = new ArrayList<String>();
        in.beginObject();
        while (in.hasNext()) {
            in.next();
            switch (in.name()) {
                case "name": {
                    name = in.valueAsString();
                    break;
                }
                case "message": {
                    message = in.valueAsString();
                    break;
                }
                case "stack": {
                    in.beginArray();
                    while (in.hasNext()) {
                        in.next();
                        stack.add(in.valueAsString());
                    }
                    in.endArray();
                    break;
                }
            }
        }
        return new JsonPortableException(name, message, stack.toArray(new String[0]));
    }

    public static class Factory
    implements com.oracle.coherence.io.json.genson.Factory<Converter<? extends Throwable>> {
        public static final Factory INSTANCE = new Factory();

        protected Factory() {
        }

        @Override
        public Converter<? extends Throwable> create(Type type, Genson genson) {
            return INSTANCE;
        }
    }
}

