/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.ext.jsr353;

import com.oracle.coherence.io.json.genson.ext.jsr353.GensonJsonBuilderFactory;
import com.oracle.coherence.io.json.genson.ext.jsr353.GensonJsonGeneratorFactory;
import com.oracle.coherence.io.json.genson.ext.jsr353.GensonJsonParserFactory;
import com.oracle.coherence.io.json.genson.ext.jsr353.GensonJsonReaderFactory;
import com.oracle.coherence.io.json.genson.ext.jsr353.GensonJsonWriterFactory;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;

public class GensonJsonProvider
extends JsonProvider {
    private final GensonJsonGeneratorFactory generatorFactory = new GensonJsonGeneratorFactory();
    private final GensonJsonParserFactory parserFactory = new GensonJsonParserFactory();
    private final GensonJsonReaderFactory readerFactory = new GensonJsonReaderFactory(Collections.singletonMap("GensonJsonParser.strictDoubleParse", true));
    private final GensonJsonWriterFactory writerFactory = new GensonJsonWriterFactory();
    private final GensonJsonBuilderFactory builderFactory = new GensonJsonBuilderFactory();

    public JsonParser createParser(Reader reader) {
        return this.parserFactory.createParser(reader);
    }

    public JsonParser createParser(InputStream in) {
        return this.parserFactory.createParser(in);
    }

    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        return new GensonJsonParserFactory(config);
    }

    public JsonGenerator createGenerator(Writer writer) {
        return this.generatorFactory.createGenerator(writer);
    }

    public JsonGenerator createGenerator(OutputStream out) {
        return this.generatorFactory.createGenerator(out);
    }

    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        return new GensonJsonGeneratorFactory(config);
    }

    public JsonReader createReader(Reader reader) {
        return this.readerFactory.createReader(reader);
    }

    public JsonReader createReader(InputStream in) {
        return this.readerFactory.createReader(in);
    }

    public JsonWriter createWriter(Writer writer) {
        return this.writerFactory.createWriter(writer);
    }

    public JsonWriter createWriter(OutputStream out) {
        return this.writerFactory.createWriter(out);
    }

    public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        return new GensonJsonWriterFactory(config);
    }

    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        return new GensonJsonReaderFactory(config);
    }

    public JsonObjectBuilder createObjectBuilder() {
        return this.builderFactory.createObjectBuilder();
    }

    public JsonArrayBuilder createArrayBuilder() {
        return this.builderFactory.createArrayBuilder();
    }

    public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        return this.builderFactory;
    }
}

