/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.reflect;

import com.oracle.coherence.io.json.genson.JsonBindingException;
import com.oracle.coherence.io.json.genson.Trilean;
import com.oracle.coherence.io.json.genson.annotation.JsonCreator;
import com.oracle.coherence.io.json.genson.annotation.JsonIgnore;
import com.oracle.coherence.io.json.genson.annotation.JsonProperty;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import com.oracle.coherence.io.json.genson.reflect.VisibilityFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public interface BeanMutatorAccessorResolver {
    public Trilean isCreator(Constructor<?> var1, Class<?> var2);

    public Trilean isCreator(Method var1, Class<?> var2);

    public boolean isCreatorAnnotated(Constructor<?> var1);

    public boolean isCreatorAnnotated(Method var1);

    public Trilean isAccessor(Field var1, Class<?> var2);

    public Trilean isAccessor(Method var1, Class<?> var2);

    public Trilean isMutator(Field var1, Class<?> var2);

    public Trilean isMutator(Method var1, Class<?> var2);

    public static class StandardMutaAccessorResolver
    implements BeanMutatorAccessorResolver {
        private final VisibilityFilter fieldVisibilityFilter;
        private final VisibilityFilter methodVisibilityFilter;
        private final VisibilityFilter creatorVisibilityFilter;

        public StandardMutaAccessorResolver() {
            this(VisibilityFilter.PACKAGE_PUBLIC, VisibilityFilter.PACKAGE_PUBLIC, VisibilityFilter.PACKAGE_PUBLIC);
        }

        public StandardMutaAccessorResolver(VisibilityFilter fieldVisibilityFilter, VisibilityFilter methodVisibilityFilter, VisibilityFilter creatorVisibilityFilter) {
            this.fieldVisibilityFilter = fieldVisibilityFilter;
            this.methodVisibilityFilter = methodVisibilityFilter;
            this.creatorVisibilityFilter = creatorVisibilityFilter;
        }

        @Override
        public Trilean isAccessor(Field field, Class<?> fromClass) {
            return Trilean.valueOf(this.fieldVisibilityFilter.isVisible(field));
        }

        @Override
        public Trilean isAccessor(Method method, Class<?> fromClass) {
            if (!method.isBridge()) {
                String name = method.getName();
                int len = name.length();
                if (this.methodVisibilityFilter.isVisible(method) && (len > 3 && name.startsWith("get") || len > 2 && name.startsWith("is") && (TypeUtil.match(TypeUtil.expandType(method.getGenericReturnType(), fromClass), Boolean.class, false) || TypeUtil.match(method.getGenericReturnType(), Boolean.TYPE, false))) && method.getParameterTypes().length == 0) {
                    return Trilean.TRUE;
                }
            }
            return Trilean.FALSE;
        }

        @Override
        public Trilean isCreator(Constructor<?> constructor, Class<?> fromClass) {
            return Trilean.valueOf(this.creatorVisibilityFilter.isVisible(constructor));
        }

        @Override
        public Trilean isCreator(Method method, Class<?> fromClass) {
            return Trilean.FALSE;
        }

        @Override
        public boolean isCreatorAnnotated(Constructor<?> constructor) {
            return false;
        }

        @Override
        public boolean isCreatorAnnotated(Method method) {
            return false;
        }

        @Override
        public Trilean isMutator(Field field, Class<?> fromClass) {
            return Trilean.valueOf(this.fieldVisibilityFilter.isVisible(field));
        }

        @Override
        public Trilean isMutator(Method method, Class<?> fromClass) {
            if (!method.isBridge() && this.methodVisibilityFilter.isVisible(method) && method.getName().length() > 3 && method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE) {
                return Trilean.TRUE;
            }
            return Trilean.FALSE;
        }
    }

    public static class GensonAnnotationPropertyResolver
    extends AnnotationPropertyResolver {
        public GensonAnnotationPropertyResolver() {
            super(JsonProperty.class, JsonIgnore.class, JsonCreator.class);
        }

        @Override
        protected boolean ignore(AccessibleObject property, Class<?> ofType, boolean forSerialization) {
            if (super.ignore(property, ofType, forSerialization)) {
                JsonIgnore ignore = this.find(JsonIgnore.class, property, property.getClass());
                return forSerialization ? !ignore.serialize() : !ignore.deserialize();
            }
            return false;
        }

        @Override
        protected boolean include(AccessibleObject property, Class<?> ofType, boolean forSerialization) {
            if (super.include(property, ofType, forSerialization)) {
                JsonProperty prop = this.find(JsonProperty.class, property, property.getClass());
                return forSerialization ? prop.serialize() : prop.deserialize();
            }
            return false;
        }
    }

    public static class CompositeResolver
    implements BeanMutatorAccessorResolver {
        private List<BeanMutatorAccessorResolver> components;

        public CompositeResolver(List<BeanMutatorAccessorResolver> components) {
            if (components == null || components.isEmpty()) {
                throw new IllegalArgumentException("The composite resolver must have at least one resolver as component!");
            }
            this.components = new LinkedList<BeanMutatorAccessorResolver>(components);
        }

        public CompositeResolver add(BeanMutatorAccessorResolver ... resolvers) {
            this.components.addAll(0, Arrays.asList(resolvers));
            return this;
        }

        @Override
        public Trilean isAccessor(Field field, Class<?> fromClass) {
            Trilean resolved = Trilean.UNKNOWN;
            Iterator<BeanMutatorAccessorResolver> it = this.components.iterator();
            while (resolved == null || resolved.equals((Object)Trilean.UNKNOWN) && it.hasNext()) {
                resolved = it.next().isAccessor(field, fromClass);
            }
            return resolved;
        }

        @Override
        public Trilean isAccessor(Method method, Class<?> fromClass) {
            Trilean resolved = Trilean.UNKNOWN;
            Iterator<BeanMutatorAccessorResolver> it = this.components.iterator();
            while (resolved == null || resolved.equals((Object)Trilean.UNKNOWN) && it.hasNext()) {
                resolved = it.next().isAccessor(method, fromClass);
            }
            return resolved;
        }

        @Override
        public Trilean isCreator(Constructor<?> constructor, Class<?> fromClass) {
            Trilean resolved = Trilean.UNKNOWN;
            Iterator<BeanMutatorAccessorResolver> it = this.components.iterator();
            while (resolved == null || resolved.equals((Object)Trilean.UNKNOWN) && it.hasNext()) {
                resolved = it.next().isCreator(constructor, fromClass);
            }
            return resolved;
        }

        @Override
        public Trilean isCreator(Method method, Class<?> fromClass) {
            Trilean resolved = Trilean.UNKNOWN;
            Iterator<BeanMutatorAccessorResolver> it = this.components.iterator();
            while (resolved == null || resolved.equals((Object)Trilean.UNKNOWN) && it.hasNext()) {
                resolved = it.next().isCreator(method, fromClass);
            }
            return resolved;
        }

        @Override
        public boolean isCreatorAnnotated(Constructor<?> constructor) {
            boolean resolved = false;
            Iterator<BeanMutatorAccessorResolver> it = this.components.iterator();
            while (!resolved && it.hasNext()) {
                resolved = it.next().isCreatorAnnotated(constructor);
            }
            return resolved;
        }

        @Override
        public boolean isCreatorAnnotated(Method method) {
            boolean resolved = false;
            Iterator<BeanMutatorAccessorResolver> it = this.components.iterator();
            while (!resolved && it.hasNext()) {
                resolved = it.next().isCreatorAnnotated(method);
            }
            return resolved;
        }

        @Override
        public Trilean isMutator(Field field, Class<?> fromClass) {
            Trilean resolved = Trilean.UNKNOWN;
            Iterator<BeanMutatorAccessorResolver> it = this.components.iterator();
            while (resolved == null || resolved.equals((Object)Trilean.UNKNOWN) && it.hasNext()) {
                resolved = it.next().isMutator(field, fromClass);
            }
            return resolved;
        }

        @Override
        public Trilean isMutator(Method method, Class<?> fromClass) {
            Trilean resolved = Trilean.UNKNOWN;
            Iterator<BeanMutatorAccessorResolver> it = this.components.iterator();
            while (resolved == null || resolved.equals((Object)Trilean.UNKNOWN) && it.hasNext()) {
                resolved = it.next().isMutator(method, fromClass);
            }
            return resolved;
        }
    }

    public static class AnnotationPropertyResolver
    implements BeanMutatorAccessorResolver {
        protected Class<? extends Annotation> propertyAnnotation;
        protected Class<? extends Annotation> exclusionAnnotation;
        protected Class<? extends Annotation> creatorAnnotation;

        public AnnotationPropertyResolver(Class<? extends Annotation> propertyAnnotation, Class<? extends Annotation> exclusionAnnotation, Class<? extends Annotation> creatorAnnotation) {
            this.propertyAnnotation = propertyAnnotation;
            this.exclusionAnnotation = exclusionAnnotation;
            this.creatorAnnotation = creatorAnnotation;
        }

        @Override
        public Trilean isCreator(Constructor<?> constructor, Class<?> fromClass) {
            if (this.creatorAnnotation != null && this.find(this.creatorAnnotation, constructor, fromClass) != null) {
                return Trilean.TRUE;
            }
            return Trilean.UNKNOWN;
        }

        @Override
        public Trilean isCreator(Method method, Class<?> fromClass) {
            if (this.creatorAnnotation != null && this.find(this.creatorAnnotation, method, fromClass) != null) {
                if (Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())) {
                    return Trilean.TRUE;
                }
                throw new JsonBindingException(String.format("Method [%s] annotated with [%s] must be static!", method.toGenericString(), this.creatorAnnotation));
            }
            return Trilean.UNKNOWN;
        }

        @Override
        public boolean isCreatorAnnotated(Constructor<?> constructor) {
            if (constructor == null || this.creatorAnnotation == null) {
                return false;
            }
            return constructor.getAnnotation(this.creatorAnnotation) != null;
        }

        @Override
        public boolean isCreatorAnnotated(Method method) {
            if (method == null || this.creatorAnnotation == null) {
                return false;
            }
            return method.getAnnotation(this.creatorAnnotation) != null;
        }

        @Override
        public Trilean isAccessor(Field field, Class<?> fromClass) {
            if (field.isSynthetic() || this.ignore(field, field.getType(), true)) {
                return Trilean.FALSE;
            }
            if (this.include(field, field.getType(), true)) {
                return Trilean.TRUE;
            }
            return Trilean.UNKNOWN;
        }

        @Override
        public Trilean isAccessor(Method method, Class<?> fromClass) {
            if (this.ignore(method, method.getReturnType(), true)) {
                return Trilean.FALSE;
            }
            String name = this.getGetterName(method);
            if (name != null) {
                if (this.include(method, method.getReturnType(), true)) {
                    return Trilean.TRUE;
                }
                if (this.find(this.exclusionAnnotation, fromClass, "set" + name, method.getReturnType()) != null) {
                    return Trilean.FALSE;
                }
            }
            return Trilean.UNKNOWN;
        }

        @Override
        public Trilean isMutator(Field field, Class<?> fromClass) {
            if (field.isSynthetic() || this.ignore(field, field.getType(), false)) {
                return Trilean.FALSE;
            }
            if (this.include(field, field.getType(), false)) {
                return Trilean.TRUE;
            }
            return Trilean.UNKNOWN;
        }

        @Override
        public Trilean isMutator(Method method, Class<?> fromClass) {
            Class<Object> paramClass;
            Class clazz = paramClass = method.getParameterTypes().length == 1 ? method.getParameterTypes()[0] : Object.class;
            if (this.ignore(method, paramClass, false)) {
                return Trilean.FALSE;
            }
            String name = this.getSetterName(method);
            if (name != null) {
                if (this.include(method, method.getReturnType(), false)) {
                    return Trilean.TRUE;
                }
                if (this.find(this.exclusionAnnotation, fromClass, "get" + name, new Class[0]) != null) {
                    return Trilean.FALSE;
                }
                if ((paramClass.equals(Boolean.TYPE) || paramClass.equals(Boolean.class)) && this.find(this.exclusionAnnotation, fromClass, "is" + name, new Class[0]) != null) {
                    return Trilean.FALSE;
                }
            }
            return Trilean.UNKNOWN;
        }

        protected String getGetterName(Method method) {
            String name = method.getName();
            Class<?> returnType = method.getReturnType();
            if (name.startsWith("get") && name.length() > 3) {
                return name.substring(3);
            }
            if (name.startsWith("is") && name.length() > 2 && (returnType == Boolean.TYPE || returnType == Boolean.class)) {
                return name.substring(2);
            }
            return null;
        }

        protected String getSetterName(Method method) {
            String name = method.getName();
            if (name.startsWith("set") && name.length() > 3) {
                return name.substring(3);
            }
            return null;
        }

        protected boolean ignore(AccessibleObject property, Class<?> ofType, boolean forSerialization) {
            return this.find(this.exclusionAnnotation, property, ofType) != null;
        }

        protected boolean include(AccessibleObject property, Class<?> ofType, boolean forSerialization) {
            return this.find(this.propertyAnnotation, property, ofType) != null;
        }

        protected <A extends Annotation> A find(Class<A> annotation, AccessibleObject onObject, Class<?> onClass) {
            A ann = onObject.getAnnotation(annotation);
            if (ann != null) {
                return ann;
            }
            return this.find(annotation, onClass);
        }

        protected <A extends Annotation> A find(Class<A> annotation, Class<?> onClass) {
            A ann = onClass.getAnnotation(annotation);
            if (ann == null && onClass.getPackage() != null) {
                ann = onClass.getPackage().getAnnotation(annotation);
            }
            return ann;
        }

        protected <A extends Annotation> A find(Class<A> annotation, Class<?> inClass, String methodName, Class<?> ... parameterTypes) {
            block2: for (Class<?> clazz = inClass; clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    for (Method m : clazz.getDeclaredMethods()) {
                        if (!m.getName().equals(methodName) || !Arrays.equals(m.getParameterTypes(), parameterTypes)) continue;
                        if (!m.isAnnotationPresent(annotation)) continue block2;
                        return m.getAnnotation(annotation);
                    }
                    continue;
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }

    public static class PropertyBaseResolver
    implements BeanMutatorAccessorResolver {
        @Override
        public Trilean isAccessor(Field field, Class<?> fromClass) {
            return Trilean.UNKNOWN;
        }

        @Override
        public Trilean isAccessor(Method method, Class<?> fromClass) {
            return Trilean.UNKNOWN;
        }

        @Override
        public Trilean isCreator(Constructor<?> constructor, Class<?> fromClass) {
            return Trilean.UNKNOWN;
        }

        @Override
        public Trilean isCreator(Method method, Class<?> fromClass) {
            return Trilean.UNKNOWN;
        }

        @Override
        public boolean isCreatorAnnotated(Constructor<?> constructor) {
            return false;
        }

        @Override
        public boolean isCreatorAnnotated(Method method) {
            return false;
        }

        @Override
        public Trilean isMutator(Field field, Class<?> fromClass) {
            return Trilean.UNKNOWN;
        }

        @Override
        public Trilean isMutator(Method method, Class<?> fromClass) {
            return Trilean.UNKNOWN;
        }
    }
}

