/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.ext.jsr353;

import com.oracle.coherence.io.json.genson.ext.jsr353.GensonJsonGeneratorFactory;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;

public class GensonJsonWriterFactory
implements JsonWriterFactory {
    private final JsonGeneratorFactory generatorFactory;

    public GensonJsonWriterFactory() {
        this(Collections.emptyMap());
    }

    public GensonJsonWriterFactory(Map<String, ?> config) {
        this.generatorFactory = new GensonJsonGeneratorFactory(config);
    }

    public JsonWriter createWriter(final Writer writer) {
        return new JsonWriter(){
            private final JsonGenerator generator;
            private boolean written;
            {
                this.generator = GensonJsonWriterFactory.this.generatorFactory.createGenerator(writer);
                this.written = false;
            }

            public void writeArray(JsonArray array) {
                this.checkWritten();
                this.generator.write((JsonValue)array);
            }

            public void writeObject(JsonObject object) {
                this.checkWritten();
                this.generator.write((JsonValue)object);
            }

            public void write(JsonStructure value) {
                this.checkWritten();
                this.generator.write((JsonValue)value);
            }

            public void close() {
                this.generator.close();
            }

            private void checkWritten() {
                if (this.written) {
                    throw new IllegalStateException();
                }
                this.written = true;
            }
        };
    }

    public JsonWriter createWriter(OutputStream out) {
        try {
            return this.createWriter(new OutputStreamWriter(out, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonException("Charset UTF-8 is not supported.", (Throwable)e);
        }
    }

    public JsonWriter createWriter(OutputStream out, Charset charset) {
        return this.createWriter(new OutputStreamWriter(out, charset));
    }

    public Map<String, ?> getConfigInUse() {
        return this.generatorFactory.getConfigInUse();
    }
}

