/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public final class EncodingAwareReaderFactory {
    public Reader createReader(InputStream is) throws IOException {
        byte[] bytes = new byte[4];
        int len = this.fetchBytes(bytes, is);
        if (len < 1) {
            return new InputStreamReader(is);
        }
        int bits_32 = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        UTFEncoding encoding = UTFEncoding.UNKNOWN;
        boolean hasBOM = false;
        if (len == 4) {
            encoding = this.detectEncodingFromBOM(bits_32);
        }
        if (encoding == UTFEncoding.UNKNOWN) {
            encoding = this.detectEncodingUsingJSONSpec(bits_32);
        } else {
            hasBOM = true;
        }
        if (encoding == UTFEncoding.UNKNOWN) {
            throw new UnsupportedEncodingException("The encoding could not be detected from the stream.");
        }
        int usedBOMBytes = hasBOM ? len - (4 - encoding.bytes) : 0;
        int bytesToUnread = len - usedBOMBytes;
        if (bytesToUnread == 0) {
            return new InputStreamReader(is, encoding.encoding());
        }
        PushbackInputStream pis = new PushbackInputStream(is, bytesToUnread);
        pis.unread(bytes, usedBOMBytes, bytesToUnread);
        return new InputStreamReader((InputStream)pis, encoding.encoding());
    }

    private UTFEncoding detectEncodingFromBOM(int bits_32) {
        int bits_16 = bits_32 >>> 16;
        if (bits_32 == 65279) {
            return UTFEncoding.UTF_32BE;
        }
        if (bits_32 == -131072) {
            return UTFEncoding.UTF_32LE;
        }
        if (bits_16 == 65279) {
            return UTFEncoding.UTF_16BE;
        }
        if (bits_16 == 65534) {
            return UTFEncoding.UTF_16LE;
        }
        if (bits_32 >>> 8 == 0xEFBBBF) {
            return UTFEncoding.UTF_8;
        }
        return UTFEncoding.UNKNOWN;
    }

    private UTFEncoding detectEncodingUsingJSONSpec(int bits_32) {
        int bits_16 = bits_32 >>> 16;
        if (bits_32 >>> 8 == 0) {
            return UTFEncoding.UTF_32BE;
        }
        if ((bits_32 & 0xFFFFFF) == 0) {
            return UTFEncoding.UTF_32LE;
        }
        if ((bits_16 & 0xFF00) == 0) {
            return UTFEncoding.UTF_16BE;
        }
        if ((bits_16 & 0xFF) == 0) {
            return UTFEncoding.UTF_16LE;
        }
        return UTFEncoding.UTF_8;
    }

    private int fetchBytes(byte[] bytes, InputStream is) throws IOException {
        int start;
        int bytesRead;
        for (start = 0; start < bytes.length - 1 && (bytesRead = is.read(bytes, start, bytes.length - start)) > -1; start += bytesRead) {
        }
        return start;
    }

    static enum UTFEncoding {
        UTF_32BE(4),
        UTF_32LE(4),
        UTF_16BE(2),
        UTF_16LE(2),
        UTF_8(1),
        UNKNOWN(-1);

        final int bytes;

        private UTFEncoding(int bytes) {
            this.bytes = bytes;
        }

        public String encoding() {
            return this.name().replace('_', '-');
        }
    }
}

