/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.reflect;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.JsonBindingException;
import com.oracle.coherence.io.json.genson.reflect.BeanCreator;
import com.oracle.coherence.io.json.genson.reflect.BeanProperty;
import com.oracle.coherence.io.json.genson.reflect.PropertyAccessor;
import com.oracle.coherence.io.json.genson.reflect.PropertyMutator;
import com.oracle.coherence.io.json.genson.reflect.RuntimePropertyFilter;
import com.oracle.coherence.io.json.genson.reflect.UnknownPropertyHandler;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import com.oracle.coherence.io.json.genson.stream.ValueType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class BeanDescriptor<T>
implements Converter<T> {
    final Class<?> fromDeclaringClass;
    final Class<T> ofClass;
    final Map<String, PropertyMutator> mutableProperties;
    final List<PropertyAccessor> accessibleProperties;
    final boolean failOnMissingProperty;
    final BeanCreator creator;
    private final boolean _noArgCtr;
    private static final Object MISSING = new Object();
    private Object[] globalCreatorArgs;
    private static final Comparator<BeanProperty> _readablePropsComparator = new Comparator<BeanProperty>(){

        @Override
        public int compare(BeanProperty o1, BeanProperty o2) {
            return o1.name.compareToIgnoreCase(o2.name);
        }
    };

    public BeanDescriptor(Class<T> forClass, Class<?> fromDeclaringClass, List<PropertyAccessor> readableBps, Map<String, PropertyMutator> writableBps, BeanCreator creator, boolean failOnMissingProperty) {
        this.ofClass = forClass;
        this.fromDeclaringClass = fromDeclaringClass;
        this.creator = creator;
        this.failOnMissingProperty = failOnMissingProperty;
        this.mutableProperties = writableBps;
        Collections.sort(readableBps, _readablePropsComparator);
        this.accessibleProperties = Collections.unmodifiableList(readableBps);
        if (this.creator != null) {
            this._noArgCtr = this.creator.parameters.size() == 0;
            this.globalCreatorArgs = new Object[creator.parameters.size()];
            Arrays.fill(this.globalCreatorArgs, MISSING);
        } else {
            this._noArgCtr = false;
        }
    }

    public boolean isReadable() {
        return !this.accessibleProperties.isEmpty();
    }

    public boolean isWritable() {
        return this.creator != null;
    }

    @Override
    public void serialize(T obj, ObjectWriter writer, Context ctx) {
        RuntimePropertyFilter runtimePropertyFilter = ctx.genson.runtimePropertyFilter();
        UnknownPropertyHandler unknownPropertyHandler = ctx.genson.unknownPropertyHandler();
        writer.beginObject();
        for (PropertyAccessor accessor : this.accessibleProperties) {
            if (!runtimePropertyFilter.shouldInclude(accessor, ctx)) continue;
            accessor.serialize(obj, writer, ctx);
        }
        if (unknownPropertyHandler != null) {
            unknownPropertyHandler.writeUnknownProperties(obj, writer, ctx);
        }
        writer.endObject();
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) {
        T bean = null;
        if (this._noArgCtr) {
            bean = this.ofClass.cast(this.creator.create(new Object[0]));
            this.deserialize(bean, reader, ctx);
        } else {
            if (this.creator == null) {
                int modifiers;
                Class<?> defaultObjectClass = ctx.genson.defaultClass(ValueType.OBJECT);
                Exception thrown = null;
                if (this.ofClass.isAssignableFrom(defaultObjectClass) && !Modifier.isAbstract(modifiers = defaultObjectClass.getModifiers()) && !Modifier.isInterface(modifiers) && Modifier.isPublic(modifiers)) {
                    try {
                        Converter c = ctx.genson.provideConverter(ctx.genson.defaultClass(ValueType.OBJECT));
                        if (c != null) {
                            return c.deserialize(reader, ctx);
                        }
                    }
                    catch (Exception e) {
                        thrown = e;
                    }
                }
                String message = "No constructor has been found for type " + this.ofClass;
                if (null != thrown) {
                    throw new JsonBindingException(message, thrown);
                }
                throw new JsonBindingException(message);
            }
            bean = this._deserWithCtrArgs(reader, ctx);
        }
        return bean;
    }

    public void deserialize(T into, ObjectReader reader, Context ctx) {
        RuntimePropertyFilter runtimePropertyFilter = ctx.genson.runtimePropertyFilter();
        UnknownPropertyHandler unknownPropertyHandler = ctx.genson.unknownPropertyHandler();
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            String propName = reader.name();
            PropertyMutator mutator = this.mutableProperties.get(propName);
            if (mutator != null) {
                if (runtimePropertyFilter.shouldInclude(mutator, ctx)) {
                    mutator.deserialize(into, reader, ctx);
                    continue;
                }
                reader.skipValue();
                continue;
            }
            if (unknownPropertyHandler != null) {
                unknownPropertyHandler.readUnknownProperty(propName, reader, ctx).accept(into);
                continue;
            }
            if (this.failOnMissingProperty) {
                throw this.missingPropertyException(propName);
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    protected T _deserWithCtrArgs(ObjectReader reader, Context ctx) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList unknownProperties = new ArrayList();
        RuntimePropertyFilter runtimePropertyFilter = ctx.genson.runtimePropertyFilter();
        UnknownPropertyHandler unknownPropertyHandler = ctx.genson.unknownPropertyHandler();
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            String propName = reader.name();
            PropertyMutator muta = this.mutableProperties.get(propName);
            if (muta != null) {
                if (runtimePropertyFilter.shouldInclude(muta, ctx)) {
                    Object param = muta.deserialize(reader, ctx);
                    names.add(propName);
                    values.add(param);
                    continue;
                }
                reader.skipValue();
                continue;
            }
            if (unknownPropertyHandler != null) {
                Consumer callback2 = unknownPropertyHandler.readUnknownProperty(propName, reader, ctx);
                unknownProperties.add(callback2);
                continue;
            }
            if (this.failOnMissingProperty) {
                throw this.missingPropertyException(propName);
            }
            reader.skipValue();
        }
        int size = names.size();
        int foundCtrParameters = 0;
        Object[] creatorArgs = (Object[])this.globalCreatorArgs.clone();
        String[] newNames = new String[size];
        Object[] newValues = new Object[size];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            BeanCreator.BeanCreatorProperty mp = this.creator.paramsAndAliases.get(names.get(i));
            if (mp != null) {
                creatorArgs[mp.index] = values.get(i);
                ++foundCtrParameters;
                continue;
            }
            newNames[j] = (String)names.get(i);
            newValues[j] = values.get(i);
            ++j;
        }
        if (foundCtrParameters < this.creator.parameters.size()) {
            this.updateWithDefaultValues(creatorArgs, ctx.genson);
        }
        Object bean = this.ofClass.cast(this.creator.create(creatorArgs));
        for (int i = 0; i < size; ++i) {
            PropertyMutator property = this.mutableProperties.get(newNames[i]);
            if (property == null) continue;
            property.mutate(bean, newValues[i]);
        }
        unknownProperties.forEach(callback -> callback.accept(bean));
        reader.endObject();
        return bean;
    }

    private void updateWithDefaultValues(Object[] creatorArgs, Genson genson) {
        block0: for (int i = 0; i < creatorArgs.length; ++i) {
            if (creatorArgs[i] != MISSING) continue;
            for (BeanCreator.BeanCreatorProperty property : this.creator.parameters.values()) {
                if (property.index != i) continue;
                creatorArgs[i] = genson.defaultValue(property.getRawClass());
                continue block0;
            }
        }
    }

    public Class<T> getOfClass() {
        return this.ofClass;
    }

    private JsonBindingException missingPropertyException(String name) {
        return new JsonBindingException("No matching property in " + this.getOfClass() + " for key " + name);
    }
}

