/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson;

import com.oracle.coherence.io.json.genson.BeanView;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.Operations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Context {
    public final Genson genson;
    private List<Class<? extends BeanView<?>>> views;
    private Map<String, Object> _ctxData = new HashMap<String, Object>();

    public Context(Genson genson) {
        this(genson, null);
    }

    public Context(Genson genson, List<Class<? extends BeanView<?>>> views) {
        Operations.checkNotNull(genson);
        this.genson = genson;
        this.views = views;
    }

    public boolean hasViews() {
        return this.views != null && !this.views.isEmpty();
    }

    public Context withView(Class<? extends BeanView<?>> view) {
        if (this.views == null) {
            this.views = new ArrayList();
        }
        this.views.add(view);
        return this;
    }

    public List<Class<? extends BeanView<?>>> views() {
        return this.views;
    }

    public Object store(String key, Object o) {
        Operations.checkNotNull(key);
        Object old = this._ctxData.get(key);
        this._ctxData.put(key, o);
        return old;
    }

    public <T> T get(String key, Class<T> valueType) {
        Operations.checkNotNull(key, valueType);
        return valueType.cast(this._ctxData.get(key));
    }

    public <T> T remove(String key, Class<T> valueType) {
        Operations.checkNotNull(key, valueType);
        T value = valueType.cast(this._ctxData.get(key));
        this._ctxData.remove(key);
        return value;
    }
}

