/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.convert;

import com.oracle.coherence.io.json.genson.BeanView;
import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.Wrapper;
import com.oracle.coherence.io.json.genson.annotation.HandleBeanView;
import com.oracle.coherence.io.json.genson.convert.ChainedFactory;
import com.oracle.coherence.io.json.genson.reflect.BeanDescriptor;
import com.oracle.coherence.io.json.genson.reflect.BeanViewDescriptorProvider;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import java.lang.reflect.Type;
import java.util.List;

public class BeanViewConverter<T>
extends Wrapper<Converter<T>>
implements Converter<T> {
    private final BeanViewDescriptorProvider provider;
    private final Type type;

    public BeanViewConverter(Type type, BeanViewDescriptorProvider provider, Converter<T> next) {
        super(next);
        this.provider = provider;
        this.type = type;
    }

    protected Class<? extends BeanView<T>> findViewFor(Type type, List<Class<? extends BeanView<?>>> views) {
        for (Class<BeanView<?>> clazz : views) {
            Type searchedType = TypeUtil.lookupGenericType(BeanView.class, clazz);
            searchedType = TypeUtil.expandType(searchedType, clazz);
            if (!TypeUtil.match(type, searchedType = TypeUtil.typeOf(0, searchedType), false)) continue;
            return clazz;
        }
        return null;
    }

    @Override
    public void serialize(T obj, ObjectWriter writer, Context ctx) throws Exception {
        Class<BeanView<T>> viewClass;
        boolean handled = false;
        List<Class<BeanView<?>>> views = ctx.views();
        if (views != null && views.size() > 0 && (viewClass = this.findViewFor(this.type, views)) != null) {
            Type viewForType = TypeUtil.expandType(BeanView.class.getTypeParameters()[0], viewClass);
            Class<?> viewForClass = TypeUtil.getRawClass(viewForType);
            BeanDescriptor<?> descriptor = this.provider.provide(viewForClass, viewClass, ctx.genson);
            descriptor.serialize(obj, writer, ctx);
            handled = true;
        }
        if (!handled) {
            ((Converter)this.wrapped).serialize(obj, writer, ctx);
        }
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) throws Exception {
        Class<BeanView<T>> viewClass;
        if (ctx.hasViews() && (viewClass = this.findViewFor(this.type, ctx.views())) != null) {
            Type viewForType = TypeUtil.expandType(BeanView.class.getTypeParameters()[0], viewClass);
            Class<?> viewForClass = TypeUtil.getRawClass(viewForType);
            BeanDescriptor<?> descriptor = this.provider.provide(viewForClass, viewClass, ctx.genson);
            return (T)descriptor.deserialize(reader, ctx);
        }
        return ((Converter)this.wrapped).deserialize(reader, ctx);
    }

    public static class BeanViewConverterFactory
    extends ChainedFactory {
        private final BeanViewDescriptorProvider provider;

        public BeanViewConverterFactory(BeanViewDescriptorProvider provider) {
            this.provider = provider;
        }

        @Override
        protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
            if (!Wrapper.toAnnotatedElement(nextConverter).isAnnotationPresent(HandleBeanView.class)) {
                return new BeanViewConverter(type, this.provider, nextConverter);
            }
            return nextConverter;
        }
    }
}

