/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Versionable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class JsonObject
extends LinkedHashMap<String, Object>
implements Versionable<Integer>,
Externalizable,
ExternalizableLite {
    private static final long serialVersionUID = 336675295275632710L;
    private String m_sClassName;
    protected int m_nVersion;

    public JsonObject() {
    }

    public JsonObject(Map<String, ?> map) {
        super(map);
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    public boolean getBoolean(String name) {
        return (Boolean)this.get(name);
    }

    public Number getNumber(String name) {
        Object o = this.get(name);
        if (o instanceof String) {
            String num = (String)o;
            return num.contains(".") ? new BigDecimal(num) : new BigInteger(num);
        }
        return (Number)o;
    }

    public byte getByte(String name) {
        return this.getNumber(name).byteValue();
    }

    public short getShort(String name) {
        return this.getNumber(name).shortValue();
    }

    public int getInt(String name) {
        return this.getNumber(name).intValue();
    }

    public long getLong(String name) {
        return this.getNumber(name).longValue();
    }

    public float getFloat(String name) {
        return this.getNumber(name).floatValue();
    }

    public double getDouble(String name) {
        return this.getNumber(name).doubleValue();
    }

    public BigInteger getBigInteger(String name) {
        return (BigInteger)this.getNumber(name);
    }

    public BigDecimal getBigDecimal(String name) {
        return (BigDecimal)this.getNumber(name);
    }

    public JsonObject set(String name, Object value) {
        this.put(name, value);
        return this;
    }

    public String getClassName() {
        return this.m_sClassName;
    }

    public void setClassName(String className) {
        this.m_sClassName = className;
    }

    public Integer getVersionIndicator() {
        return this.m_nVersion;
    }

    public void incrementVersion() {
        ++this.m_nVersion;
    }

    public boolean isVersioned() {
        return this.m_nVersion > 0;
    }

    public int getVersion() {
        return this.m_nVersion;
    }

    public JsonObject setVersion(int version) {
        this.m_nVersion = version;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonObject)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonObject that = (JsonObject)o;
        return this.m_nVersion == that.m_nVersion;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.m_nVersion);
    }

    @Override
    public String toString() {
        return "JsonObject{version=" + this.m_nVersion + ", properties=" + super.toString() + "}";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        if (this.size() > 0) {
            throw new NotActiveException();
        }
        this.m_nVersion = ExternalizableHelper.readInt((DataInput)in);
        int c = ExternalizableHelper.readInt((DataInput)in);
        for (int i = 0; i < c; ++i) {
            String key = (String)ExternalizableHelper.readObject((DataInput)in);
            Object value = ExternalizableHelper.readObject((DataInput)in);
            this.put(key, value);
        }
    }

    @Override
    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_nVersion);
        int c = this.size();
        ExternalizableHelper.writeInt((DataOutput)out, (int)c);
        if (c == 0) {
            return;
        }
        Map.Entry[] aEntry = this.entrySet().toArray(new Map.Entry[c]);
        for (int i = 0; i < c; ++i) {
            Map.Entry entry = aEntry[i];
            ExternalizableHelper.writeObject((DataOutput)out, entry.getKey());
            ExternalizableHelper.writeObject((DataOutput)out, entry.getValue());
        }
    }

    public void readExternal(DataInput in) throws IOException {
        if (this.size() > 0) {
            throw new NotActiveException();
        }
        this.m_sClassName = ExternalizableHelper.readSafeUTF((DataInput)in);
        this.m_nVersion = ExternalizableHelper.readInt((DataInput)in);
        int c = ExternalizableHelper.readInt((DataInput)in);
        if (c == 0) {
            return;
        }
        boolean fLite = in.readBoolean();
        ObjectInput inObj = fLite ? null : ExternalizableHelper.getObjectInput((DataInput)in, null);
        JsonObject map = this;
        for (int i = 0; i < c; ++i) {
            Object value;
            String name;
            if (fLite) {
                name = (String)ExternalizableHelper.readObject((DataInput)in);
                value = ExternalizableHelper.readObject((DataInput)in);
            } else {
                try {
                    name = (String)inObj.readObject();
                    value = inObj.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("readObject failed: " + e + "\n" + Base.getStackTrace((Throwable)e));
                }
            }
            map.put(name, value);
        }
    }

    public synchronized void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.m_sClassName);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_nVersion);
        int c = this.size();
        ExternalizableHelper.writeInt((DataOutput)out, (int)c);
        if (c == 0) {
            return;
        }
        Map.Entry[] aEntry = this.entrySet().toArray(new Map.Entry[c]);
        boolean fLite = true;
        for (int i = 0; i < c; ++i) {
            Map.Entry entry = aEntry[i];
            if (ExternalizableHelper.getStreamFormat(entry.getKey()) != 11 && ExternalizableHelper.getStreamFormat(entry.getValue()) != 11) continue;
            fLite = false;
            break;
        }
        out.writeBoolean(fLite);
        ObjectOutput outObj = fLite ? null : ExternalizableHelper.getObjectOutput((DataOutput)out);
        for (int i = 0; i < c; ++i) {
            Map.Entry entry = aEntry[i];
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (fLite) {
                ExternalizableHelper.writeObject((DataOutput)out, (Object)name);
                ExternalizableHelper.writeObject((DataOutput)out, value);
                continue;
            }
            outObj.writeObject(name);
            outObj.writeObject(value);
        }
        if (outObj != null) {
            outObj.close();
        }
    }

    public static class Serializer
    implements PofSerializer<JsonObject> {
        public void serialize(PofWriter out, JsonObject value) throws IOException {
            out.writeString(0, value.m_sClassName);
            out.writeInt(1, value.m_nVersion);
            out.writeMap(2, (Map)value);
            out.writeRemainder(null);
        }

        public JsonObject deserialize(PofReader in) throws IOException {
            try {
                JsonObject obj = (JsonObject)in.getPofContext().getClass(in.getUserTypeId()).newInstance();
                obj.m_sClassName = in.readString(0);
                obj.m_nVersion = in.readInt(1);
                in.readMap(2, (Map)obj);
                in.readRemainder();
                return obj;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

