/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.datetime;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import java.lang.reflect.Type;
import java.time.ZoneId;

class ZoneIdConverter<E extends ZoneId>
implements Converter<E> {
    ZoneIdConverter() {
    }

    @Override
    public void serialize(E object, ObjectWriter writer, Context ctx) throws Exception {
        writer.beginObject().writeString("zoneId", ((ZoneId)object).getId()).endObject();
    }

    @Override
    public E deserialize(ObjectReader reader, Context ctx) throws Exception {
        String zoneId = ZoneId.systemDefault().getId();
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            String name = reader.name();
            if (!"zoneId".equals(name)) continue;
            zoneId = reader.valueAsString();
        }
        reader.endObject();
        return (E)ZoneId.of(zoneId);
    }

    public static final class Factory
    implements com.oracle.coherence.io.json.genson.Factory<Converter<? extends ZoneId>> {
        @Override
        public Converter<? extends ZoneId> create(Type type, Genson genson) {
            return new ZoneIdConverter();
        }
    }
}

