/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.internal;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.Wrapper;
import com.oracle.coherence.io.json.genson.convert.ChainedFactory;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import com.tangosol.io.Serializer;
import com.tangosol.util.ExternalizableHelper;
import java.lang.reflect.Type;

public class SerializationSupportConverter
extends Wrapper<Converter<Object>>
implements Converter<Object> {
    protected final Serializer f_serializer;

    protected SerializationSupportConverter(Converter<Object> nextConverter, Serializer serializer) {
        super(nextConverter);
        this.f_serializer = serializer;
    }

    @Override
    public void serialize(Object object, ObjectWriter writer, Context ctx) throws Exception {
        object = ExternalizableHelper.replace((Object)object);
        ((Converter)this.wrapped).serialize(object, writer, ctx);
    }

    @Override
    public Object deserialize(ObjectReader reader, Context ctx) throws Exception {
        Object object = ((Converter)this.wrapped).deserialize(reader, ctx);
        return ExternalizableHelper.realize(object, (Serializer)this.f_serializer);
    }

    public static class Factory
    extends ChainedFactory {
        protected final Serializer f_serializer;

        public Factory(Serializer serializer) {
            this.f_serializer = serializer;
        }

        @Override
        protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
            return new SerializationSupportConverter(nextConverter, this.f_serializer);
        }
    }
}

