/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.ext.jsr353;

import com.oracle.coherence.io.json.genson.stream.JsonStreamException;
import com.oracle.coherence.io.json.genson.stream.JsonType;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ValueType;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.NoSuchElementException;
import javax.json.JsonException;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;

public class GensonJsonParser
implements JsonParser {
    public static final String STRICT_DOUBLE_PARSE = "GensonJsonParser.strictDoubleParse";
    private boolean parseKey = false;
    private final ObjectReader reader;

    public GensonJsonParser(ObjectReader reader) {
        this.reader = reader;
    }

    public boolean hasNext() {
        try {
            return this.reader.hasNext() || this.reader.enclosingType() != JsonType.EMPTY;
        }
        catch (JsonStreamException e) {
            throw this._wrapException(e);
        }
    }

    private JsonParser.Event currentValue(ValueType type) {
        if (type == ValueType.ARRAY) {
            this.reader.beginArray();
            return JsonParser.Event.START_ARRAY;
        }
        if (type == ValueType.OBJECT) {
            this.reader.beginObject();
            return JsonParser.Event.START_OBJECT;
        }
        if (type == ValueType.STRING) {
            return JsonParser.Event.VALUE_STRING;
        }
        if (type == ValueType.NULL) {
            return JsonParser.Event.VALUE_NULL;
        }
        if (type == ValueType.BOOLEAN) {
            return this.reader.valueAsBoolean() ? JsonParser.Event.VALUE_TRUE : JsonParser.Event.VALUE_FALSE;
        }
        if (type == ValueType.INTEGER || type == ValueType.DOUBLE) {
            return JsonParser.Event.VALUE_NUMBER;
        }
        throw new JsonException("Unknown ValueType " + (Object)((Object)type));
    }

    public JsonParser.Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            JsonType enclosingType = this.reader.enclosingType();
            if (this.parseKey) {
                this.parseKey = false;
                return this.currentValue(this.reader.getValueType());
            }
            if (this.reader.hasNext()) {
                ValueType valueType = this.reader.next();
                if (enclosingType == JsonType.OBJECT) {
                    this.parseKey = true;
                    return JsonParser.Event.KEY_NAME;
                }
                this.parseKey = false;
                return this.currentValue(valueType);
            }
            this.parseKey = false;
            if (enclosingType == JsonType.OBJECT) {
                this.reader.endObject();
                return JsonParser.Event.END_OBJECT;
            }
            if (enclosingType == JsonType.ARRAY) {
                this.reader.endArray();
                return JsonParser.Event.END_ARRAY;
            }
            throw new JsonException("Reached end of stream, next should not be called.");
        }
        catch (JsonStreamException e) {
            throw this._wrapException(e);
        }
    }

    public String getString() {
        try {
            if (this.parseKey) {
                return this.reader.name();
            }
            return this.reader.valueAsString();
        }
        catch (JsonStreamException e) {
            throw this._wrapException(e);
        }
    }

    public boolean isIntegralNumber() {
        return this.reader.getValueType() == ValueType.INTEGER;
    }

    public int getInt() {
        try {
            return this.reader.valueAsInt();
        }
        catch (JsonStreamException e) {
            throw this._wrapException(e);
        }
    }

    public long getLong() {
        try {
            return this.reader.valueAsLong();
        }
        catch (JsonStreamException e) {
            throw this._wrapException(e);
        }
    }

    public BigDecimal getBigDecimal() {
        try {
            return new BigDecimal(this.reader.valueAsString());
        }
        catch (JsonStreamException e) {
            throw this._wrapException(e);
        }
    }

    public JsonLocation getLocation() {
        return new Location(this.reader.row(), this.reader.column());
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw this._wrapException(e);
        }
    }

    private JsonException _wrapException(Exception e) {
        JsonException newException = null;
        if (e instanceof JsonStreamException) {
            JsonStreamException jse = (JsonStreamException)e;
            newException = new JsonParsingException(e.getMessage(), (Throwable)e, (JsonLocation)new Location(jse.getRow(), jse.getColumn()));
        } else {
            newException = new JsonException(e.getMessage(), (Throwable)e);
        }
        return JsonStreamException.niceTrace(newException);
    }

    static class Location
    implements JsonLocation {
        final long lineNumber;
        final long columnNumber;

        public Location(long lineNumber, long columnNumber) {
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public long getStreamOffset() {
            return -1L;
        }

        public long getLineNumber() {
            return this.lineNumber;
        }

        public long getColumnNumber() {
            return this.columnNumber;
        }
    }
}

